%%
%% %CopyrightBegin%
%%
%% Copyright Ericsson AB 2002-2016. All Rights Reserved.
%%
%% Licensed under the Apache License, Version 2.0 (the "License");
%% you may not use this file except in compliance with the License.
%% You may obtain a copy of the License at
%%
%%     http://www.apache.org/licenses/LICENSE-2.0
%%
%% Unless required by applicable law or agreed to in writing, software
%% distributed under the License is distributed on an "AS IS" BASIS,
%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%% See the License for the specific language governing permissions and
%% limitations under the License.
%%
%% %CopyrightEnd%
%%

-define(priv_dir,"log_private").
-define(MAIN_PORT,3289).
-define(ACCEPT_TIMEOUT,20000).

%% Target information generated by test_server:init_target_info/0
%% Once initiated, this information will never change!!
-record(target_info, {os_family,       % atom(); win32 | unix
		      os_type,         % result of os:type()
		      host,            % string(); the name of the target machine
		      version,         % string()
		      system_version,  % string()
		      root_dir,        % string()
		      emulator,        % string()
		      otp_release,     % string()
		      username,        % string()
		      cookie,          % string(); Cookie for target node
		      naming,          % string(); "-name" | "-sname"
		      master}).        % string(); Was used for OSE's master
				       % node for main target and slave nodes.
				       % For other platforms the target node
				       % itself is master for slave nodes

%% Temporary information generated by test_server_ctrl:read_parameters/X
%% This information is used when starting the main target, and for 
%% initiating the #target_info record.
-record(par, {type,
	      target,
	      naming,
	      master,
	      cookie}).
	      

-record(cover, {app,    % application; Name | none
		file,   % cover spec file
		incl,   % explicitly include modules
		excl,   % explicitly exclude modules
		level,  % analyse level; details | overview
		mods,   % actually cover compiled modules
		stop=true,   % stop cover after analyse; boolean()
		cross}).% cross cover analyse info
