# Copyright 2014-2015 Canonical Ltd.  This software is licensed under the
# GNU Affero General Public License version 3 (see the file LICENSE).

"""Model for filtering a selection of boot resources."""

from __future__ import (
    absolute_import,
    print_function,
    unicode_literals,
    )

str = None

__metaclass__ = type
__all__ = [
    'BootSourceSelection',
    ]


from django.db.models import (
    CharField,
    ForeignKey,
)
import djorm_pgarray.fields
from maasserver import DefaultMeta
from maasserver.models.cleansave import CleanSave
from maasserver.models.timestampedmodel import TimestampedModel


class BootSourceSelection(CleanSave, TimestampedModel):
    """A set of selections for a single `BootSource`."""

    class Meta(DefaultMeta):
        """Needed for South to recognize this model."""
        unique_together = ("boot_source", "os", "release")

    boot_source = ForeignKey('maasserver.BootSource', blank=False)

    os = CharField(
        max_length=20, blank=True, default='',
        help_text="The operating system for which to import resources.")

    release = CharField(
        max_length=20, blank=True, default='',
        help_text="The OS release for which to import resources.")

    arches = djorm_pgarray.fields.ArrayField(dbtype="text")

    subarches = djorm_pgarray.fields.ArrayField(dbtype="text")

    labels = djorm_pgarray.fields.ArrayField(dbtype="text")
