#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
trace/generated-tracers.h
"""

__author__     = "Lluís Vilanova <vilanova@ac.upc.edu>"
__copyright__  = "Copyright 2012-2014, Lluís Vilanova <vilanova@ac.upc.edu>"
__license__    = "GPL version 2 or (at your option) any later version"

__maintainer__ = "Stefan Hajnoczi"
__email__      = "stefanha@linux.vnet.ibm.com"


from tracetool import out


def generate(events, backend):
    out('/* This file is autogenerated by tracetool, do not edit. */',
        '',
        '#ifndef TRACE__GENERATED_TRACERS_H',
        '#define TRACE__GENERATED_TRACERS_H',
        '',
        '#include "qemu-common.h"',
        '')

    backend.generate_begin(events)

    for e in events:
        out('',
            'static inline void %(api)s(%(args)s)',
            '{',
            api=e.api(),
            args=e.args)

        if "disable" not in e.properties:
            backend.generate(e)

        out('}')

    backend.generate_end(events)

    out('#endif /* TRACE__GENERATED_TRACERS_H */')
