/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis.directed;

import java.io.File;
import java.util.List;
import java.util.Set;
import net.sf.picard.analysis.MetricAccumulationLevel;
import net.sf.picard.analysis.directed.CollectTargetedMetrics;
import net.sf.picard.analysis.directed.TargetMetricsCollector;
import net.sf.picard.analysis.directed.TargetedPcrMetricsCollector;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.samtools.SAMReadGroupRecord;

public class CollectTargetedPcrMetrics
extends CollectTargetedMetrics {
    @Usage
    public final String USAGE = "Calculates a set of metrics to Illumina Truseq Custom Amplicon sequencing from an aligned SAMor BAM file. If a reference sequence is provided, AT/GC dropout metrics will be calculated, and the PER_TARGET_COVERAGE option can be used to output GC and mean coverage information for every target.";
    @Option(shortName="AI", doc="An interval list file that contains the locations of the baits used.")
    public File AMPLICON_INTERVALS;
    @Option(shortName="N", doc="Custom amplicon set name. If not provided it is inferred from the filename of the AMPLICON_INTERVALS intervals.", optional=true)
    public String CUSTOM_AMPLICON_SET_NAME;

    @Override
    protected File getProbeIntervals() {
        return this.AMPLICON_INTERVALS;
    }

    @Override
    protected String getProbeSetName() {
        return this.CUSTOM_AMPLICON_SET_NAME;
    }

    public static void main(String[] argv) {
        System.exit(new CollectTargetedPcrMetrics().instanceMain(argv));
    }

    @Override
    protected TargetMetricsCollector makeCollector(Set<MetricAccumulationLevel> accumulationLevels, List<SAMReadGroupRecord> samRgRecords, ReferenceSequenceFile refFile, File perTargetCoverage, File targetIntervals, File probeIntervals, String probeSetName) {
        return new TargetedPcrMetricsCollector(accumulationLevels, samRgRecords, refFile, perTargetCoverage, targetIntervals, probeIntervals, probeSetName);
    }
}

