/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFileWalker;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SequenceUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.Option;

public abstract class SinglePassSamProgram
extends CommandLineProgram {
    @Option(shortName="I", doc="Input SAM or BAM file.")
    public File INPUT;
    @Option(shortName="O", doc="File to write the output to.")
    public File OUTPUT;
    @Option(shortName="R", doc="Reference sequence fasta", optional=true)
    public File REFERENCE_SEQUENCE;
    @Option(doc="If true (default), then the sort order in the header file will be ignored.", shortName="AS")
    public boolean ASSUME_SORTED = true;
    @Option(doc="Stop after processing N reads, mainly for debugging.")
    public long STOP_AFTER = 0L;
    private static final Log log = Log.getInstance(SinglePassSamProgram.class);

    @Override
    protected final int doWork() {
        SinglePassSamProgram.makeItSo(this.INPUT, this.REFERENCE_SEQUENCE, this.ASSUME_SORTED, this.STOP_AFTER, Arrays.asList(this));
        return 0;
    }

    public static void makeItSo(File input, File referenceSequence, boolean assumeSorted, long stopAfter, Collection<SinglePassSamProgram> programs) {
        ReferenceSequenceFileWalker walker;
        IOUtil.assertFileIsReadable((File)input);
        SAMFileReader in = new SAMFileReader(input);
        if (referenceSequence == null) {
            walker = null;
        } else {
            IOUtil.assertFileIsReadable((File)referenceSequence);
            walker = new ReferenceSequenceFileWalker(referenceSequence);
            if (!in.getFileHeader().getSequenceDictionary().isEmpty()) {
                SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)in.getFileHeader().getSequenceDictionary(), (SAMSequenceDictionary)walker.getSequenceDictionary());
            }
        }
        SAMFileHeader.SortOrder sort = in.getFileHeader().getSortOrder();
        if (sort != SAMFileHeader.SortOrder.coordinate) {
            if (assumeSorted) {
                log.warn(new Object[]{"File reports sort order '" + sort + "', assuming it's coordinate sorted anyway."});
            } else {
                throw new PicardException("File " + input.getAbsolutePath() + " should be coordinate sorted but " + "the header says the sort order is " + sort + ". If you believe the file " + "to be coordinate sorted you may pass ASSUME_SORTED=true");
            }
        }
        boolean anyUseNoRefReads = false;
        for (SinglePassSamProgram program : programs) {
            program.setup(in.getFileHeader(), input);
            anyUseNoRefReads = anyUseNoRefReads || program.usesNoRefReads();
        }
        ProgressLogger progress = new ProgressLogger(log);
        for (SAMRecord rec : in) {
            ReferenceSequence ref = walker == null || rec.getReferenceIndex() == -1 ? null : walker.get(rec.getReferenceIndex().intValue());
            for (SinglePassSamProgram program : programs) {
                program.acceptRead(rec, ref);
            }
            progress.record(rec);
            if ((stopAfter <= 0L || progress.getCount() < stopAfter) && (anyUseNoRefReads || rec.getReferenceIndex() != -1)) continue;
            break;
        }
        in.close();
        for (SinglePassSamProgram program : programs) {
            program.finish();
        }
    }

    protected boolean usesNoRefReads() {
        return true;
    }

    protected abstract void setup(SAMFileHeader var1, File var2);

    protected abstract void acceptRead(SAMRecord var1, ReferenceSequence var2);

    protected abstract void finish();
}

