/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.pileup;

import htsjdk.samtools.util.PeekableIterator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.broadinstitute.gatk.utils.pileup.PerSamplePileupElementTracker;
import org.broadinstitute.gatk.utils.pileup.PileupElement;
import org.broadinstitute.gatk.utils.pileup.PileupElementTracker;

class MergingPileupElementIterator<PE extends PileupElement>
implements Iterator<PE> {
    private final PriorityQueue<PeekableIterator<PE>> perSampleIterators;

    public MergingPileupElementIterator(PerSamplePileupElementTracker<PE> tracker) {
        this.perSampleIterators = new PriorityQueue(Math.max(1, tracker.getSamples().size()), new PileupElementIteratorComparator());
        for (String sample : tracker.getSamples()) {
            PileupElementTracker<PE> trackerPerSample = tracker.getElements(sample);
            if (trackerPerSample.size() == 0) continue;
            this.perSampleIterators.add(new PeekableIterator(trackerPerSample.iterator()));
        }
    }

    @Override
    public boolean hasNext() {
        return !this.perSampleIterators.isEmpty();
    }

    @Override
    public PE next() {
        PeekableIterator currentIterator = (PeekableIterator)this.perSampleIterators.remove();
        PileupElement current = (PileupElement)currentIterator.next();
        if (currentIterator.hasNext()) {
            this.perSampleIterators.add(currentIterator);
        }
        return (PE)current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from a merging iterator.");
    }

    private class PileupElementIteratorComparator
    implements Comparator<PeekableIterator<PE>> {
        private PileupElementIteratorComparator() {
        }

        @Override
        public int compare(PeekableIterator<PE> lhs, PeekableIterator<PE> rhs) {
            return ((PileupElement)rhs.peek()).getOffset() - ((PileupElement)lhs.peek()).getOffset();
        }
    }
}

