/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 14:18:51 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureKeyQualifierPredicate;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.io.EmblStreamFeature;
import uk.ac.sanger.artemis.io.GenbankStreamFeature;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.sequence.Bases;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class FeatureKeyQualifierPredicate_ESTest extends FeatureKeyQualifierPredicate_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      Key key0 = Key.CDS;
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = null;
      try {
        featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, (String) null, (String) null, true, true, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.FeatureKeyQualifierPredicate", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      Key key0 = Key.CDS;
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "Results Manager", "Results Manager", true, true);
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("Results Manager");
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("db_id");
      Feature feature0 = entry0.createFeature();
      featureKeyQualifierPredicate0.testPredicate(feature0);
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate((Key) null, "2(.F", "ffG>", false, false, false);
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      Key key0 = new Key((String) null);
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = null;
      try {
        featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, (String) null, (String) null, true, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.FeatureKeyQualifierPredicate", e);
      }
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      Key key0 = Key.CDS;
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "ZG<s");
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature(genbankStreamFeature0);
      Feature feature0 = new Feature(emblStreamFeature0);
      boolean boolean0 = featureKeyQualifierPredicate0.testPredicate(feature0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate((Key) null, "", "");
      // Undeclared exception!
      try { 
        featureKeyQualifierPredicate0.testPredicate((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.FeatureKeyQualifierPredicate", e);
      }
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate((Key) null, "", false);
  }
}
