/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.reflect;

import java.util.LinkedList;
import net.sf.jiapi.reflect.Instruction;
import net.sf.jiapi.reflect.InstructionList;

public class TryBlock {
    private InstructionList instructions;
    private LinkedList<ExceptionHandler> exceptionHandlers = new LinkedList();

    TryBlock(InstructionList instructions) {
        this.instructions = instructions;
    }

    void addExceptionHandler(String name, Instruction handlerStart) {
        this.exceptionHandlers.add(new ExceptionHandler(name, handlerStart));
    }

    public ExceptionHandler[] getExceptionHandlers() {
        ExceptionHandler[] handlers = new ExceptionHandler[this.exceptionHandlers.size()];
        handlers = this.exceptionHandlers.toArray(handlers);
        return handlers;
    }

    public InstructionList getInstructionList() {
        return this.instructions;
    }

    public class ExceptionHandler {
        private Instruction handlerStart;
        private String name;

        ExceptionHandler(String name, Instruction handlerStart) {
            this.name = name;
            this.handlerStart = handlerStart;
        }

        public Instruction getHandlerStart() {
            return this.handlerStart;
        }

        public String getName() {
            return this.name;
        }
    }
}

