//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Plot2D/ColorMapCanvas.h
//! @brief     Defines class ColorMapCanvas
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_PLOT2D_COLORMAPCANVAS_H
#define BORNAGAIN_GUI_VIEW_PLOT2D_COLORMAPCANVAS_H

#include <QWidget>

class ColorMap;
class FontScalingEvent;
class IntensityDataItem;
class PlotStatusLabel;
class QCustomPlot;

//! Contains ColorMap for intensity data presentation, and provides control of font size.
//! Controls appearance of the status string.

class ColorMapCanvas : public QWidget {
    Q_OBJECT
public:
    explicit ColorMapCanvas(QWidget* parent = nullptr);

    void setIntensityItem(IntensityDataItem* intensityDataItem);

    ColorMap* colorMap();
    QCustomPlot* customPlot();

    void setStatusLabelEnabled(bool flag);

private:
    ColorMap* m_colorMap;
    FontScalingEvent* m_canvasEvent;
    PlotStatusLabel* m_statusLabel;
};

#endif // BORNAGAIN_GUI_VIEW_PLOT2D_COLORMAPCANVAS_H
