"""
Collection of utils for testing
"""

import bornagain as ba
from bornagain import deg #, ba_plot as bp


def get_simulation_MiniGISAS(sample):
    n = 25
    detector = ba.SphericalDetector(n, -2 * deg, 2 * deg, n, 0, 2 * deg)
    beam = ba.Beam(1, 0.1, 0.2 * deg)
    return ba.ScatteringSimulation(beam, sample, detector)

def diff_MiniGISAS(sample1, sample2):
    """
    Run standard GISAS simulation for two sample models, and return diff of results.
    """
    n = 11
    detector = ba.SphericalDetector(n, -2 * deg, 2 * deg, n, 0, 2 * deg)
    beam = ba.Beam(1, 0.1, 0.2 * deg)

    data1 = ba.ScatteringSimulation(beam, sample1, detector).simulate()
    data2 = ba.ScatteringSimulation(beam, sample2, detector).simulate()

    #bp.parse_args()
    #bp.plot_simulation_result(data1)
    return ba.meanRelativeDifference(data1, data2)
