
Notable changes in 0.28 as compared to 0.27.1
=============================================

May require attention
---------------------

* The default install PREFIX is now "/usr/local".

* BINDIR, DOCDIR, LIBDIR, and MANDIR settings no longer side-step
  DESTDIR.  i.e. `make DESTDIR=/x MANDIR=/y` install will install the
  manpages to "/x/y" not just "/y".

* The index format has changed, which will trigger a full index
  rebuild on the next index run, making that run more expensive than
  usual.

* When given `--xdev`, `bup save` should no longer skip directories
  that are explicitly listed on the command line when the directory is
  both on a separate filesystem, and a subtree of another path listed
  on the command line.  Previously `bup save --xdev / /usr` could skip
  "/usr" if it was on a separate filesystem from "/".

* Tags along a branch are no longer shown in the branch's directory in
  the virtual filesystem (VFS).  i.e. given `bup tag special
  /foo/latest`, "/foo/special" will no longer be visible via `bup ls`,
  `bup web`, `bup fuse`, etc., but the tag will still be available as
  "/.tag/special".

General
-------

* bup now provides experimental `rm` and `gc` subcommands, which
  should allow branches and saves to be deleted, and their storage
  space reclaimed (assuming nothing else refers to the relevant data).
  For the moment, these commands require an `--unsafe` argument and
  should be treated accordingly.  Although if an attempt to `join` or
  `restore` the data you still care about after a `gc` succeeds,
  that's a fairly encouraging sign that the commands worked correctly.
  (The `t/compare-trees` command in the source tree can be used to
  help test before/after results.)

  Note that the current `gc` command is probabilistic, which means it
  may not remove *all* of the obsolete data from the repository, but
  also means that the command should be fairly efficient, even for
  large repositories.

* bup may have less impact on the filesystem cache.  It now attempts
  to leave the cache roughly the way it found it when running a `save`
  or `split`.

* A specific Python can be specified at `./configure` time via PYTHON,
  i.e. `PYTHON=/some/python ./configure`, and that Python will be
  embedded in all of the relevant scripts as an explicit "#!/..." line
  during `make install`.

* `bup web` will now attempt an orderly shutdown when it receives a
  SIGTERM.

* `bup web` will listen on a filesystem socket when given an address
  like "unix://...".

* bup no longer limits the number of files in a directory to 100000.
  The limit is now UINT_MAX.

* `bup fuse` now has a `--verbose` argument, and responds to
  `--debug`.

Bugs
----

* bup save should not fail when asked to save a subdirectory of a
  directory that was completely up to date in the index.  Previously
  this could cause a "shalists" assertion failure.

* The way bup writes the data to disk (the packfiles in particular),
  should be a bit safer now if there is a coincident power failure or
  system crash.

* A problem has been fixed that could cause bup to ignore the current
  TZ setting when computing the local time.

* bup should no longer generate broken commits when the timezone
  offset is not an integer number of hours
  (e.g. TZ=Australia/Adelaide).

* `bup midx --output` should now work when used with `--auto` or
  `--force`.

* `bup import-rsnapshot` should exit with a status of 1, not -1.

* bup should be more likely to get the data to permanent storage
  safely on OS X, which appears to follow a surprising interpretation
  of the `fsync()` specification.

* `bup web` should handle non-ASCII paths better.  It will no longer
  treat them as (and try to convert them to) Unicode (which they're
  not).

* `bup restore` should no longer crash when an attempt to remove an
  xattr returns EACCES.

Build system
------------

* The tests can now be run in parallel (and possibly much more
  quickly) via `make -j check`.

* The build system now creates and uses cmd/bup-python which refers to
  the `./configure` selected python.


Thanks to (at least)
====================

Aidan Hobson Sayers, Ben Kelly, Ben Wiederhake, Brandon Smith, Brian Minton,
David Kettler, Frank Gevaerts, Gabriel Filion, Greg Troxel, James Lott,
Karl-Philipp Richter, Luis Sanchez Sanchez, Marcus Schopen, Mark J
Hewitt, Markus, Mathieu Schroeter, Michael March, Nimen Nachname, Nix,
Patrick Rouleau, Paul Kronenwetter, Rob Browning, Robert Edmonds,
Simon Persson, Tadej Janež, Thomas Klausner, Tilo Schwarz, Tim
Riemenschneider, Wayne Scott, pspdevel, and stevelr
