/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/


#ifndef _FILL_PATCH_H_
#define _FILL_PATCH_H_

#include "interface.H"
#include "boundary.H"
#include "interpolator.H"
#include "restrictor.H"

//void internal_copy(MultiFab& r, int destgrid, int srcgrid, const Box& b);

Real
inner_product (const MultiFab& r,
               const MultiFab& s);

// returns grid number if patch is contained in a single grid, -1 otherwise.

// int find_patch(const Box& region, const MultiFab& r);

// Fills all ghost cells that can be obtained from other grids or
// from the boundary conditions.  If w is between 0 and border(),
// inclusive, it will be used as the width of the regions to be
// filled---otherwise, the full width will be used.

void
sync_borders (MultiFab&                 r,
              const level_interface&    lev_interface,
              const amr_boundary* bdy);

void
fill_borders (MultiFab&                 r,
              const level_interface&    lev_interface,
              const amr_boundary* bdy,
              int                       w,
              bool                      hg_dense);

void
clear_part_interface (MultiFab&              r,
                      const level_interface& lev_interface);

void
interpolate_patch (MultiFab&                     dmf,
                   int                           dgrid,
                   const Box&                    region,
                   const MultiFab&               r,
                   const IntVect&                rat,
                   const amr_interpolator& interp,
                   const level_interface&        lev_interface);

void
restrict_level (MultiFab&                   dest,
                MultiFab&                   r,
                const IntVect&              rat,
                const amr_restrictor& restric,
                const level_interface&      lev_interface,
                const amr_boundary*   bdy);

void
restrict_level (MultiFab&                   dest,
                MultiFab&                   r,
                const IntVect&              rat);

#endif /*_FILL_PATCH_H_*/
