/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#include "REAL.H"
#include "CONSTANTS.H"
#include "BCTypes.H"

#define DIMS lo_1,lo_2,hi_1,hi_2

c *************************************************************************
c ** SETVELBC **
c ** Impose the physical boundary conditions on the velocity (u,v)
c *************************************************************************

      subroutine setvelbc(vel,DIMS,bc,irz,visc_coef,dx,time)

      implicit none

      integer DIMS
      REAL_T   vel(lo_1-3:hi_1+3,lo_2-3:hi_2+3,2)
      integer bc(2,2)
      integer irz
      REAL_T visc_coef
      REAL_T dx(2)
      REAL_T time

c     Local variables
      integer is,ie,js,je,i,j
      integer ilo,ihi
      integer ng

      is = lo_1
      ie = hi_1
      js = lo_2
      je = hi_2

c     NOTE: IF BC == WALL, THESE VALUES ARE DEFINED ON THE EDGE OF THE PHYSICAL
c           BOUNDARY, NOT IN THE GHOST CELL

      ilo = cvmgt(is-3,is,BCX_LO .eq. INTERIOR .or. BCX_LO .eq. PERIODIC)
      ihi = cvmgt(ie+3,ie,BCX_HI .eq. INTERIOR .or. BCX_HI .eq. PERIODIC)

      if (BCY_LO .eq. WALL) then

        do ng = 1,3
        do i = ilo,ihi
          vel(i,js-ng,2) = zero
        enddo
        enddo

        do i = ilo,ihi
          vel(i,js-1,1) = (fifteen*vel(i,js  ,1) - ten*vel(i,js+1,1) + 
     $                       three*vel(i,js+2,1)) / eight
          vel(i,js-2,1) = vel(i,js-1,1)
          vel(i,js-3,1) = vel(i,js-1,1)
        enddo

        if (visc_coef .gt. zero) then
          do ng = 1,3
          do i = ilo,ihi
            vel(i,js-ng,1) = zero
          enddo
          enddo
        endif

      elseif (BCY_LO .eq. INLET) then

        call velinflow(vel(lo_1-3,lo_2-3,2),DIMS,time,dx,1,0)

        do ng = 1,3
        do i = is-3,ie+3
          vel(i,js-ng,1) = zero
        enddo
        enddo

      elseif (BCY_LO .eq. OUTLET) then

        do ng = 1,3
        do i = ilo,ihi
          vel(i,js-ng,1) = vel(i,js,1)
          vel(i,js-ng,2) = vel(i,js,2)
        enddo
        enddo

      endif

      if (BCY_HI .eq. WALL) then

        do ng = 1,3
        do i = ilo,ihi
          vel(i,je+ng,2) = zero
        enddo
        enddo

        do i = ilo,ihi
          vel(i,je+1,1) = (fifteen*vel(i,je  ,1) - ten*vel(i,je-1,1) + 
     $                       three*vel(i,je-2,1)) / eight
          vel(i,je+2,1) = vel(i,je+1,1)
          vel(i,je+3,1) = vel(i,je+1,1)
        enddo

        if (visc_coef .gt. zero) then
          do ng = 1,3
          do i = ilo,ihi
            vel(i,je+ng,1) = zero
          enddo
          enddo
        endif

      elseif (BCY_HI .eq. INLET) then

        call velinflow(vel(lo_1-3,lo_2-3,2),DIMS,time,dx,1,1)

        do ng = 1,3
        do i = is-3,ie+3
          vel(i,je+ng,1) = zero
        enddo
        enddo

      elseif (BCY_HI .eq. OUTLET) then

        do ng = 1,3
        do i = ilo,ihi
          vel(i,je+ng,1) = vel(i,je,1)
          vel(i,je+ng,2) = vel(i,je,2)
        enddo
        enddo

      endif

      if (BCX_LO .eq. WALL) then

        do ng = 1,3
        do j = js-3,je+3 
          vel(is-ng,j,1) = zero
        enddo
        enddo

        do j = js-3,je+3 
          vel(is-1,j,2) = (fifteen*vel(is  ,j,2) - ten*vel(is+1,j,2) + 
     $                       three*vel(is+2,j,2)) / eight
          vel(is-2,j,2) = vel(is-1,j,2)
          vel(is-3,j,2) = vel(is-1,j,2)
        enddo

        if (visc_coef .gt. zero .and. irz .eq. 0) then
          do ng = 1,3
          do j = js-3,je+3
            vel(is-ng,j,2) = zero
          enddo
          enddo
        endif

        if (irz .eq. 1) then
          do ng = 1,3
          do j = js-3,je+3 
             vel(is-ng,j,2) = vel(is+ng-1,j,2)
          enddo
          enddo
        endif

      elseif (BCX_LO .eq. INLET) then

        call velinflow(vel(lo_1-3,lo_2-3,1),DIMS,time,dx,0,0)

        do ng = 1,3
        do j = js-3,je+3
          vel(is-ng,j,2) = zero
        enddo
        enddo

      elseif (BCX_LO .eq. OUTLET) then

        do ng = 1,3
        do j = js-3,je+3
          vel(is-ng,j,1) = vel(is,j,1)
          vel(is-ng,j,2) = vel(is,j,2)
        enddo
        enddo

      endif

      if (BCX_HI .eq. WALL) then

        do ng = 1,3
        do j = js-3,je+3 
          vel(ie+ng,j,1) = zero
        enddo
        enddo

        do j = js-3,je+3 
          vel(ie+1,j,2) = (fifteen*vel(ie  ,j,2) - ten*vel(ie-1,j,2) + 
     $                       three*vel(ie-2,j,2)) / eight
          vel(ie+2,j,2) = vel(ie+1,j,2)
          vel(ie+3,j,2) = vel(ie+1,j,2)
        enddo

        if (visc_coef .gt. zero) then
          do ng = 1,3
          do j = js-3,je+3
            vel(ie+ng,j,2) = zero
          enddo
          enddo
        endif

      elseif (BCX_HI .eq. INLET) then

        call velinflow(vel(lo_1-3,lo_2-3,1),DIMS,time,dx,0,1)

        do ng = 1,3
        do j = js-3,je+3
          vel(ie+ng,j,2) = zero
        enddo
        enddo

      elseif (BCX_HI .eq. OUTLET) then

        do ng = 1,3
        do j = js-3,je+3 
          vel(ie+ng,j,1) = vel(ie,j,1)
          vel(ie+ng,j,2) = vel(ie,j,2)
        enddo
        enddo

      endif

      return
      end
