/****************************************************************************
 *    lib/b/Program.h - This file is part of coala							*
 *																			*
 *    Copyright (C) 2009-2010  Torsten Grote								*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/


#ifndef bprogram_h
#define bprogram_h

#include <string>
#include <vector>
#include <map>

#include "../options.h"
#include "../c/Program.h"
#include "../c/Formula.h"

#include "FluentDefinition.h"
#include "StaticRule.h"
#include "DynamicRule.h"
#include "ExecutableRule.h"
#include "QQuery.h"
/*
#include "ActionDefinition.h"
#include "Query.h"
#include "RQuery.h"
#include "LTLQuery.h"
#include "Printer.h"
*/

namespace B {

using namespace C;

class Program : public C::Program
{
public:
	Program(Coala::CompilerOptions*);
	
	virtual ~Program();

	void print(Printer* p);
/*
	void setLine(int* line);
	
	virtual Variable* addVariable(string*);
	virtual Formula* addFormula(char, Formula*);
	virtual Formula* addFormula(char, vector<Formula*>*);
	
	bool addAction(FluentAction* action);
	void addActionDef(Formula* action_list, Types* types=0);
	bool addFluent(FluentAction* fluent);

*/
	void addFluentDef(Formula* fluent_list, bool defined=false, Types* types=NULL);

	void addStaticRule(Formula* F, Formula* G, Types* types=NULL);
	void addDynamicRule(Formula* A, Formula* F, Formula* G=NULL, Types* types=NULL);
	void addExecutableRule(Formula* A, Formula* F, Types* types=NULL);

	void addNonexecutableRule(Formula* A, Formula* G, Types* types=NULL);
	void addInitiallyRule(Formula* F, Types* types=NULL);
	void addQQuery(string type, Formula* A, string time, Types* types=NULL);
/*
	void addInertialRule(Formula* F, Types* types=NULL);
	void addCausesRule(Formula* A, Formula* F, Formula* G, Types* types=NULL);
	void addAlwaysRule(Formula* G, Types* types=NULL);
	void addMayCauseRule(Formula* A, Formula* F, Formula* G, Types* types=NULL);

	void addRQuery(Formula* F, Formula* A, string time, Types* types=NULL);
	LTLNode* getLTLNode(int, LTLNode*, LTLNode*, Formula* content=NULL);
	void addLTLQuery(LTLNode*);
*/
protected:
	vector<B::StaticRule*> static_rules_;
	vector<B::DynamicRule*> dynamic_rules_;
	vector<B::ExecutableRule*> executable_rules_;
	vector<B::FluentDefinition*> fluent_definitions_;
	vector<B::QQuery*> qqueries_;
/*
	void transformFormula(Formula* I, string type);
	
	int* line_;
	Coala::CompilerOptions* options_;
	int ltl_node_num_;
	Printer* p_;
	map<string, FluentAction*> actions_;
	map<string, FluentAction*> fluents_;
	map<string, Variable*> variables_;

	vector<RQuery*> rqueries_;
	LTLQuery* ltlquery_;


	vector<ActionDefinition*> action_definitions_;

*/
};
}; // end of package namespace

#endif // BPROGRAM_H
