DACSGRID(1)                  DACS Commands Manual                  DACSGRID(1)



[1mNAME[0m
       dacsgrid - administer grid-based one-time passwords

[1mSYNOPSIS[0m
       [1mdacsgrid [22m[[34m[1mdacsoptions[0m[1m[22m[1]] [[1m-challenge[22m] [[1m-clen [4m[22mnum[24m] [[1m-copy [4m[22mvfs_uri[24m]
                [[1m-dec [4m[22mtoken[24m] [[1m-delete[22m] [[1m-disable[22m] [[1m-enable[22m] [[1m-enc [4m[22mchallenge[24m]
                [[1m-expired[22m]
                [[1m-flat[22m] [[1m-get[22m] [[1m-grid [4m[22mstr[24m] [[1m-h [22m| [1m-help[22m] [[1m-html[22m] [[1m-htmlcss[22m]
                [[1m-inkeys [4m[22mitem_type[24m] [[1m-lifetime [4m[22mndays[24m] [[1m-list[22m] [[1m-long[22m]
                [[1m-ncols [4m[22mnum[24m]
                [[1m-nrows [4m[22mnum[24m] [[1m-outkeys [4m[22mitem_type[24m] [[1m-pin [22m[[4mnum[24m]] [[1m-refresh[22m]
                [[1m-rnd[22m] [[1m-seed [4m[22mstr[24m]
                [[1m-serial[22m] [[1m-set[22m] [[1m-size[22m] [[1m-test[22m] [[1m-text[22m]
                [[1m-validate [4m[22mchallenge[24m [4mresponse[24m]
                [[1m-vfs [4m[22mvfs_uri[24m]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       The [1mdacsgrid [22mutility provides software-based one-time passwords for
       [1mDACS [22mauthentication using a challenge-response architecture. It
       administers accounts that are used by the [34m[1mlocal_grid_authenticate[0m[1m[22m[2]
       authentication module. These accounts are completely separate from the
       accounts used by [34m[1mlocal_passwd_authenticate[0m[1m[22m[3] or any other [1mDACS[0m
       authentication module.

       [1mdacsgrid [22mgenerates a rectangular grid of cells. Each cell consists of a
       letter, followed by a digit, followed by a letter, yielding 6,760
       (26*10*26) possible three-character-long strings. The contents of each
       cell are generated from cryptographically-strong pseudo-random bytes.
       The maximum grid size is 99 rows by 26 columns, and the minimum grid
       size is 3 by 3. The columns are labelled A through Z and the rows are
       labelled 1 through 99. For recommended grid sizes, it is highly likely
       that each grid that is generated is unique and therefore that each user
       will be assigned a different grid.

       Here is a 10x10 grid (the default size):

                A   B   C   D   E   F   G   H   I   J
            1  x7m p7m k4c q9s q2k d9l s5m r8c y3v g2m
            2  o0c t6h q7k l3w p8a q3e b9c l0w z8y c8v
            3  v8n n1w r6i i0g e9y q1n p0g g9v x4y c5u
            4  z8a o9d l1e e8n u8z h3y p2s b9z c6w d5f
            5  x8y o2a y4g d9i s4p c9n c1e m5z o6j m0f
            6  p2s x4c a2x p4f w7y b8k e6c q9g q5v s4z
            7  b8k r4s r2p z5x v3e s0h h5l z6y e9o g6m
            8  r5x m4r a1w f8c f5g l2z q7j r4m w0c x9a
            9  p7s r3g i7c p8a t5x c4h h0k k9d i7k r9n
           10  w4l v0a p9g i0l v2n b8h v9j s0y r3k v0m

           Serial: 2497a62a83ad4bc4
           Created: Mon Aug 14 10:25:03 2006 PDT

       A cell is identified by its column label (a letter) followed by its row
       label (a number); e.g., in the example above, cell F6 has the value
       b8k.

       Each grid is assigned a random (and presumably unique) identification
       string (labelled "Serial" in the example above); this string is stored
       on the server with other grid account data. It can be displayed by a
       jurisdiction at login time as a way of authenticating itself to a user,
       provided it is kept confidential (one approach might be for each of the
       parties to supply a different half of the identification string to the
       other).

       At authentication time, the user is presented with a randomly-generated
       challenge that is appropriate for the user's grid. The challenge is
       displayed to the user; e.g., "A3, C9, B1, F9". The grid's serial
       number, or a portion of it, might also be displayed. The user must
       consult his grid to locate each of the cells for the given challenge
       and enter their contents as the password. Letters are case insensitive,
       blanks, tabs, and commas are ignored. For the grid and challenge above,
       the user would enter the following characters as the password:

           v8ni7cp7mc4h

       Note that a challenge may ask for the same cell more than once.

       A challenge is valid for a configurable length of time after which it
       can no longer be used for authentication; see [34m[1mAUTH_GRID_CHALLENGE_SECS[0m
       [4].

       To judge how long a challenge should be, assume that user-selected
       passwords are chosen randomly and uniformly from approximately 100
       characters available on a keyboard. This is a very generous assumption
       that is seldom realized in practice. A grid challenge of four cells is
       much stronger than a user-selected password of six characters (69604
       vs. 1006) and a grid challenge of five cells is much stronger than a
       user-selected password of nine characters (69605 vs. 1009). When
       compared to typical user passwords, however, a grid challenge of three
       cells is probably about as strong as a user-chosen password of seven or
       eight characters.

       Grids are accessed through [1mDACS's [22mvirtual filestore using item type
       auth_grid. It is assumed that file permissions on the database of grids
       are such that all access is limited to the administrator and
       [1mlocal_grid_authenticate[22m.

       After a run-time configurable period, a grid expires and will not be
       accepted for authentication purposes by [1mlocal_grid_authenticate [22m(see
       [34m[1mAUTH_GRID_LIFETIME_SECS [0m[1m[22m[5]) or [1mdacsgrid [22m(see [1m-lifetime[22m). The validity
       period of a grid might be based on several factors, such as how often
       it is used at a jurisdiction, the number of cells in the grid, the
       degree of security required, or how difficult or expensive it is to
       distribute a grid to its user.

       At the time a grid is generated, [1mdacsgrid [22mcan associate a randomly
       chosen PIN with it. A PIN, which acts as a secondary password, consists
       of a sequence of letter-digit-letter cells. The default PIN length of
       two cells (6 characters) can be overridden on the command line. If a
       user has been provided with a PIN, it should be entered at the start of
       the user's response to the challenge, immediately before the contents
       of the first cell of the challenge are entered.

           [1mSecurity[0m
           When used properly, this authentication method can be comparatively
           secure. The main challenge is that it is essential that grids and
           PINs are distributed to users via a sufficiently secure method;
           e.g., by printing them and mailing a hardcopy directly to the user,
           or by using existing secure channels. Each user must understand
           that a grid is essentially a list of passwords and, accordingly,
           must be kept secret during its validity period. When PINs are used,
           they must be distributed using a secure channel different from the
           one used to distribute grids. How this distribution is done is left
           to the [1mDACS [22madministrator.

           Information is encrypted before being written to the grid account
           file. By default, the virtual filestore item type auth_grid_keys
           identifies the encryption keys to use; the [1m-inkeys [22mand [1m-outkeys[0m
           flags specify alternatives (see [34m[1mdacskey(1)[0m[1m[22m[6]). File permissions
           must be set so that the encryption keys are readable only by
           [1mdacsgrid[22m. If the encryption keys are lost, the account entries are
           practically unrecoverable.

           Only the [1mDACS [22madministrator should be able to successfully run this
           program from the command line. Because [1mDACS [22mkeys and configuration
           files, including the file used to store accounts, must be
           restricted to the administrator, this will normally be the case,
           but a careful administrator will set file permissions to deny
           access to all other users.

       This authentication method has the following advantages:

       +o   Each time a user authenticates, a different password will be
           requested (with high probability)

       +o   The password that is required is not known prior to authentication,
           so a user cannot tell someone else what his password is other than
           by sharing the entire grid (and the PIN, if any)

       +o   Because the password is unlikely to be an easily-guessed word or
           phrase, it should be stronger than a user-selected password

       +o   Should a key sniffer be installed on the user's computer, a sniffed
           password does not do an attacker any good, since it is highly
           unlikely to be reused. If the corresponding challenge can also be
           obtained by an attacker, such as through a phishing attack, a
           portion of the grid will be revealed

       +o   The length of the challenge (which determines the length of the
           password) is configurable by the administrator and can be changed
           at will

       +o   A user's grid can easily be changed by an administrator as often as
           practical

       +o   The method is cheaper than hardware-based one-time passwords,
           provided distribution costs are low


       This authentication method has the following potential disadvantages:

       +o   The authentication method is inherently interactive in that the
           password is not known [4ma[24m [4mpriori[24m, although this does not guarantee
           that the user is physically present

       +o   Secure channels are needed to distribute grids and PINs

       +o   An authentication grid can be easily copied and so it is best used
           in conjunction with PINs or at least one other authentication
           method; the challenge of keeping grids secret in all situations is
           the main reason why the method is not as strong as hardware
           token-based methods, which are more difficult to copy and can be
           protected by a PIN. The method is best employed in situations where
           a grid is not likely to be stolen, easily copied, or even
           recognized, such as for remote access.


       This authentication method falls somewhere between the "something you
       know" form and the "something you have" form. One might be able to
       memorize a smaller grid, putting it into the former category, but few
       are capable of memorizing a large grid, which makes it necessary to
       have a copy in one's possession. Using PINs provides something closer
       to two-factor authentication and strengthens the method since a
       captured grid is not directly usable.

           [1mNote[0m
           It is possible for different users to be assigned grids of
           different sizes. To prevent generation of a challenge that is
           impossible to satisfy, when the challenge is requested either the
           corresponding grid must be of the default size, the dimensions of
           the grid must be specified, or the username must be specified.

[1mOPTIONS[0m
       In addition to the standard [34m[4mdacsoptions[0m[4m[24m[1], the following command line
       flags are recognized:

       [1m-challenge[0m
           Emit a random challenge. If [4musername[24m was specified, a
           size-appropriate challenge will be produced; otherwise, if grid
           dimensions have been specified, a suitable challenge will be
           produced; otherwise, the default grid dimensions will be used when
           producing a challenge.

       [1m-clen [4m[22mnum[0m
           Set the challenge length to [4mnum[24m cells. The minimum length is 3
           cells and the default length is 4 cells.

       [1m-copy [4m[22mvfs_uri[0m
           Copy the input grids to the grids specified by [4mvfs_uri[24m, deleting
           any existing contents.

       [1m-dec [4m[22mtoken[0m
           Decrypt a challenge token produced by the [1m-enc [22moption and print it.

       [1m-delete[0m
           Delete the account for [4musername[24m.

       [1m-disable[0m
           Disable logins for [4musername[24m. Implies [1m-set[22m.

       [1m-enable[0m
           Enable logins for [4musername[24m. Implies [1m-set[22m.

       [1m-enc [4m[22mchallenge[0m
           Encrypt a challenge (typically, produced by the [1m-challenge [22moption)
           and print it. The item type federation_keys is used for this
           purpose, which means that any jurisdiction in the federation can
           decrypt the challenge.

       [1m-expired[0m
           List only expired grids, relative to the grid lifetime in effect.
           Implies [1m-list[22m.

       [1m-flat[0m
           Print a grid in a concise textual representation that consists of
           three comma-separated fields: the serial number, enabled/disabled
           flag (non-zero means enabled), the grid (as an ordered sequence of
           space-separated rows), a PIN (or zero if there is no PIN), and the
           creation date (as the number of seconds since the epoch).

       [1m-get[0m
           Retrieve the grid for [4musername[24m and make it the "current" grid for
           display purposes.

       [1m-grid [4m[22mstr[0m
           Make [4mstr[24m, a grid in the flattened representation, the "current"
           grid for display purposes or the [1m-set [22mflag.

       [1m-h[0m
       [1m-help[0m
           Display a help message and exit.

       [1m-html[0m
           Emit a grid as a fragment of an HTML document.

       [1m-htmlcss[0m
           Emit a grid as a fragment of an HTML document with some CSS.

       [1m-inkeys [4m[22mitem_type[0m
           For decrypting account information, use the store identified by
           [4mitem_type[24m.

       [1m-lifetime [4m[22mndays[0m
           Consider the lifetime of grids to be [4mndays[24m days. Grids do not have
           a fixed lifetime; only their date of creation is recorded. The
           default lifetime is 7 days.

       [1m-list[0m
           List [4musername[24m, if given, otherwise all usernames.

       [1m-long[0m
           Produce more detailed listing output. Implies [1m-list[22m.

       [1m-ncols [4m[22mnum[0m
           Set the number of grid columns to [4mnum[24m, which is between 3 and 26.
           This is used when generating grids and challenges.

       [1m-nrows [4m[22mnum[0m
           Set the number of grid rows to [4mnum[24m, which is between 3 and 99. This
           is used when generating grids and challenges.

       [1m-outkeys [4m[22mitem_type[0m
           For encrypting account information, use the store identified by
           [4mitem_type[24m.

       [1m-pin[22m[[4mnum[24m]
           If no other operation is specified, print the PIN, if any, for
           [4musername[24m. With the [1m-set [22mflag, generate a new PIN for [4musername[24m. If a
           non-negative integer is appended to the flag (e.g., [1m-pin0[22m, [1m-pin4[22m),
           the PIN length (in cell units) is set to that number with respect
           to PIN generation. The default PIN length is 2 cells. Setting the
           PIN length to zero turns off PIN generation.

       [1m-refresh[0m
           If a [4musername[24m is given, generate a new grid for that user. If no
           [4musername[24m is given, generate a new grid for each user that already
           has a grid. Any existing grid immediately becomes invalid. All of
           these grids will have the same dimensions. If the [1m-grid [22mflag is
           given, it is ignored. By default, any existing PIN is retained. The
           old grid's enabled/disabled status is retained. If the [1m-pin [22mflag is
           given, a new PIN will be generated; if [1m-pin0 [22mis given, however, new
           grids will not have a PIN.

       [1m-rnd[0m
           Reserved for future use.

       [1m-seed [4m[22mstr[0m
           Reserved for future use.

       [1m-serial[0m
           Print the serial number of the current grid.

       [1m-set[0m
           Set or replace the grid for [4musername[24m.

       [1m-size[0m
           Display the grid dimensions in terms of the command line flags
           [1m-ncols [22mand [1m-nrows[22m. Implies [1m-list[22m.

       [1m-test[0m
           Emit a grid and a challenge, prompt from a response, and verify the
           response.

       [1m-text[0m
           Emit a pretty-printed grid.

       [1m-validate [4m[22mchallenge[24m [4mresponse[0m
           Validate [4mresponse[24m against [4mchallenge[24m.

       [1m-vfs [4m[22mvfs_uri[0m
           Instead of using the item type auth_grid to specify which grids to
           act on, use [4mvfs_uri[24m (see the [34m[1mVFS[0m[1m[22m[7] configuration directive).

       The default action is to display the current grid. Apart from error
       messages, which are printed to the standard error, all output goes to
       the standard output.

       Ordinarily, a [4mdacsoption[24m will be specified to select the jurisdiction
       on behalf of which grids are being created.

[1mEXAMPLES[0m
       These examples assume that the jurisdiction name to use is EXAMPLE and
       its domain is example.com.

       To use this authentication method, a [1mDACS [22madministrator would perform
       the following steps:

       +o   After reviewing the way the method operates, decide how grids will
           be securely distributed to users, select the grid parameters,
           decide whether PINs will be used and how they will be securely
           distributed, and determine a schedule for refreshing grids (and
           perhaps PINs).

       +o   Decide where the grids will be stored and add a suitable VFS
           directive to dacs.conf, for example:

               VFS "[auth_grid]dacs-kwv-fs:${Conf::FEDERATIONS_ROOT}/\
               ${Conf::FEDERATION_DOMAIN}/${Conf::JURISDICTION_NAME}/grids"


       +o   Generate keys, decide where they will be stored, and add a suitable
           VFS directive to dacs.conf, for example (your user ID, groupID, and
           path may vary):

               % cd /usr/local/dacs/federations_root/example.com/EXAMPLE
               % dacskey -uj EXAMPLE -q auth_grid_keys
               % chgrp www auth_grid_keys
               % chmod 0640 auth_grid_keys



               VFS "[auth_grid_keys]dacs-fs:${Conf::FEDERATIONS_ROOT}/\
               ${Conf::FEDERATION_DOMAIN}/${Conf::JURISDICTION_NAME}/auth_grid_keys"


       +o   Configure a suitable Auth clause in dacs.conf, for example:

               <Auth id="grid">
               URL "https://example.com/cgi-bin/dacs/local_grid_authenticate"
               STYLE "pass"
               CONTROL "sufficient"
               </Auth>


       +o   For each user that will be capable of authenticating using this
           method: a) generate a grid of the necessary dimensions, with or
           without a PIN (as required); b) obtain the grid in the most
           suitable format and give it to its owner; and c) if there is a PIN,
           obtain the PIN and give it to its owner.

       +o   Refresh the grid (and, optionally, the PIN) as scheduled and give
           the user the replacement grid.


       To create and display a grid (but not create an account):

           % dacsgrid -uj EXAMPLE

       To generate a grid of default dimensions and assign it to username bobo
       (replacing any existing grid for that user):

           % dacsgrid -uj EXAMPLE -set bobo

       To generate a 6x6 grid and assign it to username bobo (replacing any
       existing grid):

           % dacsgrid -uj EXAMPLE -nrows 6 -ncols 6 -set bobo

       To retrieve and print a grid (as HTML) for the username bobo:

           % dacsgrid -uj EXAMPLE -get -html bobo

       To display the PIN for username bobo:

           % dacsgrid -uj EXAMPLE -pin bobo

       The exit status will be non-zero if this user does not have a grid or
       if the grid does not have a PIN.

       To copy the current set of grids to the file /secure/grids:

           % dacsgrid -uj EXAMPLE -copy "dacs-kwv-fs:/secure/grids"

       To refresh an alternate set of grids in the file /secure/grids:

           % dacsgrid -uj EXAMPLE -copy "dacs-kwv-fs:/secure/grids"
           % dacsgrid -uj EXAMPLE -vfs "dacs-kwv-fs:/secure/grids" -refresh

       An example shell script that generates a minimal HTML login page for
       grid authentication is included in the distribution. It assumes that
       all grids are the default size.

       If different users may have grids of different sizes, or if a
       jurisdiction wants to display a user's grid's serial number as a form
       of jurisdictional authentication, then the login procedure must
       determine the username before it can acquire a challenge or serial
       number.

[1mFILES[0m
       [34m[1mdacs_grid.css[0m[1m[22m[8]

[1mDIAGNOSTICS[0m
       The program exits 0, or 1 if an error occurred.

[1mNOTES[0m
       To help thwart automated responses, should some assurance be required
       that a person rather than software is answering a challenge, the
       challenge might be presented as a [34m[1mCAPTCHA[0m[1m[22m[9] or something similar.

       A hardware device could be used to store and access grids, which could
       boost the method's security and possibly even offer advantages over the
       PRNG methods used by most commercial tokens.

       Another idea is to supply users with software to run on their personal
       workstations that would securely store and manage grids and, given a
       challenge, display the response. This may not provide the same level of
       confidence as hardware token or hard-copy based methods, however,
       because it is difficult to be certain that a computer, file, or program
       hasn't been compromised. If sufficiently secure, a password-protected
       USB flash memory device might be acceptable for transporting and
       storing grids.

       The login interface should consider providing a menu or image map to
       enter the PIN, rather than the keyboard, to defeat keylogging spyware.

       Using this authentication method makes you feel like you are a secret
       agent. Consider printing grids on an edible substrate.

[1mBUGS[0m
       There should be a clean way of flipping from one set of grids to
       another at a specified date and time. This can currently be done by
       pre-generating a set of grids with appropriate file names (e.g., based
       on the date the set becomes effective) and configuring the VFS
       directive for the grids to form the file name based on the current
       date.

       Users cannot select their own PINs. This may be a feature.

       An alternate mode of operation based on strong but repeatable pseudo
       random numbers described by [34m[1mNIST SP 800-90[0m[1m[22m[10] is pending. The current
       implementation does not employ a reproducible sequence of pseudo random
       numbers; this has advantages and disadvantages.

       The account file should probably be an XML document.

[1mSEE ALSO[0m
       [34m[1mdacstoken(1)[0m[1m[22m[11], [34m[1mdacs_authenticate(8)[0m[1m[22m[12], [34m[1mopie(4)[0m[1m[22m[13]. Grid-based
       methods are also used by ciphers; e.g., the [34m[1mVIC cipher[0m[1m[22m[14].

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[15])

[1mCOPYING[0m
       Copyright (C) 2003-2014 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[16] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. local_grid_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#grid

        3. local_passwd_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#passwd

        4. AUTH_GRID_CHALLENGE_SECS
           http://dacs.dss.ca/man/dacs_authenticate.8.html#AUTH_GRID_CHALLENGE_SECS

        5. AUTH_GRID_LIFETIME_SECS
           http://dacs.dss.ca/man/dacs_authenticate.8.html#AUTH_GRID_LIFETIME_SECS

        6. dacskey(1)
           http://dacs.dss.ca/man/dacskey.1.html

        7. VFS
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

        8. dacs_grid.css
           http://dacs.dss.ca/man//css/dacs_grid.css

        9. CAPTCHA
           http://en.wikipedia.org/wiki/CAPTCHA

       10. NIST SP 800-90
           http://csrc.nist.gov/publications/nistpubs/800-90/SP800-90revised_March2007.pdf

       11. dacstoken(1)
           http://dacs.dss.ca/man/dacstoken.1.html

       12. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       13. opie(4)
           http://www.freebsd.org/cgi/man.cgi?query=opie&apropos=0&sektion=0&manpath=FreeBSD+10.1-RELEASE&format=html

       14. VIC cipher
           http://en.wikipedia.org/wiki/VIC_cipher

       15. www.dss.ca
           http://www.dss.ca

       16. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.38a                      11/23/2016                       DACSGRID(1)
