#ifndef DBALLE_CORE_SHORTCUTS_H
#define DBALLE_CORE_SHORTCUTS_H

#include <dballe/types.h>
#include <wreport/varinfo.h>
#include <iosfwd>

namespace dballe {
namespace impl {

struct Shortcut
{
    bool station_data;
    Level level;
    Trange trange;
    wreport::Varcode code;

    static const Shortcut& by_name(const char* name);
    static const Shortcut& by_name(const std::string& name);
    static const Shortcut& by_name(const char* name, unsigned len);

    bool operator==(const Shortcut& o) const { return std::tie(station_data, level, trange, code) == std::tie(o.station_data, o.level, o.trange, o.code); }
};

std::ostream& operator<<(std::ostream& out, const Shortcut& shortcut);


namespace sc {

extern const Shortcut st_type;
extern const Shortcut st_name;
extern const Shortcut st_name_icao;
extern const Shortcut rep_memo;
extern const Shortcut poll_lcode;
extern const Shortcut poll_scode;
extern const Shortcut poll_gemscode;
extern const Shortcut poll_source;
extern const Shortcut poll_atype;
extern const Shortcut poll_ttype;
extern const Shortcut flight_reg_no;
extern const Shortcut flight_phase;
extern const Shortcut flight_roll;
extern const Shortcut navsys;
extern const Shortcut data_relay;
extern const Shortcut wind_inst;
extern const Shortcut temp_precision;
extern const Shortcut latlon_spec;
extern const Shortcut timesig;
extern const Shortcut block;
extern const Shortcut station;
extern const Shortcut ident;
extern const Shortcut year;
extern const Shortcut month;
extern const Shortcut day;
extern const Shortcut hour;
extern const Shortcut minute;
extern const Shortcut second;
extern const Shortcut latitude;
extern const Shortcut longitude;
extern const Shortcut height_station;
extern const Shortcut height_baro;
extern const Shortcut height_release;
extern const Shortcut station_height_quality;
extern const Shortcut isobaric_surface;
extern const Shortcut st_dir;
extern const Shortcut st_speed;
extern const Shortcut meas_equip_type;
extern const Shortcut sonde_type;
extern const Shortcut sonde_method;
extern const Shortcut sonde_correction;
extern const Shortcut sonde_tracking;
extern const Shortcut press;
extern const Shortcut press_3h;
extern const Shortcut press_24h;
extern const Shortcut water_temp;
extern const Shortcut height_anem;
extern const Shortcut press_tend;
extern const Shortcut visibility;
extern const Shortcut pres_wtr;
extern const Shortcut past_wtr1_3h;
extern const Shortcut past_wtr1_6h;
extern const Shortcut past_wtr2_3h;
extern const Shortcut past_wtr2_6h;
extern const Shortcut metar_wtr;
extern const Shortcut tot_prec1;
extern const Shortcut tot_prec3;
extern const Shortcut tot_prec6;
extern const Shortcut tot_prec12;
extern const Shortcut tot_prec24;
extern const Shortcut tot_snow;
extern const Shortcut state_ground;
extern const Shortcut press_msl;
extern const Shortcut qnh;
extern const Shortcut temp_2m;
extern const Shortcut wet_temp_2m;
extern const Shortcut dewpoint_2m;
extern const Shortcut humidity;
extern const Shortcut wind_dir;
extern const Shortcut wind_speed;
extern const Shortcut wind_gust_max_speed;
extern const Shortcut wind_gust_max_dir;
extern const Shortcut ex_ccw_wind;
extern const Shortcut ex_cw_wind;
extern const Shortcut cloud_n;
extern const Shortcut cloud_nh;
extern const Shortcut cloud_hh;
extern const Shortcut cloud_cl;
extern const Shortcut cloud_cm;
extern const Shortcut cloud_ch;
extern const Shortcut cloud_n1;
extern const Shortcut cloud_c1;
extern const Shortcut cloud_h1;
extern const Shortcut cloud_n2;
extern const Shortcut cloud_c2;
extern const Shortcut cloud_h2;
extern const Shortcut cloud_n3;
extern const Shortcut cloud_c3;
extern const Shortcut cloud_h3;
extern const Shortcut cloud_n4;
extern const Shortcut cloud_c4;
extern const Shortcut cloud_h4;

}
}
}

#endif
