# This tests, which things in the IO package exist on a given platform:
StdGlobalVarsIO := Set(
[ "IO", "IO_AddToPickled", "IO_AddToUnpickled", "IO_ClearPickleCache", 
  "IO_Close", "IO_CloseAllFDs", "IO_EOF", "IO_Environment", "IO_Error", 
  "IO_File", "IO_FinalizePickled", "IO_FinalizeUnpickled", "IO_Flush", 
  "IO_FlushNonBlocking", "IO_GenericObjectPickler", 
  "IO_GenericObjectUnpickler", "IO_GetFD", "IO_GetWBuf", "IO_HasData", 
  "IO_InstallSIGCHLDHandler", "IO_ListDir", "IO_MakeEnvList", 
  "IO_MakeIPAddressPort", "IO_MasterPointerNumber", "IO_Nothing", "IO_OK", 
  "IO_PICKLECACHE", "IO_Pickle", "IO_PickleByString", "IO_PipeThrough", 
  "IO_PipeThroughWithError", "IO_Popen", "IO_Popen2", "IO_Popen3", "IO_Read", 
  "IO_ReadAttribute", "IO_ReadBlock", "IO_ReadLine", "IO_ReadLines", 
  "IO_ReadSmallInt", "IO_ReadUntilEOF", "IO_ReadyForFlush", 
  "IO_ReadyForWrite", "IO_RestoreSIGCHLDHandler", "IO_Result", 
  "IO_ResultsFamily", "IO_Select", "IO_SendStringBackground", "IO_Unpickle", 
  "IO_UnpickleByEvalString", "IO_Unpicklers", "IO_WaitPid", "IO_WrapFD", 
  "IO_Write", "IO_WriteAttribute", "IO_WriteFlush", "IO_WriteLine", 
  "IO_WriteLines", "IO_WriteNonBlocking", "IO_WriteSmallInt", "IO_accept", 
  "IO_bind", "IO_chdir", "IO_chmod", "IO_chown", "IO_close", "IO_closedir", 
  "IO_connect", "IO_creat", "IO_dup", "IO_dup2", "IO_environ", "IO_execv", 
  "IO_execve", "IO_execvp", "IO_exit", "IO_fchmod", "IO_fchown", "IO_fcntl", 
  "IO_fork", "IO_fstat", "IO_gethostbyname", "IO_getsockopt", "IO_lchown", 
  "IO_link", "IO_listen", "IO_lseek", "IO_lstat", "IO_make_sockaddr_in", 
  "IO_mkdir", "IO_mkfifo", "IO_mknod", "IO_open", "IO_opendir", "IO_pipe", 
  "IO_read", "IO_readdir", "IO_readlink", "IO_recv", "IO_recvfrom", 
  "IO_rename", "IO_rewinddir", "IO_rmdir", "IO_seekdir", "IO_select", 
  "IO_send", "IO_sendto", "IO_setsockopt", "IO_socket", "IO_stat", 
  "IO_symlink", "IO_telldir", "IO_unlink", "IO_write",
  "IO_FileFilterString", "IO_FilteredFile", "IO_FindExecutable", 
  "IO_ForkExecWithFDs", "IO_StartPipeline", "IO_StringFilterFile",
  "IO_FuncToUnpickle", "IO_IsAlreadyPickled", "IO_PackageIsLoaded", 
  "IO_PkgThingsToRead", "IO_getpid", "IO_getppid", "IO_kill",
  "IO_gettimeofday", "IO_gmtime", "IO_localtime", "IO_gethostname",
  "IO_getsockname" ] );
StdComponentsIO := Set(
[ "AF_APPLETALK", "AF_ASH", "AF_ATMPVC", "AF_ATMSVC", "AF_AX25", 
  "AF_BLUETOOTH", "AF_BRIDGE", "AF_DECnet", "AF_ECONET", "AF_FILE", 
  "AF_INET", "AF_INET6", "AF_IPX", "AF_IRDA", "AF_KEY", "AF_LOCAL", "AF_MAX", 
  "AF_NETBEUI", "AF_NETLINK", "AF_NETROM", "AF_PACKET", "AF_PPPOX", 
  "AF_ROSE", "AF_ROUTE", "AF_SECURITY", "AF_SNA", "AF_UNIX", "AF_UNSPEC", 
  "AF_WANPIPE", "AF_X25", "DefaultBufSize", "EACCES", "EADDRINUSE", 
  "EAFNOSUPPORT", "EAGAIN", "EALREADY", "EBADF", "EBUSY", "ECHILD", 
  "ECONNABORTED", "ECONNREFUSED", "EEXIST", "EFAULT", "EFBIG", "EINPROGRESS", 
  "EINTR", "EINVAL", "EIO", "EISCONN", "EISDIR", "ELOOP", "EMFILE", "EMLINK", 
  "ENAMETOOLONG", "ENFILE", "ENODEV", "ENOENT", "ENOMEM", "ENOSPC", 
  "ENOTDIR", "ENOTEMPTY", "ENOTSOCK", "ENXIO", "EOPNOTSUPP", "EOVERFLOW", 
  "EPERM", "EPIPE", "EPROTO", "EPROTONOSUPPORT", "EROFS", "ESPIPE", 
  "ETIMEDOUT", "ETXTBSY", "EWOULDBLOCK", "EXDEV", "FD_CLOEXEC", "F_DUPFD", 
  "F_GETFD", "F_GETFL", "F_GETLEASE", "F_GETOWN", "F_GETSIG", "F_RDLCK", 
  "F_SETFD", "F_SETFL", "F_SETLEASE", "F_SETOWN", "F_SETSIG", "F_UNLCK", 
  "F_WRLCK", "HOST_NOT_FOUND", "IP_ADD_MEMBERSHIP", "IP_DROP_MEMBERSHIP", 
  "IP_HDRINCL", "IP_MTU_DISCOVER", "IP_MULTICAST_IF", "IP_MULTICAST_LOOP", 
  "IP_MULTICAST_TTL", "IP_OPTIONS", "IP_PKTINFO", "IP_RECVERR", 
  "IP_RECVOPTS", "IP_RECVTOS", "IP_RECVTTL", "IP_RETOPTS", "IP_ROUTER_ALERT", 
  "IP_TOS", "IP_TTL", "LineEndChar", "LineEndChars", "MSG_CTRUNC", 
  "MSG_DONTWAIT", "MSG_EOR", "MSG_ERRQUEUE", "MSG_OOB", "MSG_PEEK", 
  "MSG_TRUNC", "MSG_WAITALL", "MaxFDToClose", "NO_ADDRESS", "NO_DATA", 
  "NO_RECOVERY", "O_APPEND", "O_ASYNC", "O_CREAT", "O_DIRECT", "O_DIRECTORY", 
  "O_EXCL", "O_LARGEFILE", "O_NDELAY", "O_NOATIME", "O_NOCTTY", "O_NOFOLLOW", 
  "O_NONBLOCK", "O_RDONLY", "O_RDWR", "O_SYNC", "O_TRUNC", "O_WRONLY", 
  "PF_APPLETALK", "PF_ASH", "PF_ATMPVC", "PF_ATMSVC", "PF_AX25", 
  "PF_BLUETOOTH", "PF_BRIDGE", "PF_DECnet", "PF_ECONET", "PF_FILE", 
  "PF_INET", "PF_INET6", "PF_IPX", "PF_IRDA", "PF_KEY", "PF_LOCAL", "PF_MAX", 
  "PF_NETBEUI", "PF_NETLINK", "PF_NETROM", "PF_PACKET", "PF_PPPOX", 
  "PF_ROSE", "PF_ROUTE", "PF_SECURITY", "PF_SNA", "PF_UNIX", "PF_WANPIPE", 
  "PF_X25", "PIPE_BUF", "SEEK_CUR", "SEEK_END", "SEEK_SET", "SOCK_DGRAM", 
  "SOCK_PACKET", "SOCK_RAW", "SOCK_RDM", "SOCK_SEQPACKET", "SOCK_STREAM", 
  "SOL_SOCKET", "SO_ACCEPTCONN", "SO_BINDTODEVICE", "SO_BROADCAST", 
  "SO_BSDCOMPAT", "SO_DEBUG", "SO_DONTROUTE", "SO_ERROR", "SO_KEEPALIVE", 
  "SO_LINGER", "SO_OOBINLINE", "SO_PASSCRED", "SO_PEERCRED", "SO_PRIORITY", 
  "SO_RCVBUF", "SO_RCVLOWAT", "SO_RCVTIMEO", "SO_REUSEADDR", "SO_SNDBUF", 
  "SO_SNDLOWAT", "SO_SNDTIMEO", "SO_TYPE", "S_IFBLK", "S_IFCHR", "S_IFDIR", 
  "S_IFIFO", "S_IFLNK", "S_IFMT", "S_IFREG", "S_IFSOCK", "S_IRGRP", 
  "S_IROTH", "S_IRUSR", "S_IRWXG", "S_IRWXO", "S_IRWXU", "S_ISGID", 
  "S_ISUID", "S_ISVTX", "S_IWGRP", "S_IWOTH", "S_IWUSR", "S_IXGRP", 
  "S_IXOTH", "S_IXUSR", "TCP_CORK", "TCP_DEFER_ACCEPT", "TCP_INFO", 
  "TCP_KEEPCNT", "TCP_KEEPIDLE", "TCP_KEEPINTVL", "TCP_LINGER2", 
  "TCP_MAXSEG", "TCP_NODELAY", "TCP_QUICKACK", "TCP_SYNCNT", 
  "TCP_WINDOW_CLAMP", "TRY_AGAIN", "__GNUC_MINOR__", "__GNUC__",
  "NonBlockWriteAmount", "SIGABRT", "SIGALRM", "SIGBUS", "SIGCHLD", 
  "SIGCLD", "SIGCONT", "SIGFPE", 
  "SIGHUP", "SIGILL", "SIGINT", "SIGIO", "SIGIOT", "SIGKILL", "SIGPIPE", 
  "SIGPOLL", "SIGPROF", "SIGPWR", "SIGQUIT", "SIGSEGV", "SIGSTKFLT", 
  "SIGSTOP", "SIGSYS", "SIGTERM", "SIGTRAP", "SIGTSTP", "SIGTTIN", "SIGTTOU", 
  "SIGUNUSED", "SIGURG", "SIGUSR1", "SIGUSR2", "SIGVTALRM", "SIGWINCH", 
  "SIGXCPU", "SIGXFSZ"]);
# Note missing but possible (includes missing because of autoconf:
#   "ENOBUGS", "ICMP_FILTER", "IP_MTU"
GlobalVarsIO := 
  Set(Filtered(NamesGVars(),x->Length(x)>=2 and x{[1..2]} = "IO"));
ComponentsIO := Set(NamesOfComponents(IO));

Print("Not available here:\n",Difference(StdGlobalVarsIO,GlobalVarsIO),"\n",
      Difference(StdComponentsIO,ComponentsIO),"\n\n");
Print("More available here:\n",Difference(GlobalVarsIO,StdGlobalVarsIO),"\n",
      Difference(ComponentsIO,StdComponentsIO),"\n\n");


