/**************************************************************************\
 Closed Captionning decoding         Initial version
 by Chrisitan Lupien
    (lupien@physics.utoronto.ca)

 This is part of the Gatos project:
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
        Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

#define CC_ROWS 15
#define CC_COLUMNS 32

#define CC_INVSPACE 0xa0
/* this should be the same as BLOCK both I prefer keeping it
   different so I can eventually count the number of CC_BAD
   and turn caption off if it is to high */
#define CC_BAD 0x87

#define CC_ATTR_NORMAL 0x00
#define CC_ATTR_FLASH 0x01
#define CC_ATTR_ITALICS 0x04
#define CC_ATTR_UNDERLINE 0x08
#define CC_ATTR_WHITE 0x00
#define CC_ATTR_GREEN 0x10
#define CC_ATTR_BLUE 0x20
#define CC_ATTR_CYAN 0x30
#define CC_ATTR_RED 0x40
#define CC_ATTR_YELLOW 0x50
#define CC_ATTR_MAGENTA 0x60
#define CC_ATTR_BACK 0x70
#define CC_ATTR_NEWCHAR 0x100


struct ccdata {
  int num_row;
  int *clrflag; // the display driver can clear this
  int *row;
  unsigned char (*text)[CC_COLUMNS];
  int (*attrib)[CC_COLUMNS]; // the display driver can clear CC_ATTR_NEWCHAR
};

#define EDS_BUFMAX 64
struct edsdata {
  int num;  // the number of non-zero code since last reset.
  int cur;
  char buf[EDS_BUFMAX]; // fill it in a loop using cur: cyclic buffer
};

void cc_hook(void);
void cc_mode(int);
void cc_reset(void);
struct ccdata * cc_get_data(void);
struct edsdata * eds_get_data(void);

#define CC_MODE_CC1 0x00
#define CC_MODE_CC2 0x01
#define CC_MODE_TEXT1 0x02
#define CC_MODE_TEXT2 0x03

#ifdef __cplusplus
}
#endif

