"""
CLI function to show various things.

Maybe gavo config and gavo info should be folded in here if this grows.
"""

#c Copyright 2008-2024, the GAVO project <gavo@ari.uni-heidelberg.de>
#c
#c This program is free software, covered by the GNU GPL.  See the
#c COPYING file in the source distribution.


from gavo import api
from gavo.utils import Arg, exposedFunction, makeCLIParser


@exposedFunction([
	Arg("rdId", help="an RD id (or a path to RD xml)"),],
	help="show what data items are available")
def dds(args):
	rd = api.getReferencedElement(args.rdId, forceType=api.RD)
	for dd in rd.dds:
		outLine = dd.id
		if dd.auto:
			outLine += "*"
		print(outLine)


def main():
	args = makeCLIParser(globals()).parse_args()
	args.subAction(args)
