/*
 * Decompiled with CFR 0.152.
 */
package gmonitor.logdata;

import gmonitor.logdata.HttpSeekableFile;
import gmonitor.logdata.LocalSeekableFile;
import gmonitor.logdata.SeekableFile;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class SeekableFileFactory {
    public static SeekableFile create(URL uRL) throws IOException {
        SeekableFile seekableFile = null;
        String string = uRL.getProtocol();
        if (string.equalsIgnoreCase("file")) {
            File file = new File(uRL.getPath());
            seekableFile = new LocalSeekableFile(file);
        } else if (string.equalsIgnoreCase("http")) {
            seekableFile = new HttpSeekableFile(uRL);
        } else {
            throw new MalformedURLException("Unsupported Protocol" + string);
        }
        return seekableFile;
    }

    public static SeekableFile create(File file) throws IOException {
        return new LocalSeekableFile(file);
    }

    public static SeekableFile create(String string) throws IOException {
        SeekableFile seekableFile = null;
        if (string.startsWith("http:")) {
            URL uRL = new URL(string);
            seekableFile = SeekableFileFactory.create(uRL);
        } else {
            File file = new File(string);
            seekableFile = SeekableFileFactory.create(file);
        }
        return seekableFile;
    }
}

