-- ------------------------------------------------------------------------- --
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/objects/person.adb,v $
--  Description     : Handle the Person related information                  --
--  Author          : Michael Erdmann <Michael.Erdmann@snafu.de>             --
--  Created On      : 30-Dec-2006                                            --
--  Last Modified By: $Author: merdmann $                                    --
--  Last Modified On: $Date: 2007/02/03 14:59:52 $                           --
--  Status          : $State: Exp $                                          --
--                                                                           --
--  Copyright (C) 2006-2007 Michael Erdmann                                  --
--                                                                           --
--  GNADE is copyrighted by the persons and institutions enumerated in the   --
--  AUTHORS file. This file is located in the root directory of the          --
--  GNADE distribution.                                                      --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNADE; see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from      --
--  GNADE Ada units, or you link GNADE Ada units or libraries with other     --
--  files  to produce an executable, these  units or libraries do not by     --
--  itself cause the resulting  executable  to  be covered  by the  GNU      --
--  General  Public  License.  This exception does not however invalidate    --
--  any other reasons why  the executable file  might be covered by the      --
--  GNU Public License.                                                      --
--                                                                           --
-- ------------------------------------------------------------------------- --
with Ada.Text_IO;			use Ada.Text_IO;
with TAM.Persistent;			use TAM.Persistent;

with Objects;				use Objects;
with Account;				use Account;

package body Person is

   ------------
   -- Create --
   ------------
   procedure Create(
      This      : in out Object;
      Firstname : in Unbounded_String ;
      Lastname  : in Unbounded_String ) is
   begin
      This.Firstname := Firstname;
      This.Lastname  := Lastname;

      Put_Object( This, Make_Key( This ) );


--      Account.Create( This, "Private Account" );
--      Account.Create( This, "Business Account" );
   end ;

   --------------
   -- Make_Key --
   --------------
   function Make_Key(
      This   : in Object'Class ) return Key_Object is
      Result : Key_Object;
   begin
      Result.Name := This.Firstname & This.Lastname ;
      return Result;
   end Make_Key;

   ---------------
   -- Object_ID --
   ---------------
   function Object_ID(
      Firstname : in Unbounded_String ;
      Lastname  : in Unbounded_String ) return Integer is
   begin
      return Rootname( To_String(Firstname) & To_String(Lastname) );
   end Object_ID;

   -----------
   -- Query --
   -----------
   procedure Query(
      This      : in out Object;
      Firstname : in Unbounded_String ;
      Lastname  : in Unbounded_String ) is
   begin
      This.Firstname := Firstname;
      This.Lastname  := Lastname ;

      Get_Object( This, Make_Key( This ));
   exception
      when Objects.Object_Not_Existing =>
         raise Person.Not_Existing;
   end Query;

   ------------
   -- Lookup --
   ------------
   function Lookup(
      Firstname : in Unbounded_String ;
      Lastname  : in Unbounded_String ) return Person.Object is
      This      : Person.Object;
   begin
      This.Firstname := Firstname;
      This.Lastname  := Lastname ;

      Get_Object( This, Make_Key( This ));
      return This;

   exception
      when Objects.Object_Not_Existing =>
         raise Person.Not_Existing;
   end Lookup;

   -------------
   -- Display --
   -------------
   procedure Display(
      This   : in out Object ) is

      procedure Display_Accounts is
         Account_ID : OID_Array_Type( 1..100 ) := (others=>0);
         Length     : Integer := 0;
      begin
         Get_Related( OID( This ), "Has_Account" , Account_ID, Length );
         for i in 1..Length loop
            declare
               A : Account.Object;
            begin
               OID( A, Account_ID(i));
               Get_Object(A);
               Display( A );
            end ;
         end loop;
         Put_Line("" );
      end Display_Accounts;

   begin
      Get_Object( This );

      Put_Line( "" );
      Put_Line( "First Name : " & To_String(This.Firstname) );
      Put_Line( "Last Name  : " & To_String( This.Lastname));
      Put_Line( "");
      Display_Accounts;

   end;

end Person;
