------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2006 Dmitriy Anisimkov, Maxim Reznik                 --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-notifications.ads,v 1.8 2006/12/11 04:31:47 vagul Exp $

with OCI.Thick.Connections;
with System;

package OCI.Thick.Notifications is

   use OCI.Thick.Connections;

   type Base_Subscription is abstract tagged limited private;

   procedure Enable (Item : in Base_Subscription);

   procedure Disable (Item : in Base_Subscription);

   procedure Register
     (Item    : in out Base_Subscription;
      Connect : in     Connection);

   procedure Unregister (Item : in out Base_Subscription);

   type Subscription is new Base_Subscription with private;

   type Namespace_Enum is (AQ, Anonymous);

   type Buffer_Type is private;

   procedure Create
     (Item      : in out Subscription;
      Name      : in     String;
      Namespace : in     Namespace_Enum);

   procedure Post
     (Item    : in out Subscription;
      Connect : in     Connection;
      Data    : in     String);

   procedure Notify
     (Item   : in out Subscription;
      Buffer : in     Buffer_Type);

   function To_String (Buffer : in Buffer_Type) return String;

   Already_Registered : exception;

private

   type Base_Subscription is new AF.Limited_Controlled with record
      Handle  : aliased OCISubscription := OCISubscription (Empty_Handle);
      Connect : Connection;
   end record;

   procedure Internal_Notify
     (Item       : in out Base_Subscription;
      Descriptor : in     OCI.Lib.DVoid;
      Buffer     : in     Buffer_Type);

   procedure Create
     (Item      : in out Base_Subscription;
      Namespace : in     OCI.Lib.Ub4);

   type Subscription is new Base_Subscription with null record;

   procedure Internal_Notify
     (Item       : in out Subscription;
      Descriptor : in     OCI.Lib.DVoid;
      Buffer     : in     Buffer_Type);

   type Buffer_Type is record
      Ptr      : System.Address := System.Null_Address;
      Length   : Natural := 0;
   end record;

   procedure Finalize (Object : in out Subscription);

end OCI.Thick.Notifications;
