/* 
 * Copyright (C) 2004, 2005 Jean-Yves Lefort <jylefort@brutele.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "config.h"
#include <gnome.h>
#include <libgnomevfs/gnome-vfs.h>
#include <translate.h>
#include "gt-app.h"
#include "gt-stock.h"
#include "gt-conf.h"
#include "gt-util.h"
#include "gt-shell.h"

int
main (int argc, char **argv)
{
  GnomeProgram *program;
  poptContext context;
  const char *uri;
  GtkIconTheme *icon_theme;
  GList *icon_list;
  GError *err = NULL;
    
  g_log_set_fatal_mask(G_LOG_DOMAIN, G_LOG_LEVEL_CRITICAL);

#ifdef ENABLE_NLS
  bindtextdomain(GETTEXT_PACKAGE, GNOMELOCALEDIR);
  bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
  textdomain(GETTEXT_PACKAGE);
#endif

  g_thread_init(NULL);
  if (! g_thread_supported())
    /*
     * We can't use gt_error_dialog() because gtk_init() has not been
     * called yet.
     */
    g_critical(_("multi-threading is not available"));
  gdk_threads_init();

  program = gnome_program_init(PACKAGE,
			       VERSION,
			       LIBGNOMEUI_MODULE,
			       argc,
			       argv,
			       GNOME_PARAM_HUMAN_READABLE_NAME, _("GNOME Translate"),
			       GNOME_PROGRAM_STANDARD_PROPERTIES,
			       NULL);
  g_object_get(G_OBJECT(program), GNOME_PARAM_POPT_CONTEXT, &context, NULL);
  uri = poptGetArg(context);
  
  gt_conf_init();
  
  GDK_THREADS_ENTER();

  /*
   * This is needed for devel builds and other situations where the
   * icons were not installed in the standard icon theme path.
   */
  icon_theme = gtk_icon_theme_get_default();
  gtk_icon_theme_prepend_search_path(icon_theme, DATADIR G_DIR_SEPARATOR_S "icons");

  icon_list = gt_window_icon_list_new("gnome-translate");
  gtk_window_set_default_icon_list(icon_list);
  eel_g_object_list_free(icon_list);

  gt_stock_init();

  if (! translate_init(&err))
    {
      gt_fatal_error_dialog(NULL, _("Unable to initialize libtranslate: %s"), err->message);
      g_error_free(err);
    }
  if (! gnome_vfs_init())
    gt_fatal_error_dialog(NULL, _("Unable to initialize the GnomeVFS library."));

  gt_shell_new();
  gt_app_main(uri);

  GDK_THREADS_LEAVE();

  return 0;
}
