// Code generated by smithy-go-codegen DO NOT EDIT.

package mailmanager

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mailmanager/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of email archive export jobs.
func (c *Client) ListArchiveExports(ctx context.Context, params *ListArchiveExportsInput, optFns ...func(*Options)) (*ListArchiveExportsOutput, error) {
	if params == nil {
		params = &ListArchiveExportsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListArchiveExports", params, optFns, c.addOperationListArchiveExportsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListArchiveExportsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The request to list archive export jobs in your account.
type ListArchiveExportsInput struct {

	// The identifier of the archive.
	//
	// This member is required.
	ArchiveId *string

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again using
	// the returned token to retrieve the next page.
	NextToken *string

	// The maximum number of archive export jobs that are returned per call. You can
	// use NextToken to obtain further pages of archives.
	PageSize *int32

	noSmithyDocumentSerde
}

// The response containing a list of archive export jobs and their statuses.
type ListArchiveExportsOutput struct {

	// The list of export job identifiers and statuses.
	Exports []types.ExportSummary

	// If present, use to retrieve the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListArchiveExportsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListArchiveExports{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListArchiveExports{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListArchiveExports"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListArchiveExportsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListArchiveExports(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListArchiveExportsPaginatorOptions is the paginator options for
// ListArchiveExports
type ListArchiveExportsPaginatorOptions struct {
	// The maximum number of archive export jobs that are returned per call. You can
	// use NextToken to obtain further pages of archives.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListArchiveExportsPaginator is a paginator for ListArchiveExports
type ListArchiveExportsPaginator struct {
	options   ListArchiveExportsPaginatorOptions
	client    ListArchiveExportsAPIClient
	params    *ListArchiveExportsInput
	nextToken *string
	firstPage bool
}

// NewListArchiveExportsPaginator returns a new ListArchiveExportsPaginator
func NewListArchiveExportsPaginator(client ListArchiveExportsAPIClient, params *ListArchiveExportsInput, optFns ...func(*ListArchiveExportsPaginatorOptions)) *ListArchiveExportsPaginator {
	if params == nil {
		params = &ListArchiveExportsInput{}
	}

	options := ListArchiveExportsPaginatorOptions{}
	if params.PageSize != nil {
		options.Limit = *params.PageSize
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListArchiveExportsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListArchiveExportsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListArchiveExports page.
func (p *ListArchiveExportsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListArchiveExportsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.PageSize = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListArchiveExports(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListArchiveExportsAPIClient is a client that implements the ListArchiveExports
// operation.
type ListArchiveExportsAPIClient interface {
	ListArchiveExports(context.Context, *ListArchiveExportsInput, ...func(*Options)) (*ListArchiveExportsOutput, error)
}

var _ ListArchiveExportsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListArchiveExports(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListArchiveExports",
	}
}
