% Title = "TELNET RANDOMLY-LOSE Option"
% abbrev = "TELNET RANDOMLY-LOSE Option"
% category = "info"
% docName = "rfc-748"
% ipr= "trust200902"
% area = "Internet"
% workgroup = "Network Working Group"
% keyword = [""]
%
% date = 1978-04-01T00:00:00Z
%
% [[author]]
% initials="M."
% surname="Crispin"
% fullname="M. Crispin"
% organization="SU-AI"

{mainmatter}

# Command name and code

    RANDOMLY-LOSE    256

# Command meanings

IAC WILL RANDOMLY-LOSE:
:  The sender of this command REQUESTS permission to, or confirms
   that it will, randomly lose.

IAC WON'T RANDOMLY-LOSE:
:   The sender of this command REFUSES to randomly lose.

IAC DO RANDOMLY-LOSE:
:   The sender of this command REQUESTS that the receiver, or grants
    the receiver permission to, randomly lose.

IAC DON'T RANDOMLY-LOSE:
:   The command sender DEMANDS that the receiver not randomly lose.

# Default

{align="left"}
        WON'T RANDOMLY-LOSE

        DON'T RANDOMLY-LOSE

i.e., random lossage will not happen.

# Motivation for the option

Several hosts appear to provide random lossage, such as system
crashes, lost data, incorrectly functioning programs, etc., as part
of their services. These services are often undocumented and are in
general quite confusing to the novice user.  A general means is
needed to allow the user to disable these features.

# Description of the option

The normal mode does not allow random lossage; therefore the system
is not allowed to crash, mung user files, etc. If the server wants
to provide random lossage, it must first ask for permission from the
user by sending IAC WILL RANDOMLY-LOSE.

If the user wants to permit the server to randomly lose, it replys
with IAC DO  RANDOMLY-LOSE. Otherwise it  sends  IAC  DONT
RANDOMLY-LOSE, and the server is forbidden from randomly losing.

Alternatively, the user could request the server to randomly lose, by
sending IAC DO RANDOMLY-LOSE, and the server will either reply with
IAC WILL RANDOMLY-LOSE, meaning that it will then proceed to do some
random lossage (garbaging disk files is recommended for an initial
implementation).  Or, it could send IAC WONT RANDOMLY-LOSE, meaning
that it insists upon being reliable.

Since this is implemented as a TELNET option, it is expected that
servers which do not implement this option will not randomly lose;
ie, they will provide 100% reliable uptime.

{backmatter}
