// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/websecurityscanner/v1beta/scan_run.proto

package websecurityscanner

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Types of ScanRun execution state.
type ScanRun_ExecutionState int32

const (
	// Represents an invalid state caused by internal server error. This value
	// should never be returned.
	ScanRun_EXECUTION_STATE_UNSPECIFIED ScanRun_ExecutionState = 0
	// The scan is waiting in the queue.
	ScanRun_QUEUED ScanRun_ExecutionState = 1
	// The scan is in progress.
	ScanRun_SCANNING ScanRun_ExecutionState = 2
	// The scan is either finished or stopped by user.
	ScanRun_FINISHED ScanRun_ExecutionState = 3
)

var ScanRun_ExecutionState_name = map[int32]string{
	0: "EXECUTION_STATE_UNSPECIFIED",
	1: "QUEUED",
	2: "SCANNING",
	3: "FINISHED",
}

var ScanRun_ExecutionState_value = map[string]int32{
	"EXECUTION_STATE_UNSPECIFIED": 0,
	"QUEUED":                      1,
	"SCANNING":                    2,
	"FINISHED":                    3,
}

func (x ScanRun_ExecutionState) String() string {
	return proto.EnumName(ScanRun_ExecutionState_name, int32(x))
}

func (ScanRun_ExecutionState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_2eb36166aad58bfe, []int{0, 0}
}

// Types of ScanRun result state.
type ScanRun_ResultState int32

const (
	// Default value. This value is returned when the ScanRun is not yet
	// finished.
	ScanRun_RESULT_STATE_UNSPECIFIED ScanRun_ResultState = 0
	// The scan finished without errors.
	ScanRun_SUCCESS ScanRun_ResultState = 1
	// The scan finished with errors.
	ScanRun_ERROR ScanRun_ResultState = 2
	// The scan was terminated by user.
	ScanRun_KILLED ScanRun_ResultState = 3
)

var ScanRun_ResultState_name = map[int32]string{
	0: "RESULT_STATE_UNSPECIFIED",
	1: "SUCCESS",
	2: "ERROR",
	3: "KILLED",
}

var ScanRun_ResultState_value = map[string]int32{
	"RESULT_STATE_UNSPECIFIED": 0,
	"SUCCESS":                  1,
	"ERROR":                    2,
	"KILLED":                   3,
}

func (x ScanRun_ResultState) String() string {
	return proto.EnumName(ScanRun_ResultState_name, int32(x))
}

func (ScanRun_ResultState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_2eb36166aad58bfe, []int{0, 1}
}

// A ScanRun is a output-only resource representing an actual run of the scan.
// Next id: 12
type ScanRun struct {
	// The resource name of the ScanRun. The name follows the format of
	// 'projects/{projectId}/scanConfigs/{scanConfigId}/scanRuns/{scanRunId}'.
	// The ScanRun IDs are generated by the system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The execution state of the ScanRun.
	ExecutionState ScanRun_ExecutionState `protobuf:"varint,2,opt,name=execution_state,json=executionState,proto3,enum=google.cloud.websecurityscanner.v1beta.ScanRun_ExecutionState" json:"execution_state,omitempty"`
	// The result state of the ScanRun. This field is only available after the
	// execution state reaches "FINISHED".
	ResultState ScanRun_ResultState `protobuf:"varint,3,opt,name=result_state,json=resultState,proto3,enum=google.cloud.websecurityscanner.v1beta.ScanRun_ResultState" json:"result_state,omitempty"`
	// The time at which the ScanRun started.
	StartTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time at which the ScanRun reached termination state - that the ScanRun
	// is either finished or stopped by user.
	EndTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The number of URLs crawled during this ScanRun. If the scan is in progress,
	// the value represents the number of URLs crawled up to now.
	UrlsCrawledCount int64 `protobuf:"varint,6,opt,name=urls_crawled_count,json=urlsCrawledCount,proto3" json:"urls_crawled_count,omitempty"`
	// The number of URLs tested during this ScanRun. If the scan is in progress,
	// the value represents the number of URLs tested up to now. The number of
	// URLs tested is usually larger than the number URLS crawled because
	// typically a crawled URL is tested with multiple test payloads.
	UrlsTestedCount int64 `protobuf:"varint,7,opt,name=urls_tested_count,json=urlsTestedCount,proto3" json:"urls_tested_count,omitempty"`
	// Whether the scan run has found any vulnerabilities.
	HasVulnerabilities bool `protobuf:"varint,8,opt,name=has_vulnerabilities,json=hasVulnerabilities,proto3" json:"has_vulnerabilities,omitempty"`
	// The percentage of total completion ranging from 0 to 100.
	// If the scan is in queue, the value is 0.
	// If the scan is running, the value ranges from 0 to 100.
	// If the scan is finished, the value is 100.
	ProgressPercent int32 `protobuf:"varint,9,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// If result_state is an ERROR, this field provides the primary reason for
	// scan's termination and more details, if such are available.
	ErrorTrace *ScanRunErrorTrace `protobuf:"bytes,10,opt,name=error_trace,json=errorTrace,proto3" json:"error_trace,omitempty"`
	// A list of warnings, if such are encountered during this scan run.
	WarningTraces        []*ScanRunWarningTrace `protobuf:"bytes,11,rep,name=warning_traces,json=warningTraces,proto3" json:"warning_traces,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *ScanRun) Reset()         { *m = ScanRun{} }
func (m *ScanRun) String() string { return proto.CompactTextString(m) }
func (*ScanRun) ProtoMessage()    {}
func (*ScanRun) Descriptor() ([]byte, []int) {
	return fileDescriptor_2eb36166aad58bfe, []int{0}
}

func (m *ScanRun) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScanRun.Unmarshal(m, b)
}
func (m *ScanRun) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScanRun.Marshal(b, m, deterministic)
}
func (m *ScanRun) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanRun.Merge(m, src)
}
func (m *ScanRun) XXX_Size() int {
	return xxx_messageInfo_ScanRun.Size(m)
}
func (m *ScanRun) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanRun.DiscardUnknown(m)
}

var xxx_messageInfo_ScanRun proto.InternalMessageInfo

func (m *ScanRun) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ScanRun) GetExecutionState() ScanRun_ExecutionState {
	if m != nil {
		return m.ExecutionState
	}
	return ScanRun_EXECUTION_STATE_UNSPECIFIED
}

func (m *ScanRun) GetResultState() ScanRun_ResultState {
	if m != nil {
		return m.ResultState
	}
	return ScanRun_RESULT_STATE_UNSPECIFIED
}

func (m *ScanRun) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *ScanRun) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *ScanRun) GetUrlsCrawledCount() int64 {
	if m != nil {
		return m.UrlsCrawledCount
	}
	return 0
}

func (m *ScanRun) GetUrlsTestedCount() int64 {
	if m != nil {
		return m.UrlsTestedCount
	}
	return 0
}

func (m *ScanRun) GetHasVulnerabilities() bool {
	if m != nil {
		return m.HasVulnerabilities
	}
	return false
}

func (m *ScanRun) GetProgressPercent() int32 {
	if m != nil {
		return m.ProgressPercent
	}
	return 0
}

func (m *ScanRun) GetErrorTrace() *ScanRunErrorTrace {
	if m != nil {
		return m.ErrorTrace
	}
	return nil
}

func (m *ScanRun) GetWarningTraces() []*ScanRunWarningTrace {
	if m != nil {
		return m.WarningTraces
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.websecurityscanner.v1beta.ScanRun_ExecutionState", ScanRun_ExecutionState_name, ScanRun_ExecutionState_value)
	proto.RegisterEnum("google.cloud.websecurityscanner.v1beta.ScanRun_ResultState", ScanRun_ResultState_name, ScanRun_ResultState_value)
	proto.RegisterType((*ScanRun)(nil), "google.cloud.websecurityscanner.v1beta.ScanRun")
}

func init() {
	proto.RegisterFile("google/cloud/websecurityscanner/v1beta/scan_run.proto", fileDescriptor_2eb36166aad58bfe)
}

var fileDescriptor_2eb36166aad58bfe = []byte{
	// 694 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x94, 0x5f, 0x4f, 0xdb, 0x3a,
	0x18, 0xc6, 0x4f, 0x5a, 0xa0, 0xad, 0xcb, 0x29, 0x39, 0x3e, 0x37, 0x19, 0x9b, 0x44, 0xc5, 0x05,
	0x2a, 0x68, 0x4a, 0x34, 0x26, 0x2e, 0x18, 0xd2, 0xb4, 0x12, 0x02, 0xab, 0x86, 0x4a, 0x97, 0xb4,
	0xc0, 0x10, 0x5a, 0xe4, 0xa6, 0x26, 0x64, 0x4a, 0xed, 0xc8, 0x76, 0xe8, 0x26, 0xc4, 0x67, 0xdb,
	0xfd, 0x3e, 0xca, 0xb4, 0x0f, 0x31, 0xc5, 0x4e, 0x80, 0x0a, 0x24, 0xe8, 0x9d, 0xdf, 0x3f, 0xcf,
	0xef, 0x49, 0xde, 0xbc, 0x0e, 0xd8, 0x0a, 0x29, 0x0d, 0x63, 0x6c, 0x05, 0x31, 0x4d, 0x47, 0xd6,
	0x04, 0x0f, 0x39, 0x0e, 0x52, 0x16, 0x89, 0x1f, 0x3c, 0x40, 0x84, 0x60, 0x66, 0x5d, 0xbd, 0x19,
	0x62, 0x81, 0xac, 0x2c, 0xf4, 0x59, 0x4a, 0xcc, 0x84, 0x51, 0x41, 0xe1, 0x9a, 0x92, 0x99, 0x52,
	0x66, 0x3e, 0x94, 0x99, 0x4a, 0xb6, 0xfc, 0x22, 0xc7, 0xa3, 0x24, 0xb2, 0x18, 0xe6, 0x34, 0x65,
	0x01, 0x56, 0x88, 0xe5, 0xf6, 0x8c, 0xce, 0x3e, 0x66, 0x8c, 0x32, 0x5f, 0x30, 0x74, 0x8b, 0xb0,
	0x67, 0x45, 0x4c, 0x10, 0x23, 0x11, 0x09, 0xa7, 0x20, 0x2b, 0x39, 0x44, 0x46, 0xc3, 0xf4, 0xc2,
	0x12, 0xd1, 0x18, 0x73, 0x81, 0xc6, 0x89, 0x6a, 0x58, 0xfd, 0x53, 0x01, 0x15, 0x2f, 0x40, 0xc4,
	0x4d, 0x09, 0x84, 0x60, 0x8e, 0xa0, 0x31, 0x36, 0xb4, 0xa6, 0xd6, 0xaa, 0xb9, 0xf2, 0x0c, 0x43,
	0xb0, 0x84, 0xbf, 0xe3, 0x20, 0x15, 0x11, 0x25, 0x3e, 0x17, 0x48, 0x60, 0xa3, 0xd4, 0xd4, 0x5a,
	0x8d, 0xcd, 0xf7, 0xe6, 0xf3, 0xa6, 0x64, 0xe6, 0x74, 0xd3, 0x29, 0x30, 0x5e, 0x46, 0x71, 0x1b,
	0x78, 0x2a, 0x86, 0x5f, 0xc1, 0x22, 0xc3, 0x3c, 0x8d, 0x45, 0xee, 0x52, 0x96, 0x2e, 0x3b, 0xb3,
	0xba, 0xb8, 0x92, 0xa1, 0x2c, 0xea, 0xec, 0x2e, 0x80, 0xdb, 0x00, 0x70, 0x81, 0x98, 0xf0, 0xb3,
	0x09, 0x18, 0x73, 0x4d, 0xad, 0x55, 0xdf, 0x5c, 0x2e, 0xe8, 0xc5, 0x78, 0xcc, 0x7e, 0x31, 0x1e,
	0xb7, 0x26, 0xbb, 0xb3, 0x18, 0x6e, 0x81, 0x2a, 0x26, 0x23, 0x25, 0x9c, 0x7f, 0x52, 0x58, 0xc1,
	0x64, 0x24, 0x65, 0xaf, 0x01, 0x4c, 0x59, 0xcc, 0xfd, 0x80, 0xa1, 0x49, 0x8c, 0x47, 0x7e, 0x40,
	0x53, 0x22, 0x8c, 0x85, 0xa6, 0xd6, 0x2a, 0xbb, 0x7a, 0x56, 0xb1, 0x55, 0xc1, 0xce, 0xf2, 0x70,
	0x03, 0xfc, 0x27, 0xbb, 0x05, 0xe6, 0xe2, 0xb6, 0xb9, 0x22, 0x9b, 0x97, 0xb2, 0x42, 0x5f, 0xe6,
	0x55, 0xaf, 0x05, 0xfe, 0xbf, 0x44, 0xdc, 0xbf, 0x4a, 0x63, 0x82, 0x19, 0x1a, 0x46, 0x71, 0x24,
	0x22, 0xcc, 0x8d, 0x6a, 0x53, 0x6b, 0x55, 0x5d, 0x78, 0x89, 0xf8, 0xf1, 0x74, 0x05, 0xae, 0x03,
	0x3d, 0x61, 0x34, 0x64, 0x98, 0x73, 0x3f, 0xc1, 0x2c, 0xc0, 0x44, 0x18, 0xb5, 0xa6, 0xd6, 0x9a,
	0x77, 0x97, 0x8a, 0x7c, 0x4f, 0xa5, 0xe1, 0x19, 0xa8, 0xdf, 0xdb, 0x45, 0x03, 0xc8, 0xf7, 0xdd,
	0x9e, 0xf1, 0x33, 0x38, 0x19, 0xa1, 0x9f, 0x01, 0x5c, 0x80, 0x6f, 0xcf, 0x70, 0x08, 0x1a, 0x53,
	0x4b, 0xca, 0x8d, 0x7a, 0xb3, 0xdc, 0xaa, 0xcf, 0xfc, 0x95, 0x4f, 0x14, 0x44, 0x19, 0xfc, 0x3b,
	0xb9, 0x17, 0xf1, 0xd5, 0x2f, 0xa0, 0x31, 0xbd, 0x69, 0x70, 0x05, 0xbc, 0x74, 0x4e, 0x1d, 0x7b,
	0xd0, 0xef, 0x1c, 0x75, 0x7d, 0xaf, 0xdf, 0xee, 0x3b, 0xfe, 0xa0, 0xeb, 0xf5, 0x1c, 0xbb, 0xb3,
	0xdf, 0x71, 0xf6, 0xf4, 0x7f, 0x20, 0x00, 0x0b, 0x9f, 0x07, 0xce, 0xc0, 0xd9, 0xd3, 0x35, 0xb8,
	0x08, 0xaa, 0x9e, 0xdd, 0xee, 0x76, 0x3b, 0xdd, 0x03, 0xbd, 0x94, 0x45, 0xfb, 0x9d, 0x6e, 0xc7,
	0xfb, 0xe8, 0xec, 0xe9, 0xe5, 0xd5, 0x23, 0x50, 0xbf, 0xb7, 0x5e, 0xf0, 0x15, 0x30, 0x5c, 0xc7,
	0x1b, 0x1c, 0xf6, 0x1f, 0x85, 0xd6, 0x41, 0xc5, 0x1b, 0xd8, 0xb6, 0xe3, 0x79, 0xba, 0x06, 0x6b,
	0x60, 0xde, 0x71, 0xdd, 0x23, 0x57, 0x2f, 0x65, 0x66, 0x9f, 0x3a, 0x87, 0x87, 0x19, 0xf0, 0x5d,
	0xf2, 0xbb, 0x3d, 0x06, 0xeb, 0x8f, 0xbc, 0xae, 0x1a, 0x07, 0x4a, 0x22, 0x6e, 0x06, 0x74, 0x6c,
	0x15, 0x17, 0xf4, 0x43, 0xc2, 0xe8, 0x37, 0x1c, 0x08, 0x6e, 0x5d, 0xe7, 0xa7, 0x1b, 0x79, 0xfd,
	0x6d, 0x4a, 0x2e, 0xa2, 0x90, 0x5b, 0xd7, 0xf2, 0x5f, 0x10, 0xc8, 0x48, 0x55, 0xdc, 0x94, 0x14,
	0x69, 0x96, 0x92, 0x9b, 0xdd, 0x9f, 0x1a, 0xd8, 0x08, 0xe8, 0xf8, 0x99, 0xf3, 0xde, 0x5d, 0xcc,
	0x9d, 0x7b, 0xd9, 0x9a, 0xf7, 0xb4, 0xb3, 0xd3, 0x5c, 0x17, 0xd2, 0x18, 0x91, 0xd0, 0xa4, 0x2c,
	0xb4, 0x42, 0x4c, 0xe4, 0x25, 0xb0, 0xee, 0x9e, 0xf9, 0xa9, 0x5f, 0xd6, 0xce, 0xc3, 0xca, 0xaf,
	0xd2, 0xda, 0x81, 0xd4, 0x9f, 0xdb, 0x99, 0xf6, 0xfc, 0x04, 0x0f, 0xbd, 0xbc, 0xc3, 0x53, 0x1d,
	0xe7, 0xc7, 0x52, 0x3b, 0x5c, 0x90, 0x6e, 0x6f, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0x50, 0x7b,
	0xad, 0xac, 0xdc, 0x05, 0x00, 0x00,
}
