// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dataproc/v1/autoscaling_policies.proto

package dataproc

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Describes an autoscaling policy for Dataproc cluster autoscaler.
type AutoscalingPolicy struct {
	// Required. The policy id.
	//
	// The id must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), and hyphens (-). Cannot begin or end with underscore
	// or hyphen. Must consist of between 3 and 50 characters.
	//
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Output only. The "resource name" of the autoscaling policy, as described
	// in https://cloud.google.com/apis/design/resource_names.
	//
	// * For `projects.regions.autoscalingPolicies`, the resource name of the
	//   policy has the following format:
	//   `projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}`
	//
	// * For `projects.locations.autoscalingPolicies`, the resource name of the
	//   policy has the following format:
	//   `projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}`
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Autoscaling algorithm for policy.
	//
	// Types that are valid to be assigned to Algorithm:
	//	*AutoscalingPolicy_BasicAlgorithm
	Algorithm isAutoscalingPolicy_Algorithm `protobuf_oneof:"algorithm"`
	// Required. Describes how the autoscaler will operate for primary workers.
	WorkerConfig *InstanceGroupAutoscalingPolicyConfig `protobuf:"bytes,4,opt,name=worker_config,json=workerConfig,proto3" json:"worker_config,omitempty"`
	// Optional. Describes how the autoscaler will operate for secondary workers.
	SecondaryWorkerConfig *InstanceGroupAutoscalingPolicyConfig `protobuf:"bytes,5,opt,name=secondary_worker_config,json=secondaryWorkerConfig,proto3" json:"secondary_worker_config,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}                              `json:"-"`
	XXX_unrecognized      []byte                                `json:"-"`
	XXX_sizecache         int32                                 `json:"-"`
}

func (m *AutoscalingPolicy) Reset()         { *m = AutoscalingPolicy{} }
func (m *AutoscalingPolicy) String() string { return proto.CompactTextString(m) }
func (*AutoscalingPolicy) ProtoMessage()    {}
func (*AutoscalingPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49a4a9859d08ad9, []int{0}
}

func (m *AutoscalingPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AutoscalingPolicy.Unmarshal(m, b)
}
func (m *AutoscalingPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AutoscalingPolicy.Marshal(b, m, deterministic)
}
func (m *AutoscalingPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AutoscalingPolicy.Merge(m, src)
}
func (m *AutoscalingPolicy) XXX_Size() int {
	return xxx_messageInfo_AutoscalingPolicy.Size(m)
}
func (m *AutoscalingPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_AutoscalingPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_AutoscalingPolicy proto.InternalMessageInfo

func (m *AutoscalingPolicy) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *AutoscalingPolicy) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type isAutoscalingPolicy_Algorithm interface {
	isAutoscalingPolicy_Algorithm()
}

type AutoscalingPolicy_BasicAlgorithm struct {
	BasicAlgorithm *BasicAutoscalingAlgorithm `protobuf:"bytes,3,opt,name=basic_algorithm,json=basicAlgorithm,proto3,oneof"`
}

func (*AutoscalingPolicy_BasicAlgorithm) isAutoscalingPolicy_Algorithm() {}

func (m *AutoscalingPolicy) GetAlgorithm() isAutoscalingPolicy_Algorithm {
	if m != nil {
		return m.Algorithm
	}
	return nil
}

func (m *AutoscalingPolicy) GetBasicAlgorithm() *BasicAutoscalingAlgorithm {
	if x, ok := m.GetAlgorithm().(*AutoscalingPolicy_BasicAlgorithm); ok {
		return x.BasicAlgorithm
	}
	return nil
}

func (m *AutoscalingPolicy) GetWorkerConfig() *InstanceGroupAutoscalingPolicyConfig {
	if m != nil {
		return m.WorkerConfig
	}
	return nil
}

func (m *AutoscalingPolicy) GetSecondaryWorkerConfig() *InstanceGroupAutoscalingPolicyConfig {
	if m != nil {
		return m.SecondaryWorkerConfig
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AutoscalingPolicy) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AutoscalingPolicy_BasicAlgorithm)(nil),
	}
}

// Basic algorithm for autoscaling.
type BasicAutoscalingAlgorithm struct {
	// Required. YARN autoscaling configuration.
	YarnConfig *BasicYarnAutoscalingConfig `protobuf:"bytes,1,opt,name=yarn_config,json=yarnConfig,proto3" json:"yarn_config,omitempty"`
	// Optional. Duration between scaling events. A scaling period starts after
	// the update operation from the previous event has completed.
	//
	// Bounds: [2m, 1d]. Default: 2m.
	CooldownPeriod       *duration.Duration `protobuf:"bytes,2,opt,name=cooldown_period,json=cooldownPeriod,proto3" json:"cooldown_period,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *BasicAutoscalingAlgorithm) Reset()         { *m = BasicAutoscalingAlgorithm{} }
func (m *BasicAutoscalingAlgorithm) String() string { return proto.CompactTextString(m) }
func (*BasicAutoscalingAlgorithm) ProtoMessage()    {}
func (*BasicAutoscalingAlgorithm) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49a4a9859d08ad9, []int{1}
}

func (m *BasicAutoscalingAlgorithm) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BasicAutoscalingAlgorithm.Unmarshal(m, b)
}
func (m *BasicAutoscalingAlgorithm) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BasicAutoscalingAlgorithm.Marshal(b, m, deterministic)
}
func (m *BasicAutoscalingAlgorithm) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BasicAutoscalingAlgorithm.Merge(m, src)
}
func (m *BasicAutoscalingAlgorithm) XXX_Size() int {
	return xxx_messageInfo_BasicAutoscalingAlgorithm.Size(m)
}
func (m *BasicAutoscalingAlgorithm) XXX_DiscardUnknown() {
	xxx_messageInfo_BasicAutoscalingAlgorithm.DiscardUnknown(m)
}

var xxx_messageInfo_BasicAutoscalingAlgorithm proto.InternalMessageInfo

func (m *BasicAutoscalingAlgorithm) GetYarnConfig() *BasicYarnAutoscalingConfig {
	if m != nil {
		return m.YarnConfig
	}
	return nil
}

func (m *BasicAutoscalingAlgorithm) GetCooldownPeriod() *duration.Duration {
	if m != nil {
		return m.CooldownPeriod
	}
	return nil
}

// Basic autoscaling configurations for YARN.
type BasicYarnAutoscalingConfig struct {
	// Required. Timeout for YARN graceful decommissioning of Node Managers.
	// Specifies the duration to wait for jobs to complete before forcefully
	// removing workers (and potentially interrupting jobs). Only applicable to
	// downscaling operations.
	//
	// Bounds: [0s, 1d].
	GracefulDecommissionTimeout *duration.Duration `protobuf:"bytes,5,opt,name=graceful_decommission_timeout,json=gracefulDecommissionTimeout,proto3" json:"graceful_decommission_timeout,omitempty"`
	// Required. Fraction of average pending memory in the last cooldown period
	// for which to add workers. A scale-up factor of 1.0 will result in scaling
	// up so that there is no pending memory remaining after the update (more
	// aggressive scaling). A scale-up factor closer to 0 will result in a smaller
	// magnitude of scaling up (less aggressive scaling).
	//
	// Bounds: [0.0, 1.0].
	ScaleUpFactor float64 `protobuf:"fixed64,1,opt,name=scale_up_factor,json=scaleUpFactor,proto3" json:"scale_up_factor,omitempty"`
	// Required. Fraction of average pending memory in the last cooldown period
	// for which to remove workers. A scale-down factor of 1 will result in
	// scaling down so that there is no available memory remaining after the
	// update (more aggressive scaling). A scale-down factor of 0 disables
	// removing workers, which can be beneficial for autoscaling a single job.
	//
	// Bounds: [0.0, 1.0].
	ScaleDownFactor float64 `protobuf:"fixed64,2,opt,name=scale_down_factor,json=scaleDownFactor,proto3" json:"scale_down_factor,omitempty"`
	// Optional. Minimum scale-up threshold as a fraction of total cluster size
	// before scaling occurs. For example, in a 20-worker cluster, a threshold of
	// 0.1 means the autoscaler must recommend at least a 2-worker scale-up for
	// the cluster to scale. A threshold of 0 means the autoscaler will scale up
	// on any recommended change.
	//
	// Bounds: [0.0, 1.0]. Default: 0.0.
	ScaleUpMinWorkerFraction float64 `protobuf:"fixed64,3,opt,name=scale_up_min_worker_fraction,json=scaleUpMinWorkerFraction,proto3" json:"scale_up_min_worker_fraction,omitempty"`
	// Optional. Minimum scale-down threshold as a fraction of total cluster size
	// before scaling occurs. For example, in a 20-worker cluster, a threshold of
	// 0.1 means the autoscaler must recommend at least a 2 worker scale-down for
	// the cluster to scale. A threshold of 0 means the autoscaler will scale down
	// on any recommended change.
	//
	// Bounds: [0.0, 1.0]. Default: 0.0.
	ScaleDownMinWorkerFraction float64  `protobuf:"fixed64,4,opt,name=scale_down_min_worker_fraction,json=scaleDownMinWorkerFraction,proto3" json:"scale_down_min_worker_fraction,omitempty"`
	XXX_NoUnkeyedLiteral       struct{} `json:"-"`
	XXX_unrecognized           []byte   `json:"-"`
	XXX_sizecache              int32    `json:"-"`
}

func (m *BasicYarnAutoscalingConfig) Reset()         { *m = BasicYarnAutoscalingConfig{} }
func (m *BasicYarnAutoscalingConfig) String() string { return proto.CompactTextString(m) }
func (*BasicYarnAutoscalingConfig) ProtoMessage()    {}
func (*BasicYarnAutoscalingConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49a4a9859d08ad9, []int{2}
}

func (m *BasicYarnAutoscalingConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BasicYarnAutoscalingConfig.Unmarshal(m, b)
}
func (m *BasicYarnAutoscalingConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BasicYarnAutoscalingConfig.Marshal(b, m, deterministic)
}
func (m *BasicYarnAutoscalingConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BasicYarnAutoscalingConfig.Merge(m, src)
}
func (m *BasicYarnAutoscalingConfig) XXX_Size() int {
	return xxx_messageInfo_BasicYarnAutoscalingConfig.Size(m)
}
func (m *BasicYarnAutoscalingConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_BasicYarnAutoscalingConfig.DiscardUnknown(m)
}

var xxx_messageInfo_BasicYarnAutoscalingConfig proto.InternalMessageInfo

func (m *BasicYarnAutoscalingConfig) GetGracefulDecommissionTimeout() *duration.Duration {
	if m != nil {
		return m.GracefulDecommissionTimeout
	}
	return nil
}

func (m *BasicYarnAutoscalingConfig) GetScaleUpFactor() float64 {
	if m != nil {
		return m.ScaleUpFactor
	}
	return 0
}

func (m *BasicYarnAutoscalingConfig) GetScaleDownFactor() float64 {
	if m != nil {
		return m.ScaleDownFactor
	}
	return 0
}

func (m *BasicYarnAutoscalingConfig) GetScaleUpMinWorkerFraction() float64 {
	if m != nil {
		return m.ScaleUpMinWorkerFraction
	}
	return 0
}

func (m *BasicYarnAutoscalingConfig) GetScaleDownMinWorkerFraction() float64 {
	if m != nil {
		return m.ScaleDownMinWorkerFraction
	}
	return 0
}

// Configuration for the size bounds of an instance group, including its
// proportional size to other groups.
type InstanceGroupAutoscalingPolicyConfig struct {
	// Optional. Minimum number of instances for this group.
	//
	// Primary workers - Bounds: [2, max_instances]. Default: 2.
	// Secondary workers - Bounds: [0, max_instances]. Default: 0.
	MinInstances int32 `protobuf:"varint,1,opt,name=min_instances,json=minInstances,proto3" json:"min_instances,omitempty"`
	// Required. Maximum number of instances for this group. Required for primary
	// workers. Note that by default, clusters will not use secondary workers.
	// Required for secondary workers if the minimum secondary instances is set.
	//
	// Primary workers - Bounds: [min_instances, ).
	// Secondary workers - Bounds: [min_instances, ). Default: 0.
	MaxInstances int32 `protobuf:"varint,2,opt,name=max_instances,json=maxInstances,proto3" json:"max_instances,omitempty"`
	// Optional. Weight for the instance group, which is used to determine the
	// fraction of total workers in the cluster from this instance group.
	// For example, if primary workers have weight 2, and secondary workers have
	// weight 1, the cluster will have approximately 2 primary workers for each
	// secondary worker.
	//
	// The cluster may not reach the specified balance if constrained
	// by min/max bounds or other autoscaling settings. For example, if
	// `max_instances` for secondary workers is 0, then only primary workers will
	// be added. The cluster can also be out of balance when created.
	//
	// If weight is not set on any instance group, the cluster will default to
	// equal weight for all groups: the cluster will attempt to maintain an equal
	// number of workers in each group within the configured size bounds for each
	// group. If weight is set for one group only, the cluster will default to
	// zero weight on the unset group. For example if weight is set only on
	// primary workers, the cluster will use primary workers only and no
	// secondary workers.
	Weight               int32    `protobuf:"varint,3,opt,name=weight,proto3" json:"weight,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InstanceGroupAutoscalingPolicyConfig) Reset()         { *m = InstanceGroupAutoscalingPolicyConfig{} }
func (m *InstanceGroupAutoscalingPolicyConfig) String() string { return proto.CompactTextString(m) }
func (*InstanceGroupAutoscalingPolicyConfig) ProtoMessage()    {}
func (*InstanceGroupAutoscalingPolicyConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49a4a9859d08ad9, []int{3}
}

func (m *InstanceGroupAutoscalingPolicyConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstanceGroupAutoscalingPolicyConfig.Unmarshal(m, b)
}
func (m *InstanceGroupAutoscalingPolicyConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstanceGroupAutoscalingPolicyConfig.Marshal(b, m, deterministic)
}
func (m *InstanceGroupAutoscalingPolicyConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceGroupAutoscalingPolicyConfig.Merge(m, src)
}
func (m *InstanceGroupAutoscalingPolicyConfig) XXX_Size() int {
	return xxx_messageInfo_InstanceGroupAutoscalingPolicyConfig.Size(m)
}
func (m *InstanceGroupAutoscalingPolicyConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceGroupAutoscalingPolicyConfig.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceGroupAutoscalingPolicyConfig proto.InternalMessageInfo

func (m *InstanceGroupAutoscalingPolicyConfig) GetMinInstances() int32 {
	if m != nil {
		return m.MinInstances
	}
	return 0
}

func (m *InstanceGroupAutoscalingPolicyConfig) GetMaxInstances() int32 {
	if m != nil {
		return m.MaxInstances
	}
	return 0
}

func (m *InstanceGroupAutoscalingPolicyConfig) GetWeight() int32 {
	if m != nil {
		return m.Weight
	}
	return 0
}

// A request to create an autoscaling policy.
type CreateAutoscalingPolicyRequest struct {
	// Required. The "resource name" of the region or location, as described
	// in https://cloud.google.com/apis/design/resource_names.
	//
	// * For `projects.regions.autoscalingPolicies.create`, the resource name
	//   of the region has the following format:
	//   `projects/{project_id}/regions/{region}`
	//
	// * For `projects.locations.autoscalingPolicies.create`, the resource name
	//   of the location has the following format:
	//   `projects/{project_id}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The autoscaling policy to create.
	Policy               *AutoscalingPolicy `protobuf:"bytes,2,opt,name=policy,proto3" json:"policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *CreateAutoscalingPolicyRequest) Reset()         { *m = CreateAutoscalingPolicyRequest{} }
func (m *CreateAutoscalingPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*CreateAutoscalingPolicyRequest) ProtoMessage()    {}
func (*CreateAutoscalingPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49a4a9859d08ad9, []int{4}
}

func (m *CreateAutoscalingPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateAutoscalingPolicyRequest.Unmarshal(m, b)
}
func (m *CreateAutoscalingPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateAutoscalingPolicyRequest.Marshal(b, m, deterministic)
}
func (m *CreateAutoscalingPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateAutoscalingPolicyRequest.Merge(m, src)
}
func (m *CreateAutoscalingPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_CreateAutoscalingPolicyRequest.Size(m)
}
func (m *CreateAutoscalingPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateAutoscalingPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateAutoscalingPolicyRequest proto.InternalMessageInfo

func (m *CreateAutoscalingPolicyRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateAutoscalingPolicyRequest) GetPolicy() *AutoscalingPolicy {
	if m != nil {
		return m.Policy
	}
	return nil
}

// A request to fetch an autoscaling policy.
type GetAutoscalingPolicyRequest struct {
	// Required. The "resource name" of the autoscaling policy, as described
	// in https://cloud.google.com/apis/design/resource_names.
	//
	// * For `projects.regions.autoscalingPolicies.get`, the resource name
	//   of the policy has the following format:
	//   `projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}`
	//
	// * For `projects.locations.autoscalingPolicies.get`, the resource name
	//   of the policy has the following format:
	//   `projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAutoscalingPolicyRequest) Reset()         { *m = GetAutoscalingPolicyRequest{} }
func (m *GetAutoscalingPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*GetAutoscalingPolicyRequest) ProtoMessage()    {}
func (*GetAutoscalingPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49a4a9859d08ad9, []int{5}
}

func (m *GetAutoscalingPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAutoscalingPolicyRequest.Unmarshal(m, b)
}
func (m *GetAutoscalingPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAutoscalingPolicyRequest.Marshal(b, m, deterministic)
}
func (m *GetAutoscalingPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAutoscalingPolicyRequest.Merge(m, src)
}
func (m *GetAutoscalingPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_GetAutoscalingPolicyRequest.Size(m)
}
func (m *GetAutoscalingPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAutoscalingPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAutoscalingPolicyRequest proto.InternalMessageInfo

func (m *GetAutoscalingPolicyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request to update an autoscaling policy.
type UpdateAutoscalingPolicyRequest struct {
	// Required. The updated autoscaling policy.
	Policy               *AutoscalingPolicy `protobuf:"bytes,1,opt,name=policy,proto3" json:"policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *UpdateAutoscalingPolicyRequest) Reset()         { *m = UpdateAutoscalingPolicyRequest{} }
func (m *UpdateAutoscalingPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateAutoscalingPolicyRequest) ProtoMessage()    {}
func (*UpdateAutoscalingPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49a4a9859d08ad9, []int{6}
}

func (m *UpdateAutoscalingPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateAutoscalingPolicyRequest.Unmarshal(m, b)
}
func (m *UpdateAutoscalingPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateAutoscalingPolicyRequest.Marshal(b, m, deterministic)
}
func (m *UpdateAutoscalingPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateAutoscalingPolicyRequest.Merge(m, src)
}
func (m *UpdateAutoscalingPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateAutoscalingPolicyRequest.Size(m)
}
func (m *UpdateAutoscalingPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateAutoscalingPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateAutoscalingPolicyRequest proto.InternalMessageInfo

func (m *UpdateAutoscalingPolicyRequest) GetPolicy() *AutoscalingPolicy {
	if m != nil {
		return m.Policy
	}
	return nil
}

// A request to delete an autoscaling policy.
//
// Autoscaling policies in use by one or more clusters will not be deleted.
type DeleteAutoscalingPolicyRequest struct {
	// Required. The "resource name" of the autoscaling policy, as described
	// in https://cloud.google.com/apis/design/resource_names.
	//
	// * For `projects.regions.autoscalingPolicies.delete`, the resource name
	//   of the policy has the following format:
	//   `projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}`
	//
	// * For `projects.locations.autoscalingPolicies.delete`, the resource name
	//   of the policy has the following format:
	//   `projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteAutoscalingPolicyRequest) Reset()         { *m = DeleteAutoscalingPolicyRequest{} }
func (m *DeleteAutoscalingPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteAutoscalingPolicyRequest) ProtoMessage()    {}
func (*DeleteAutoscalingPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49a4a9859d08ad9, []int{7}
}

func (m *DeleteAutoscalingPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteAutoscalingPolicyRequest.Unmarshal(m, b)
}
func (m *DeleteAutoscalingPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteAutoscalingPolicyRequest.Marshal(b, m, deterministic)
}
func (m *DeleteAutoscalingPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteAutoscalingPolicyRequest.Merge(m, src)
}
func (m *DeleteAutoscalingPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteAutoscalingPolicyRequest.Size(m)
}
func (m *DeleteAutoscalingPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteAutoscalingPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteAutoscalingPolicyRequest proto.InternalMessageInfo

func (m *DeleteAutoscalingPolicyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request to list autoscaling policies in a project.
type ListAutoscalingPoliciesRequest struct {
	// Required. The "resource name" of the region or location, as described
	// in https://cloud.google.com/apis/design/resource_names.
	//
	// * For `projects.regions.autoscalingPolicies.list`, the resource name
	//   of the region has the following format:
	//   `projects/{project_id}/regions/{region}`
	//
	// * For `projects.locations.autoscalingPolicies.list`, the resource name
	//   of the location has the following format:
	//   `projects/{project_id}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of results to return in each response.
	// Must be less than or equal to 1000. Defaults to 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The page token, returned by a previous call, to request the
	// next page of results.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAutoscalingPoliciesRequest) Reset()         { *m = ListAutoscalingPoliciesRequest{} }
func (m *ListAutoscalingPoliciesRequest) String() string { return proto.CompactTextString(m) }
func (*ListAutoscalingPoliciesRequest) ProtoMessage()    {}
func (*ListAutoscalingPoliciesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49a4a9859d08ad9, []int{8}
}

func (m *ListAutoscalingPoliciesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAutoscalingPoliciesRequest.Unmarshal(m, b)
}
func (m *ListAutoscalingPoliciesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAutoscalingPoliciesRequest.Marshal(b, m, deterministic)
}
func (m *ListAutoscalingPoliciesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAutoscalingPoliciesRequest.Merge(m, src)
}
func (m *ListAutoscalingPoliciesRequest) XXX_Size() int {
	return xxx_messageInfo_ListAutoscalingPoliciesRequest.Size(m)
}
func (m *ListAutoscalingPoliciesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAutoscalingPoliciesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListAutoscalingPoliciesRequest proto.InternalMessageInfo

func (m *ListAutoscalingPoliciesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListAutoscalingPoliciesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListAutoscalingPoliciesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// A response to a request to list autoscaling policies in a project.
type ListAutoscalingPoliciesResponse struct {
	// Output only. Autoscaling policies list.
	Policies []*AutoscalingPolicy `protobuf:"bytes,1,rep,name=policies,proto3" json:"policies,omitempty"`
	// Output only. This token is included in the response if there are more
	// results to fetch.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAutoscalingPoliciesResponse) Reset()         { *m = ListAutoscalingPoliciesResponse{} }
func (m *ListAutoscalingPoliciesResponse) String() string { return proto.CompactTextString(m) }
func (*ListAutoscalingPoliciesResponse) ProtoMessage()    {}
func (*ListAutoscalingPoliciesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49a4a9859d08ad9, []int{9}
}

func (m *ListAutoscalingPoliciesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAutoscalingPoliciesResponse.Unmarshal(m, b)
}
func (m *ListAutoscalingPoliciesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAutoscalingPoliciesResponse.Marshal(b, m, deterministic)
}
func (m *ListAutoscalingPoliciesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAutoscalingPoliciesResponse.Merge(m, src)
}
func (m *ListAutoscalingPoliciesResponse) XXX_Size() int {
	return xxx_messageInfo_ListAutoscalingPoliciesResponse.Size(m)
}
func (m *ListAutoscalingPoliciesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAutoscalingPoliciesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListAutoscalingPoliciesResponse proto.InternalMessageInfo

func (m *ListAutoscalingPoliciesResponse) GetPolicies() []*AutoscalingPolicy {
	if m != nil {
		return m.Policies
	}
	return nil
}

func (m *ListAutoscalingPoliciesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*AutoscalingPolicy)(nil), "google.cloud.dataproc.v1.AutoscalingPolicy")
	proto.RegisterType((*BasicAutoscalingAlgorithm)(nil), "google.cloud.dataproc.v1.BasicAutoscalingAlgorithm")
	proto.RegisterType((*BasicYarnAutoscalingConfig)(nil), "google.cloud.dataproc.v1.BasicYarnAutoscalingConfig")
	proto.RegisterType((*InstanceGroupAutoscalingPolicyConfig)(nil), "google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig")
	proto.RegisterType((*CreateAutoscalingPolicyRequest)(nil), "google.cloud.dataproc.v1.CreateAutoscalingPolicyRequest")
	proto.RegisterType((*GetAutoscalingPolicyRequest)(nil), "google.cloud.dataproc.v1.GetAutoscalingPolicyRequest")
	proto.RegisterType((*UpdateAutoscalingPolicyRequest)(nil), "google.cloud.dataproc.v1.UpdateAutoscalingPolicyRequest")
	proto.RegisterType((*DeleteAutoscalingPolicyRequest)(nil), "google.cloud.dataproc.v1.DeleteAutoscalingPolicyRequest")
	proto.RegisterType((*ListAutoscalingPoliciesRequest)(nil), "google.cloud.dataproc.v1.ListAutoscalingPoliciesRequest")
	proto.RegisterType((*ListAutoscalingPoliciesResponse)(nil), "google.cloud.dataproc.v1.ListAutoscalingPoliciesResponse")
}

func init() {
	proto.RegisterFile("google/cloud/dataproc/v1/autoscaling_policies.proto", fileDescriptor_e49a4a9859d08ad9)
}

var fileDescriptor_e49a4a9859d08ad9 = []byte{
	// 1240 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x57, 0xc1, 0x8f, 0x14, 0xc5,
	0x17, 0xfe, 0x55, 0xef, 0xb2, 0x61, 0x6b, 0x59, 0x08, 0x95, 0x9f, 0xce, 0x30, 0x8b, 0xc3, 0xa6,
	0xf5, 0x80, 0x8b, 0x4e, 0x07, 0x90, 0xa0, 0xa8, 0x68, 0x0f, 0x0b, 0x0b, 0x11, 0x93, 0x49, 0x03,
	0x31, 0xee, 0xa5, 0x53, 0xdb, 0x5d, 0xd3, 0x53, 0xd0, 0xdd, 0xd5, 0x56, 0xd7, 0xec, 0xb0, 0x6c,
	0x36, 0x46, 0xfe, 0x02, 0xa3, 0x07, 0x63, 0xc2, 0xc1, 0xc4, 0xbb, 0x89, 0x07, 0xef, 0x1e, 0x3c,
	0xe9, 0xc1, 0x44, 0x6f, 0x9c, 0x38, 0x98, 0x98, 0x10, 0xfe, 0x02, 0xbd, 0x98, 0xae, 0xaa, 0x9e,
	0x69, 0x98, 0xe9, 0xde, 0x9d, 0x15, 0x6f, 0x33, 0xf5, 0xde, 0xfb, 0xde, 0x7b, 0x5f, 0x7d, 0xaf,
	0xaa, 0x1a, 0x9e, 0x0d, 0x18, 0x0b, 0x42, 0x62, 0x79, 0x21, 0xeb, 0xfb, 0x96, 0x8f, 0x05, 0x4e,
	0x38, 0xf3, 0xac, 0xcd, 0xd3, 0x16, 0xee, 0x0b, 0x96, 0x7a, 0x38, 0xa4, 0x71, 0xe0, 0x26, 0x2c,
	0xa4, 0x1e, 0x25, 0x69, 0x2b, 0xe1, 0x4c, 0x30, 0x54, 0x57, 0x41, 0x2d, 0x19, 0xd4, 0xca, 0x83,
	0x5a, 0x9b, 0xa7, 0x1b, 0xc7, 0x35, 0x1c, 0x4e, 0xa8, 0x85, 0xe3, 0x98, 0x09, 0x2c, 0x28, 0x8b,
	0x75, 0x5c, 0xa3, 0x56, 0xb0, 0x7a, 0x21, 0x25, 0xb1, 0xd0, 0x86, 0x13, 0x05, 0x43, 0x97, 0x92,
	0xd0, 0x77, 0x37, 0x48, 0x0f, 0x6f, 0x52, 0xc6, 0xb5, 0xc3, 0xb1, 0x82, 0x03, 0x27, 0x29, 0xeb,
	0x73, 0x8f, 0x68, 0x53, 0x53, 0x9b, 0xe4, 0xbf, 0x8d, 0x7e, 0xd7, 0xf2, 0xfb, 0x5c, 0x66, 0xd5,
	0xf6, 0xa5, 0x67, 0xed, 0x24, 0x4a, 0xc4, 0x96, 0x32, 0x9a, 0x7f, 0xce, 0xc2, 0xa3, 0xf6, 0xa8,
	0xd1, 0x4e, 0xd6, 0xe7, 0x16, 0x3a, 0x0c, 0x0d, 0xea, 0xd7, 0xc1, 0x32, 0x38, 0x39, 0xef, 0x18,
	0xd4, 0x47, 0x35, 0x38, 0x1b, 0xe3, 0x88, 0xd4, 0x8d, 0x6c, 0xa5, 0x3d, 0xf3, 0xc8, 0x9e, 0x71,
	0xe4, 0x02, 0xf2, 0xe0, 0x91, 0x0d, 0x9c, 0x52, 0xcf, 0xc5, 0x61, 0xc0, 0x38, 0x15, 0xbd, 0xa8,
	0x3e, 0xb3, 0x0c, 0x4e, 0x2e, 0x9c, 0x39, 0xdb, 0x2a, 0xa3, 0xa8, 0xd5, 0xce, 0x02, 0x0a, 0x39,
	0xed, 0x3c, 0x34, 0x03, 0x36, 0xae, 0xfe, 0xcf, 0x39, 0x2c, 0x21, 0x87, 0xcb, 0xa8, 0x07, 0x17,
	0x07, 0x8c, 0xdf, 0x21, 0xdc, 0xf5, 0x58, 0xdc, 0xa5, 0x41, 0x7d, 0x56, 0xa6, 0xb8, 0x58, 0x9e,
	0xe2, 0x5a, 0x9c, 0x0a, 0x1c, 0x7b, 0x64, 0x8d, 0xb3, 0x7e, 0x32, 0xd6, 0xde, 0x25, 0x89, 0x22,
	0xb3, 0x39, 0x87, 0x14, 0xb2, 0x5a, 0x42, 0xdb, 0xb0, 0x96, 0x12, 0x8f, 0xc5, 0x3e, 0xe6, 0x5b,
	0xee, 0xd3, 0x39, 0x0f, 0x3c, 0xaf, 0x9c, 0xc0, 0x79, 0x61, 0x98, 0xe3, 0xa3, 0x42, 0xf2, 0x0b,
	0xbf, 0x82, 0xc7, 0xf6, 0x2f, 0x00, 0xbe, 0x3a, 0x04, 0x55, 0xa9, 0x70, 0x42, 0xd3, 0x96, 0xc7,
	0x22, 0x6b, 0x7c, 0x9b, 0x3a, 0x09, 0x67, 0xb7, 0x89, 0x27, 0x52, 0x6b, 0x5b, 0xff, 0xda, 0xb1,
	0x42, 0xe6, 0x29, 0xc9, 0x59, 0xdb, 0xf9, 0xcf, 0x9d, 0xa2, 0x94, 0x3b, 0x5a, 0xc9, 0xd6, 0xf6,
	0x98, 0xbe, 0xb7, 0x76, 0xd0, 0xf5, 0x09, 0x88, 0x9c, 0x04, 0x0a, 0x4f, 0xfd, 0xd8, 0x3b, 0x5a,
	0x7b, 0x01, 0xce, 0x0f, 0x75, 0x61, 0xfe, 0x08, 0xe0, 0xb1, 0xd2, 0xad, 0x47, 0xeb, 0x70, 0x61,
	0x0b, 0xf3, 0x38, 0x67, 0x1b, 0x48, 0xb6, 0xdf, 0xd8, 0x45, 0x44, 0x1f, 0x63, 0x1e, 0x17, 0xd0,
	0x8a, 0xfb, 0x0a, 0x33, 0x34, 0xbd, 0xab, 0x6b, 0xf0, 0x88, 0xc7, 0x58, 0xe8, 0xb3, 0x41, 0xec,
	0x26, 0x84, 0x53, 0xe6, 0x4b, 0x21, 0x2f, 0x9c, 0x39, 0x96, 0xe3, 0xe7, 0xa3, 0xd1, 0x5a, 0xd5,
	0xa3, 0xa3, 0x36, 0xea, 0x70, 0x1e, 0xd6, 0x91, 0x51, 0xe6, 0x13, 0x03, 0x36, 0xca, 0x13, 0xa3,
	0x0d, 0xf8, 0x52, 0xc0, 0xb1, 0x47, 0xba, 0xfd, 0xd0, 0xf5, 0x89, 0xc7, 0xa2, 0x88, 0xa6, 0x29,
	0x65, 0xb1, 0x2b, 0x68, 0x44, 0x58, 0x5f, 0x68, 0x0d, 0x55, 0x67, 0x35, 0x9c, 0xa5, 0x1c, 0x64,
	0xb5, 0x80, 0x71, 0x53, 0x41, 0xa0, 0x53, 0xf0, 0x48, 0x96, 0x94, 0xb8, 0xfd, 0xc4, 0xed, 0x62,
	0x4f, 0x30, 0x2e, 0xb9, 0x02, 0x2a, 0x74, 0x51, 0xda, 0x6e, 0x25, 0x57, 0xa4, 0x05, 0x59, 0xf0,
	0xa8, 0x72, 0x96, 0xad, 0x6b, 0x77, 0x63, 0xe4, 0xae, 0xa0, 0x56, 0xd9, 0x20, 0xd6, 0x01, 0x97,
	0xe0, 0xf1, 0x21, 0x7a, 0x44, 0xe3, 0x7c, 0x04, 0xba, 0x1c, 0x7b, 0x59, 0x7d, 0x72, 0xb6, 0x81,
	0xe2, 0xa6, 0xae, 0x53, 0x7d, 0x48, 0x63, 0xa5, 0xe2, 0x2b, 0xda, 0x09, 0xad, 0xc1, 0x66, 0x21,
	0xeb, 0x24, 0x98, 0xd9, 0x11, 0x4c, 0x63, 0x58, 0xc2, 0x18, 0x90, 0xf9, 0x15, 0x80, 0xaf, 0xec,
	0x65, 0xaa, 0xd0, 0x49, 0xb8, 0x98, 0xa5, 0xa1, 0xda, 0x37, 0x95, 0x94, 0x1c, 0x50, 0x09, 0x0e,
	0x45, 0x34, 0xce, 0x41, 0x52, 0xe9, 0x89, 0xef, 0x16, 0x3c, 0x8d, 0xdc, 0xd3, 0x70, 0x0e, 0x45,
	0xf8, 0xee, 0xc8, 0x73, 0x09, 0xce, 0x0d, 0x08, 0x0d, 0x7a, 0x42, 0x36, 0xad, 0xc1, 0xf4, 0x92,
	0xf9, 0x03, 0x80, 0xcd, 0x4b, 0x9c, 0x60, 0x41, 0xc6, 0x4a, 0x72, 0xc8, 0x27, 0x7d, 0x92, 0x0a,
	0x74, 0x0d, 0xce, 0x25, 0x98, 0x93, 0x58, 0xa8, 0x63, 0xb4, 0x7d, 0xfa, 0x91, 0x6d, 0xfc, 0x65,
	0x9f, 0x42, 0x7b, 0x1f, 0x6f, 0x47, 0x03, 0xa0, 0xab, 0x70, 0x4e, 0x4d, 0x94, 0x96, 0xed, 0xa9,
	0xf2, 0xb1, 0x18, 0x03, 0x51, 0xad, 0xe9, 0x78, 0xd3, 0x87, 0x4b, 0x6b, 0x44, 0x94, 0xd6, 0x7c,
	0x59, 0x1f, 0xf3, 0x4f, 0x55, 0x3c, 0xc5, 0x81, 0xa4, 0x2e, 0x05, 0xf3, 0x36, 0x6c, 0xde, 0x4a,
	0xfc, 0x2a, 0x72, 0x46, 0x1d, 0x81, 0x7f, 0xd9, 0x51, 0x00, 0x9b, 0xab, 0x24, 0x24, 0x15, 0xb9,
	0x9e, 0x53, 0x53, 0xdf, 0x03, 0xd8, 0xbc, 0x4e, 0xd3, 0x31, 0xf2, 0x28, 0x49, 0xff, 0x83, 0x2d,
	0x5f, 0x86, 0xf3, 0x09, 0x0e, 0x88, 0x9b, 0xd2, 0x7b, 0x64, 0xa4, 0x51, 0xe0, 0x1c, 0xcc, 0x56,
	0x6f, 0xd0, 0x7b, 0x04, 0x99, 0x10, 0x4a, 0x0f, 0xc1, 0xee, 0x10, 0x35, 0x98, 0xf3, 0xca, 0x45,
	0x06, 0xde, 0xcc, 0x56, 0xcd, 0x07, 0x00, 0x9e, 0x28, 0xad, 0x39, 0x4d, 0x58, 0x9c, 0x12, 0x74,
	0x1d, 0x1e, 0xcc, 0x1f, 0x37, 0x75, 0xb0, 0x3c, 0xb3, 0x8f, 0xcd, 0x98, 0x71, 0x86, 0x08, 0xd9,
	0xf1, 0x14, 0x93, 0xbb, 0xc2, 0x2d, 0x94, 0x56, 0x78, 0x33, 0x2c, 0x66, 0xb6, 0x4e, 0x5e, 0xde,
	0x99, 0xef, 0x16, 0x60, 0x7d, 0x0c, 0xf1, 0x06, 0xe1, 0x9b, 0xd4, 0x23, 0xe8, 0x81, 0x01, 0x6b,
	0x25, 0x23, 0x86, 0xde, 0x2c, 0xaf, 0xb0, 0x7a, 0x2a, 0x1b, 0xd3, 0xf4, 0x66, 0x7e, 0x0d, 0x1e,
	0xda, 0x8b, 0x6a, 0x43, 0x5e, 0x53, 0x72, 0xbb, 0xff, 0xfb, 0x1f, 0x5f, 0x1a, 0xf7, 0x81, 0x79,
	0x3e, 0x7b, 0x1f, 0x6e, 0x2b, 0xd3, 0xbb, 0xc3, 0x2b, 0x73, 0xa5, 0x70, 0xf9, 0xae, 0x4c, 0xbc,
	0x26, 0x2f, 0x68, 0xd9, 0xae, 0xbf, 0x67, 0x9e, 0x2b, 0x81, 0xc8, 0x6f, 0xdb, 0x6a, 0x00, 0xf4,
	0xad, 0x01, 0x6b, 0x25, 0x43, 0x56, 0x45, 0x4f, 0xf5, 0x5c, 0x4e, 0x47, 0xcf, 0x37, 0xe0, 0xa1,
	0x3d, 0x57, 0xe0, 0xe5, 0x73, 0xd0, 0xb8, 0xa8, 0x9a, 0x92, 0x6b, 0xad, 0x6c, 0x6c, 0x4a, 0xc8,
	0x99, 0xf8, 0x84, 0x58, 0xd9, 0x19, 0xd2, 0x73, 0xa5, 0xf1, 0x4e, 0x15, 0xd2, 0x90, 0xa3, 0x5d,
	0x70, 0xd0, 0xdf, 0x00, 0xfe, 0x7f, 0xd2, 0x81, 0x87, 0xce, 0x95, 0x37, 0x5a, 0x71, 0x40, 0x4e,
	0xc7, 0xcf, 0xa7, 0x0f, 0x6d, 0x79, 0x74, 0x48, 0x72, 0x38, 0x52, 0x9a, 0x99, 0x9e, 0x94, 0xf5,
	0xf3, 0xe8, 0xdc, 0xc4, 0xd0, 0xdd, 0x58, 0x40, 0x5f, 0x18, 0xb0, 0x56, 0x32, 0xfe, 0x55, 0x1a,
	0xa9, 0x3e, 0xe5, 0x1a, 0x6f, 0xed, 0x23, 0x52, 0x9d, 0x35, 0xe6, 0x67, 0x52, 0x31, 0x52, 0xf2,
	0x4f, 0x91, 0x32, 0xfd, 0x20, 0x0d, 0x49, 0x99, 0x76, 0x80, 0xd0, 0x13, 0x00, 0x6b, 0x25, 0x37,
	0x46, 0x15, 0x29, 0xd5, 0x97, 0x4c, 0xe3, 0xc5, 0xb1, 0x37, 0xdd, 0xe5, 0xec, 0x23, 0xeb, 0x19,
	0x0d, 0xac, 0xec, 0x5f, 0x03, 0x2b, 0xfb, 0xd3, 0x40, 0xe3, 0x83, 0x9f, 0xed, 0x5a, 0xc9, 0xf5,
	0xf3, 0x9b, 0xdd, 0xea, 0x09, 0x91, 0xa4, 0x17, 0x2c, 0x6b, 0x30, 0x18, 0x3c, 0x7b, 0x37, 0xe1,
	0xbe, 0xe8, 0xa9, 0x8f, 0xe2, 0xd7, 0x93, 0x10, 0x8b, 0x2e, 0xe3, 0x51, 0xfb, 0x27, 0xf0, 0xd8,
	0xbe, 0x0c, 0x9b, 0x65, 0xd7, 0x99, 0x23, 0x8b, 0x41, 0x2f, 0xef, 0xe1, 0x1b, 0x02, 0x1e, 0xf7,
	0x58, 0x54, 0xca, 0x76, 0xbb, 0x3e, 0x41, 0x45, 0x9d, 0x8c, 0xd9, 0x0e, 0x58, 0x7f, 0x5f, 0x47,
	0x05, 0x2c, 0xc4, 0x71, 0xd0, 0x62, 0x3c, 0xb0, 0x02, 0x12, 0x4b, 0xde, 0xad, 0x51, 0x41, 0xe3,
	0xdf, 0xf3, 0x6f, 0xe7, 0xbf, 0x37, 0xe6, 0xa4, 0xf3, 0xd9, 0x7f, 0x02, 0x00, 0x00, 0xff, 0xff,
	0xa7, 0x1d, 0x58, 0x93, 0xfb, 0x0f, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AutoscalingPolicyServiceClient is the client API for AutoscalingPolicyService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AutoscalingPolicyServiceClient interface {
	// Creates new autoscaling policy.
	CreateAutoscalingPolicy(ctx context.Context, in *CreateAutoscalingPolicyRequest, opts ...grpc.CallOption) (*AutoscalingPolicy, error)
	// Updates (replaces) autoscaling policy.
	//
	// Disabled check for update_mask, because all updates will be full
	// replacements.
	UpdateAutoscalingPolicy(ctx context.Context, in *UpdateAutoscalingPolicyRequest, opts ...grpc.CallOption) (*AutoscalingPolicy, error)
	// Retrieves autoscaling policy.
	GetAutoscalingPolicy(ctx context.Context, in *GetAutoscalingPolicyRequest, opts ...grpc.CallOption) (*AutoscalingPolicy, error)
	// Lists autoscaling policies in the project.
	ListAutoscalingPolicies(ctx context.Context, in *ListAutoscalingPoliciesRequest, opts ...grpc.CallOption) (*ListAutoscalingPoliciesResponse, error)
	// Deletes an autoscaling policy. It is an error to delete an autoscaling
	// policy that is in use by one or more clusters.
	DeleteAutoscalingPolicy(ctx context.Context, in *DeleteAutoscalingPolicyRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type autoscalingPolicyServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAutoscalingPolicyServiceClient(cc grpc.ClientConnInterface) AutoscalingPolicyServiceClient {
	return &autoscalingPolicyServiceClient{cc}
}

func (c *autoscalingPolicyServiceClient) CreateAutoscalingPolicy(ctx context.Context, in *CreateAutoscalingPolicyRequest, opts ...grpc.CallOption) (*AutoscalingPolicy, error) {
	out := new(AutoscalingPolicy)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.AutoscalingPolicyService/CreateAutoscalingPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoscalingPolicyServiceClient) UpdateAutoscalingPolicy(ctx context.Context, in *UpdateAutoscalingPolicyRequest, opts ...grpc.CallOption) (*AutoscalingPolicy, error) {
	out := new(AutoscalingPolicy)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.AutoscalingPolicyService/UpdateAutoscalingPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoscalingPolicyServiceClient) GetAutoscalingPolicy(ctx context.Context, in *GetAutoscalingPolicyRequest, opts ...grpc.CallOption) (*AutoscalingPolicy, error) {
	out := new(AutoscalingPolicy)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.AutoscalingPolicyService/GetAutoscalingPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoscalingPolicyServiceClient) ListAutoscalingPolicies(ctx context.Context, in *ListAutoscalingPoliciesRequest, opts ...grpc.CallOption) (*ListAutoscalingPoliciesResponse, error) {
	out := new(ListAutoscalingPoliciesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.AutoscalingPolicyService/ListAutoscalingPolicies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoscalingPolicyServiceClient) DeleteAutoscalingPolicy(ctx context.Context, in *DeleteAutoscalingPolicyRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.AutoscalingPolicyService/DeleteAutoscalingPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AutoscalingPolicyServiceServer is the server API for AutoscalingPolicyService service.
type AutoscalingPolicyServiceServer interface {
	// Creates new autoscaling policy.
	CreateAutoscalingPolicy(context.Context, *CreateAutoscalingPolicyRequest) (*AutoscalingPolicy, error)
	// Updates (replaces) autoscaling policy.
	//
	// Disabled check for update_mask, because all updates will be full
	// replacements.
	UpdateAutoscalingPolicy(context.Context, *UpdateAutoscalingPolicyRequest) (*AutoscalingPolicy, error)
	// Retrieves autoscaling policy.
	GetAutoscalingPolicy(context.Context, *GetAutoscalingPolicyRequest) (*AutoscalingPolicy, error)
	// Lists autoscaling policies in the project.
	ListAutoscalingPolicies(context.Context, *ListAutoscalingPoliciesRequest) (*ListAutoscalingPoliciesResponse, error)
	// Deletes an autoscaling policy. It is an error to delete an autoscaling
	// policy that is in use by one or more clusters.
	DeleteAutoscalingPolicy(context.Context, *DeleteAutoscalingPolicyRequest) (*empty.Empty, error)
}

// UnimplementedAutoscalingPolicyServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAutoscalingPolicyServiceServer struct {
}

func (*UnimplementedAutoscalingPolicyServiceServer) CreateAutoscalingPolicy(ctx context.Context, req *CreateAutoscalingPolicyRequest) (*AutoscalingPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAutoscalingPolicy not implemented")
}
func (*UnimplementedAutoscalingPolicyServiceServer) UpdateAutoscalingPolicy(ctx context.Context, req *UpdateAutoscalingPolicyRequest) (*AutoscalingPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAutoscalingPolicy not implemented")
}
func (*UnimplementedAutoscalingPolicyServiceServer) GetAutoscalingPolicy(ctx context.Context, req *GetAutoscalingPolicyRequest) (*AutoscalingPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAutoscalingPolicy not implemented")
}
func (*UnimplementedAutoscalingPolicyServiceServer) ListAutoscalingPolicies(ctx context.Context, req *ListAutoscalingPoliciesRequest) (*ListAutoscalingPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAutoscalingPolicies not implemented")
}
func (*UnimplementedAutoscalingPolicyServiceServer) DeleteAutoscalingPolicy(ctx context.Context, req *DeleteAutoscalingPolicyRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAutoscalingPolicy not implemented")
}

func RegisterAutoscalingPolicyServiceServer(s *grpc.Server, srv AutoscalingPolicyServiceServer) {
	s.RegisterService(&_AutoscalingPolicyService_serviceDesc, srv)
}

func _AutoscalingPolicyService_CreateAutoscalingPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAutoscalingPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalingPolicyServiceServer).CreateAutoscalingPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.AutoscalingPolicyService/CreateAutoscalingPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalingPolicyServiceServer).CreateAutoscalingPolicy(ctx, req.(*CreateAutoscalingPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoscalingPolicyService_UpdateAutoscalingPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAutoscalingPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalingPolicyServiceServer).UpdateAutoscalingPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.AutoscalingPolicyService/UpdateAutoscalingPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalingPolicyServiceServer).UpdateAutoscalingPolicy(ctx, req.(*UpdateAutoscalingPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoscalingPolicyService_GetAutoscalingPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAutoscalingPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalingPolicyServiceServer).GetAutoscalingPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.AutoscalingPolicyService/GetAutoscalingPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalingPolicyServiceServer).GetAutoscalingPolicy(ctx, req.(*GetAutoscalingPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoscalingPolicyService_ListAutoscalingPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAutoscalingPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalingPolicyServiceServer).ListAutoscalingPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.AutoscalingPolicyService/ListAutoscalingPolicies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalingPolicyServiceServer).ListAutoscalingPolicies(ctx, req.(*ListAutoscalingPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoscalingPolicyService_DeleteAutoscalingPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAutoscalingPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalingPolicyServiceServer).DeleteAutoscalingPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.AutoscalingPolicyService/DeleteAutoscalingPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalingPolicyServiceServer).DeleteAutoscalingPolicy(ctx, req.(*DeleteAutoscalingPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AutoscalingPolicyService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataproc.v1.AutoscalingPolicyService",
	HandlerType: (*AutoscalingPolicyServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateAutoscalingPolicy",
			Handler:    _AutoscalingPolicyService_CreateAutoscalingPolicy_Handler,
		},
		{
			MethodName: "UpdateAutoscalingPolicy",
			Handler:    _AutoscalingPolicyService_UpdateAutoscalingPolicy_Handler,
		},
		{
			MethodName: "GetAutoscalingPolicy",
			Handler:    _AutoscalingPolicyService_GetAutoscalingPolicy_Handler,
		},
		{
			MethodName: "ListAutoscalingPolicies",
			Handler:    _AutoscalingPolicyService_ListAutoscalingPolicies_Handler,
		},
		{
			MethodName: "DeleteAutoscalingPolicy",
			Handler:    _AutoscalingPolicyService_DeleteAutoscalingPolicy_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataproc/v1/autoscaling_policies.proto",
}
