/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This package contains factory API for creating instances of maps with user defined {@link com.gs.collections.api.block.HashingStrategy}s.
 * <p>
 *     This package contains 2 interfaces:
 * <ul>
 *     <li>
 *          {@link com.gs.collections.api.factory.map.ImmutableMapFactory} - a factory which creates instances of type {@link com.gs.collections.api.map.ImmutableMap} with user defined hashing strategy.
 *     </li>
 *     <li>
 *          {@link com.gs.collections.api.factory.map.MutableMapFactory} - a factory which creates instances of type {@link com.gs.collections.api.map.MutableMap} with user defined hashing strategy.
 *     </li>
 * </ul>
 * </p>
 */
package com.gs.collections.api.factory.map.strategy;
