#!/usr/bin/env python3
#
# Copyright (c) 2023 Paul Mattes.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the names of Paul Mattes nor the names of his contributors
#       may be used to endorse or promote products derived from this software
#       without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY PAUL MATTES "AS IS" AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
# EVENT SHALL PAUL MATTES BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
# OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
# OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
# ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# x3270 test target host, TELNET consumer class.

from abc import ABC, abstractmethod

from telnet_proto import *

# Prototype TELNET consumer class
class consumer(ABC):
    @abstractmethod
    def rcv_data(data: bytes):
        '''Consume data'''
        pass
    @abstractmethod
    def rcv_sb(option: telopt, data: bytes):
        '''Consume SB'''
        pass
    @abstractmethod
    def rcv_will(option: telopt) -> bool:
        '''Approve WILL option'''
        pass
    @abstractmethod
    def rcv_wont(option: telopt) -> bool:
        '''Approve of WONT option'''
        pass
    @abstractmethod
    def rcv_do(option: telopt) -> bool:
        '''Approve DO option'''
        pass
    @abstractmethod
    def rcv_dont(option: telopt) -> bool:
        '''Notify of DONT option'''
        pass
    @abstractmethod
    def rcv_cmd(cmd: telcmd):
        '''Notify of command'''
        pass
