#ifndef _SQLITE_INTER_H // -*-C++-*-
#define _SQLITE_INTER_H

// Glue functions for talking to libsqlite3

#include <stdfuns.h>
#include <KayaAPI.h>
#include <sqlite3.h>

using namespace std;

class SQLiteConnection : public gc {
public:
    sqlite3* db;
    int ok;
};

class SQLiteStatement : public gc_cleanup {
public:
    sqlite3_stmt* stmt;
    SQLiteStatement(sqlite3_stmt* s):stmt(s) {}
    ~SQLiteStatement() {
      if (stmt != NULL) {
        sqlite3_finalize(stmt);
      }
    }
};

class SQLiteResult : public gc {
public:
    KArray res_table;
    KArray col_names;
    int rows;
    int cols;
    int res;
    sqlite3_stmt* resptr;
};

extern "C" {
    void* sqlite_connect(wchar_t* info);
    int sqlite_ok(void* con);
    wchar_t* sqlite_getError(void* con);
    void sqlite_close(void* con);
    void* sqlite_exec(void* con, wchar_t* query);
    void* sqlite_incexec(void* con, wchar_t* query);
    KArray sqlite_getrow(void* vmptr, void* con);
    void sqlite_discard(void* sptr);

    void* sqlite_execp(void* stptr, KArray params);
    void* sqlite_prepare(void* vmptr, void* con, wchar_t* query);

    KArray sql_getcolnames(void* res);
    KArray sql_getrestable(void* res);
    int sql_numrows(void* res);
    int sql_numcols(void* res);
    int sql_resrc(void* res);
}

#endif
