/***************************************************************************
                          filetransferp2p.h -  description
                             -------------------
    begin                : Sun 12 19 2004
    copyright            : (C) 2004 by Diederik van der Boor
    email                : vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILETRANSFERP2P_H
#define FILETRANSFERP2P_H

#include "p2papplication.h"

#include <QImage>
#include <QString>


class MsnObject;
class MimeMessage;
class P2PMessage;
class QFile;
class ThumbnailProvider;



/**
 * An application class responsable for P2P file transfers between clients.
 *
 * @author Diederik van der Boor
 * @ingroup Applications
 */
class FileTransferP2P : public P2PApplication
{
  Q_OBJECT

  public:
    // The constructor without filename (sufficient for incoming sessions)
                           FileTransferP2P(ApplicationList *applicationList);
    // The constructor with filename to start a session
                           FileTransferP2P(ApplicationList *applicationList, const QString &filename);

    // The destructor
    virtual               ~FileTransferP2P();

    // Return the application's GUID
    static QString         getAppId();


  private:
    // The contact cancelled the session
    void                   contactAborted(const QString &message = QString::null);
    // Step one of a contact-started chat: the contact invites the user
    void                   contactStarted1_ContactInvitesUser(const MimeMessage& message);
    // Step two of a contact-started chat: the user accepts
    void                   contactStarted2_UserAccepts();
    // Step three of a contact-started chat: the contact confirms the accept
    void                   contactStarted3_ContactConfirmsAccept(const MimeMessage& message);
    // Step four of a contact-started chat: the contact confirms the data-preparation message.
    void                   contactStarted4_ContactConfirmsPreparation();
    // Create the context field
    QString                createContextField( const QFile *fileData, bool usePreview ) const;
    // End the application with another message in the file transfer dialog as well (The "failTransfer"-like method)
    void                   endApplication();
    // Return an reject message to display.
    QString                getContactAbortMessage() const;
    // Return a cancel message to display.
    QString                getUserAbortMessage() const;
    // Return a cancel message to display.
    QString                getUserRejectMessage() const;
    // Called when data is received
    void                   gotData(const P2PMessage &message);
    // Show the file transfer dialog
    void                   initializeProgressDialog(bool incoming, uint filesize);
    // Called when the transfer is complete.
    void                   showTransferComplete();
    // Show a message to inform about a transfer event (shown in the transfer dialog, e.g. connecting to host)
    void                   showTransferMessage(const QString &message);
    // Show the progress made during a transfer.
    void                   showTransferProgress(const ulong bytesTransferred);
    // Convert a string to some more readable form
    QString                toReadableBytes(uint bytes);
    // The user cancelled the session
    void                   userAborted();
    // Step one of a user-started chat: the user invites the contact
    void                   userStarted1_UserInvitesContact();
    // Step two of a user-started chat: the contact accepts
    void                   userStarted2_ContactAccepts(const MimeMessage &message);
    // Step three of a user-started chat: the user prepares for the session
    void                   userStarted3_UserPrepares();


  private slots:
    // Cancel the file transfer
    void                   slotCancelTransfer( int transferID );
    // Called when the thumbnail is generated
    void                   userStarted1_gotThumbnailResult();


  private:
    // Handle of the file.
    QFile                 *file_;
    // Name of the transferred file.
    QString                fileName_;
    // Full path of the file where the data should be stored.
    QString                filePath_;
    // The size of the file
    unsigned int           fileSize_;
    // The file preview
    QImage                 preview_;
    // The suggested file name
    QString                suggestedFileName_;
    // The thumbnail provider
    ThumbnailProvider     *thumbnailProvider_;
    // The ID of this transfer, used by the Transfer Window
    int                    transferID_;
};

#endif
