/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.resolve.annotation;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/resolveAnnotations/parameters")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class AnnotationParameterTestGenerated extends AbstractAnnotationParameterTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInParameters() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/resolveAnnotations/parameters"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("byte.kt")
    public void testByte() throws Exception {
        runTest("compiler/testData/resolveAnnotations/parameters/byte.kt");
    }

    @TestMetadata("char.kt")
    public void testChar() throws Exception {
        runTest("compiler/testData/resolveAnnotations/parameters/char.kt");
    }

    @TestMetadata("double.kt")
    public void testDouble() throws Exception {
        runTest("compiler/testData/resolveAnnotations/parameters/double.kt");
    }

    @TestMetadata("float.kt")
    public void testFloat() throws Exception {
        runTest("compiler/testData/resolveAnnotations/parameters/float.kt");
    }

    @TestMetadata("int.kt")
    public void testInt() throws Exception {
        runTest("compiler/testData/resolveAnnotations/parameters/int.kt");
    }

    @TestMetadata("long.kt")
    public void testLong() throws Exception {
        runTest("compiler/testData/resolveAnnotations/parameters/long.kt");
    }

    @TestMetadata("short.kt")
    public void testShort() throws Exception {
        runTest("compiler/testData/resolveAnnotations/parameters/short.kt");
    }

    @TestMetadata("compiler/testData/resolveAnnotations/parameters/expressions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Expressions extends AbstractAnnotationParameterTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInExpressions() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/testData/resolveAnnotations/parameters/expressions"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("andAnd.kt")
        public void testAndAnd() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/andAnd.kt");
        }

        @TestMetadata("boolean.kt")
        public void testBoolean() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/boolean.kt");
        }

        @TestMetadata("char.kt")
        public void testChar() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/char.kt");
        }

        @TestMetadata("compositeCallBinary.kt")
        public void testCompositeCallBinary() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/compositeCallBinary.kt");
        }

        @TestMetadata("divide.kt")
        public void testDivide() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/divide.kt");
        }

        @TestMetadata("double.kt")
        public void testDouble() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/double.kt");
        }

        @TestMetadata("eqeq.kt")
        public void testEqeq() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/eqeq.kt");
        }

        @TestMetadata("escapedString.kt")
        public void testEscapedString() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/escapedString.kt");
        }

        @TestMetadata("float.kt")
        public void testFloat() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/float.kt");
        }

        @TestMetadata("gt.kt")
        public void testGt() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/gt.kt");
        }

        @TestMetadata("gteq.kt")
        public void testGteq() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/gteq.kt");
        }

        @TestMetadata("intrincics.kt")
        public void testIntrincics() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/intrincics.kt");
        }

        @TestMetadata("labeled.kt")
        public void testLabeled() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/labeled.kt");
        }

        @TestMetadata("long.kt")
        public void testLong() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/long.kt");
        }

        @TestMetadata("lt.kt")
        public void testLt() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/lt.kt");
        }

        @TestMetadata("lteq.kt")
        public void testLteq() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/lteq.kt");
        }

        @TestMetadata("maxValue.kt")
        public void testMaxValue() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/maxValue.kt");
        }

        @TestMetadata("maxValueByte.kt")
        public void testMaxValueByte() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/maxValueByte.kt");
        }

        @TestMetadata("maxValueInt.kt")
        public void testMaxValueInt() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/maxValueInt.kt");
        }

        @TestMetadata("miltiply.kt")
        public void testMiltiply() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/miltiply.kt");
        }

        @TestMetadata("minus.kt")
        public void testMinus() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/minus.kt");
        }

        @TestMetadata("mod.kt")
        public void testMod() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/mod.kt");
        }

        @TestMetadata("multilineString.kt")
        public void testMultilineString() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/multilineString.kt");
        }

        @TestMetadata("not.kt")
        public void testNot() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/not.kt");
        }

        @TestMetadata("noteq.kt")
        public void testNoteq() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/noteq.kt");
        }

        @TestMetadata("orOr.kt")
        public void testOrOr() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/orOr.kt");
        }

        @TestMetadata("paranthesized.kt")
        public void testParanthesized() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/paranthesized.kt");
        }

        @TestMetadata("plus.kt")
        public void testPlus() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/plus.kt");
        }

        @TestMetadata("simpleCallBinary.kt")
        public void testSimpleCallBinary() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/simpleCallBinary.kt");
        }

        @TestMetadata("stringPlusInt.kt")
        public void testStringPlusInt() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/stringPlusInt.kt");
        }

        @TestMetadata("stringTemplate.kt")
        public void testStringTemplate() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/stringTemplate.kt");
        }

        @TestMetadata("strings.kt")
        public void testStrings() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/strings.kt");
        }

        @TestMetadata("unaryMinus.kt")
        public void testUnaryMinus() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/unaryMinus.kt");
        }

        @TestMetadata("unaryPlus.kt")
        public void testUnaryPlus() throws Exception {
            runTest("compiler/testData/resolveAnnotations/parameters/expressions/unaryPlus.kt");
        }
    }
}
