/* This file is part of libhud-qt
 * Copyright 2013 Canonical Ltd.
 *
 * libhud-qt is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * libhud-qt is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// todo, how to relay back the live changes in the paramters

#include "parameter.h"

using namespace Ubuntu::HUD;

class Ubuntu::HUD::Parameter::Private
{
public:
    QString type;
    QString name;
    QVariant currentValue;
    QVariant defaultValue;
};

Parameter::Parameter(QObject *parent)
    : QObject(parent)
{
    d = new Private;
}

Parameter::~Parameter()
{
    delete d;
}

QString
Parameter::type() const
{
    return d->type;
}

void
Parameter::setType(const QString &type)
{
    if (d->type == type)
        return;
    d->type = type;
    emit typeChanged(type);
}

QVariant
Parameter::defaultValue()
{
    return d->defaultValue;
}

QVariant
Parameter::currentValue()
{
    return d->currentValue;
}

QString
Parameter::name() const
{
    return d->name;
}
