
## Tutorials

Tutorials for mlpack can be found [here : mlpack tutorials](https://www.mlpack.org/doc/mlpack-git/doxygen/tutorials.html).


### General mlpack tutorials

These tutorials introduce the basic concepts of working with mlpack, aimed at developers who want to use and contribute to mlpack but are not sure where to start.

* [Building mlpack from source](https://www.mlpack.org/doc/mlpack-git/doxygen/build.html)
* [File Formats in mlpack](https://www.mlpack.org/doc/mlpack-git/doxygen/formatdoc.html)
* [Matrices in mlpack](https://www.mlpack.org/doc/mlpack-git/doxygen/matrices.html)
* [mlpack input and output](https://www.mlpack.org/doc/mlpack-git/doxygen/iodoc.html)
* [mlpack timers](https://www.mlpack.org/doc/mlpack-git/doxygen/timer.html)
* [Simple sample mlpack programs](https://www.mlpack.org/doc/mlpack-git/doxygen/sample.html)


### Method-specific tutorials

These tutorials introduce the various methods mlpack offers, aimed at users who want to get started quickly. These tutorials start with simple examples and progress to complex, extensible uses.

* [NeighborSearch tutorial (mlpack_knn / mlpack_kfn)](https://www.mlpack.org/doc/mlpack-git/doxygen/nstutorial.html)
* [LinearRegression tutorial (mlpack_linear_regression)](https://www.mlpack.org/doc/mlpack-git/doxygen/lrtutorial.html)
* [RangeSearch tutorial (mlpack_range_search)](https://www.mlpack.org/doc/mlpack-git/doxygen/rstutorial.html)
* [Density Estimation Trees tutorial (mlpack_det)](https://www.mlpack.org/doc/mlpack-git/doxygen/dettutorial.html)
* [K-Means tutorial (mlpack_kmeans)](https://www.mlpack.org/doc/mlpack-git/doxygen/kmtutorial.html)
* [FastMKS tutorial (mlpack_fastmks)](https://www.mlpack.org/doc/mlpack-git/doxygen/fmkstutorial.html)
* [Euclidean Minimum Spanning Trees tutorial (mlpack_emst)](https://www.mlpack.org/doc/mlpack-git/doxygen/emst_tutorial.html)
* [Alternating Matrix Factorization Tutorial](https://www.mlpack.org/doc/mlpack-git/doxygen/amftutorial.html)
* [Collaborative Filtering Tutorial](https://www.mlpack.org/doc/mlpack-git/doxygen/cftutorial.html)


### Policy Class Documentation

mlpack uses templates to achieve its genericity and flexibility. Some of the template types used by mlpack are common across multiple machine learning algorithms. The links below provide documentation for some of these common types.

* [The MetricType policy in mlpack](https://www.mlpack.org/doc/mlpack-git/doxygen/metrics.html)
* [The KernelType policy in mlpack](https://www.mlpack.org/doc/mlpack-git/doxygen/kernels.html)
* [The TreeType policy in mlpack](https://www.mlpack.org/doc/mlpack-git/doxygen/trees.html)
