/* 
  Copyright (C) 2008 Kai Hertel

	This file is part of mmpong.

	mmpong is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	mmpong is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with mmpong.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __HELPERS_HEADER__
#define __HELPERS_HEADER__

#include <math.h>
#include "game.h"
#include "dllhelper.h"


#ifdef __cplusplus
extern "C" {
#endif

EXPORT int bounce_ball_linear(struct gameplay *, float *, float *, float, float, float);


static inline int outside(ball)
const struct gameball *ball;
{
	if ((ball->pos[0] < 0) || (ball->pos[1] < 0)) return (-1);
	if ((ball->pos[0] > 1) || (ball->pos[1] > 1)) return 1;
	return 0;
}



static inline float outby(val)
float val;
{
	if (val < 0) return val;
	if (val > 1) return val -1;
	return 0;
}



static inline int hit(pad, pos)
const struct gamepaddle *pad;
float pos;
{
	return (pad->mean - pad->size/2 <= pos) && (pad->mean + pad->size/2 >= pos);
}



static inline float distance(p,q)
const float p[2], q[2];
{
	float scp= 0;
	for (int idx= 0; idx< 2; idx++) {
		float h= p[idx] - q[idx];
		scp+= h * h;
	}
	return sqrtf(scp);
}

#ifdef __cplusplus
}
#endif

#endif

