#
# beforedir.mms - make variables and rules to go before "dir.mk".  This file
# contains some platform-independent stuff then includes a platform-specific
# ".mms" file.
#

#############################################################################
#
# Standard directories in import/export trees
#

INCDIR = include
IDLDIR = idl
MAKEDIR = mk
LIBDIR = lib/$(platform)
BINDIR = bin/$(platform)
LIBPATH = $(EXPORT_TREE)/$(LIBDIR)
BINPATH = $(EXPORT_TREE)/$(BINDIR)

LIBPATH_V=$(SUBST ..,-,$(LIBPATH))
LIBPATH_V=$(SUBST /,.,$(LIBPATH_V))
LIBPATH_V=[$(SUBST .-,-,$(LIBPATH_V))]

BINPATH_V=$(SUBST ..,-,$(BINPATH))
BINPATH_V=$(SUBST /,.,$(BINPATH_V))
BINPATH_V=[$(SUBST .-,-,$(BINPATH_V))]

BASE_OMNI_TREE = $(TOP)

.ifdef DEBUG
CONFIG_SUFFIX=D
CONFIG_DIR=debug
.ELSE
CONFIG_DIR=release
.ENDIF
CONFIG_DIR_V=[.$(CONFIG_DIR)]

ShareableImageSuffix=_RT$(CONFIG_SUFFIX)

#.default
#	$(VERBOSITY) ! Default rule for $@

.suffixes
.suffixes : .EXE .OLB .OBJ .CC .C

.OBJ.OLB :
	$(VERBOSITY) If "''F$Search("$@")'" .EQS. "" Then $(LIBR)/Create $@
	$(VERBOSITY) $(LIBR)$(LIBRFLAGS) $@ $<
	$(VERBOSITY) ! assume mms/skip: once an object has been stored in a\
 library it can
	$(VERBOSITY) !be removed.
	$(VERBOSITY) object = f$parse("$<","","","NAME") + ".OBJ"
	$(VERBOSITY) if f$search(object) .nes. "" then delete 'object';*

.include $(top)/mk/platforms/$(platform).mms

.ifdef COMPILE_VERIFY
.else
COMPILE_VERIFY=0
.endif
