/*###############################################################################
# Linux Management Providers (LMP), CPU provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr ,desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Rakhimov Rustam, TUIT <rusyasoft@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_ASSOCIATEDPROCESSORCACHEMEMORYACCESS_H_
#define OPENDRIM_ASSOCIATEDPROCESSORCACHEMEMORYACCESS_H_

#include "CPU_Common.h"

#include "OpenDRIM_AssociatedProcessorCacheMemory.h"
#include "assocOpenDRIM_AssociatedProcessorCacheMemory.h"

int CPU_OpenDRIM_AssociatedProcessorCacheMemory_load(const CMPIBroker* broker, string& errorMessage);

int CPU_OpenDRIM_AssociatedProcessorCacheMemory_unload(string& errorMessage);

int CPU_OpenDRIM_AssociatedProcessorCacheMemory_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_AssociatedProcessorCacheMemory>& instances, const char** properties, string& errorMessage, const string& discriminant);

int CPU_OpenDRIM_AssociatedProcessorCacheMemory_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_AssociatedProcessorCacheMemory& instance, const char** properties, string& errorMessage);

int CPU_OpenDRIM_AssociatedProcessorCacheMemory_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AssociatedProcessorCacheMemory& newInstance, const OpenDRIM_AssociatedProcessorCacheMemory& oldInstance, const char** properties, string& errorMessage);

int CPU_OpenDRIM_AssociatedProcessorCacheMemory_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AssociatedProcessorCacheMemory& instance, string& errorMessage);

int CPU_OpenDRIM_AssociatedProcessorCacheMemory_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AssociatedProcessorCacheMemory& instance, string& errorMessage);

int CPU_OpenDRIM_AssociatedProcessorCacheMemory_associatorAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const char** properties, vector<Instance>& Dependent_associatedInstances, string& errorMessage, const string& discriminant);

int CPU_OpenDRIM_AssociatedProcessorCacheMemory_associatorDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const char** properties, vector<Instance>& Antecedent_associatedInstances, string& errorMessage, const string& discriminant);

int CPU_OpenDRIM_AssociatedProcessorCacheMemory_referenceAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const vector<Instance>& Dependent_instances, vector<OpenDRIM_AssociatedProcessorCacheMemory>& OpenDRIM_AssociatedProcessorCacheMemory_instances, const char** properties, string& errorMessage, const string& discriminant);

int CPU_OpenDRIM_AssociatedProcessorCacheMemory_referenceDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const vector<Instance>& Antecedent_instances, vector<OpenDRIM_AssociatedProcessorCacheMemory>& OpenDRIM_AssociatedProcessorCacheMemory_instances, const char** properties, string& errorMessage, const string& discriminant);

int CPU_OpenDRIM_AssociatedProcessorCacheMemory_populate(OpenDRIM_AssociatedProcessorCacheMemory& instance, string& errorMessage);

#endif /*OPENDRIM_ASSOCIATEDPROCESSORCACHEMEMORYACCESS_H_*/
