/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENRIJN_DRAWING_POINT_H_
#define _OPENRIJN_DRAWING_POINT_H_

namespace OpenRijn {
  /**
   * @ingroup OpenRijn
   *
   * Represent the information used to draw.
   */
  struct DrawingPoint {
    DrawingPoint() : x(0), y(0), t(0), angle(0)
    {
    }
    DrawingPoint(float _x, float _y, float _t, float _angle) : x(_x), y(_y), t(_t), angle(_angle)
    {
    }
    float x; ///< x-coordinate
    float y; ///< y-coordinate
    float t; ///< time
    float angle; ///< angle on the point
  };
}

#endif
