###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_opera_detection_win_900036.nasl 136 2008-08-21 16:54:55Z aug $
#
# Opera Version Detection for Windows
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 SecPod, http://www.secpod.com
#
# Modified to detect Beta Versions
#  - Sharath S <sharaths@secpod.com> On 2009-09-03
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

if(description)
{
  script_id(900036);
  script_version("$Revision: 1.2 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Opera Version Detection for Windows");
  desc = "
  Overview : This script finds the Opera Web browser installed version on
  windows through the Opera.exe file and saves the version in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set file version of Opera in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

function OperaGetVer(ofile)
{
  oshare = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:ofile);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:ofile);
  ver = GetVer(file:file, share:oshare);
  return ver;
}

function OperaSet(operaVersion)
{
  set_kb_item(name:"Opera/Build/Win/Ver", value:operaVersion);
  ver = eregmatch(pattern:"^([0-9]+\.[0-9]+)", string:operaVersion);
  if(ver[1] != NULL){
    set_kb_item(name:"Opera/Win/Version", value:ver[1]);
    security_note(data:"Opera browser version " + ver[1] +
                       " was detected on the host");
  }
}

if(!get_kb_item("SMB/WindowsVersion"))
{
  exit(0);
}

operaflag = 1;
key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:key)){
    exit(0);
}

foreach item (registry_enum_keys(key:key))
{
  operaName = registry_get_sz(key:key + item, item:"DisplayName");
  if("Opera" >< operaName)
  {
    operaPath = registry_get_sz(key:key + item, item:"InstallLocation");
    if(!isnull(operaPath))
    {
      operaFile = operaPath + "\opera.exe";
      operaVer = OperaGetVer(ofile:operaFile);

      if(operaVer)
      {
        OperaSet(operaVersion:operaVer);
        operaflag = 0;
      }
    }
    else
    {
      operaPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows" +
                                      "\CurrentVersion", item:"ProgramFilesDir");
      if(operaPath)
      {
        operaFile = operaPath + "\Opera\opera.exe";
        operaVer = OperaGetVer(ofile:operaFile);

        if(operaVer)
        {
          OperaSet(operaVersion:operaVer);
          operaflag = 0;
        }
      }
    }
  }
}

if(operaflag)
{
  operaPath = registry_get_sz(key:"SOFTWARE\Netscape\Netscape Navigator"+
              "\5.0, Opera\Main", item:"Install Directory");
  operaFile = operaPath + "\Opera.exe";
  if(operaPath)
  {
    operaVer = OperaGetVer(ofile:operaFile);
    if(operaVer){
      OperaSet(operaVersion:operaVer);
    }
  }
}
