###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_wordpress_detect_900182.nasl 740 2008-12-24 15:54:24Z dec $
#
# WordPress Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2008 SecPod, http://www.secpod.com
#
# Modified to Detect Versions, When it is Under Root folder
#  - By Sharath S <sharaths@secpod.com> On 2009-08-18
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900182);
  script_version("$Revision: 1.2 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("WordPress Version Detection");
  desc = "

  Overview : This script detects the installed version of WordPress/WordPress-Mu
  and sets the result in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set version of WordPress/WordPress-Mu in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 SecPod");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

wpPort = get_kb_item("Services/www");
if(!wpPort){
  wpPort = 80;
}

if(get_port_state(wpPort))
{
  foreach dir (make_list("/blog", "/wordpress", "/wordpress-mu", cgi_dirs()))
  {
    sndReq = http_get(item:string(dir, "/"), port:wpPort);
    rcvRes = http_send_recv(port:wpPort, data:sndReq);

    if(!egrep(pattern:"WordPress", string:rcvRes))
    {
      sndReq = http_get(item:string(dir, "/index.php"), port:wpPort);
      rcvRes = http_send_recv(port:wpPort, data:sndReq);
    }

    if(rcvRes != NULL && rcvRes =~ "</html>")
    {
      wpName = egrep(pattern:"WordPress", string:rcvRes);
      wpmuName = egrep(pattern:"WordPress Mu", string:rcvRes);

      if(wpName && !wpmuName)
      {
        wpVer = eregmatch(pattern:"WordPress ([0-9]\.[0-9.]+)", string:rcvRes);

        if(wpVer[1] != NULL)
        {
          set_kb_item(name:"www/" + wpPort + "/WordPress",
                      value:wpVer[1] + " under " + dir);
          security_note(data:"WordPress version " + wpVer[1] + " running at " +
                             "location " + dir + " was detected on the host");
        }
      }

      if(wpmuName)
      {
        wpmuVer = eregmatch(pattern:"WordPress ([0-9]\.[0-9.]+)", string:rcvRes);

        if(wpmuVer[1] != NULL)
        {
          set_kb_item(name:"www/" + wpPort + "/WordPress-Mu",
                      value:wpmuVer[1] + " under " + dir);
          security_note(data:"WordPress-Mu version " + wpmuVer[1] +
                             " running at location " + dir +
                             " was detected on the host");
        }
      }
    }
  }
}
