#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-04-06
# _preinstall-ubuntu.sh

### P A R A M S

package="$1"

### I N C L U D E

. ./_include.sh

### H E L P E R S

function debdeps()
{
	dpkg --info $1 | grep 'Depends:' | sed 's/Depends://' | sed 's/([^)]*)//g' | sed 's/, / /g'
}

### S T A R T

repositories=`grep -v "^#" /etc/apt/sources.list | grep -v "^$"`
if echo "${repositories}" | grep 'universe';then
	echo "apt has universe repository"
else
echo "WARNING"
echo "It is necessary to add the universe repository as an install source."
echo "Use Synaptics or uncomment the following line (or the like) in"
echo "/etc/apt/sources.list :"
echo "deb http://archive.ubuntu.com/ubuntu breezy universe main restricted"
exit 1
fi

echo "+UBUNTU PACKAGES"
packages=`debdeps "${package}"`
for p in ${packages}; do
	echo -n "+${p}"
	if ! ${PACKAGETEST} ${p} > /dev/null 2> /dev/null; then
		echo
		${PACKAGEINSTALL} -y ${p}
	else
		echo " OK"
	fi
done
