/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : SnapDlg.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/02/20
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
//#include <math.h>
#include "intl.h"

//#include "culcfunc.h"
#define _SNAPDLG_
#include "SnapDlg.h"





/* -------------------------------------------------------------------
 * CANCEL
 */
void snap_dlg_cancel_pushed(GtkWidget *widget, SNAP_DLG *snap_dlg)
{
	snap_dlg->value = 0;
}



/* 
 *	  図形要素	 1 : 点
 *				 2 : 線
 *				 4 : 円弧
 *				 8 : 円
 *				15 : 全図形
 *	
 *	  寸法図形	16 : 始点・終点
 *				32 : 四半点
 *				64 : 中心点
 *			   128 : 任意点
 *			   256 : 寸法図形
 *			   512 : ポリライン
 *			  1024 : ブロック
 *			  2048 : 楕円
 *			  
 */



int snap_mode_set(GtkWidget *check_button, SNAP_DLG *snap_dlg, gint frag)
{
	/* check button */
	/* check_on */
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_button)) == TRUE) {
		if ( (snap_dlg->snap & frag) != frag ) {
			snap_dlg->snap = snap_dlg->snap + frag;
		}
	}
	/* check_off */
	else {
		if ( (snap_dlg->snap & frag) == frag ) {
			snap_dlg->snap = snap_dlg->snap - frag;
		}
	}
	return 1;
}



/* -------------------------------------------------------------------
 * CHAIN
 */
void snap_dlg_chain_pushed(GtkWidget *widget, SNAP_DLG *snap_dlg)
{
	snap_dlg->value = 2;
}

/* -------------------------------------------------------------------
 * CHAIN2
 */
void snap_dlg_chain2_pushed(GtkWidget *widget, SNAP_DLG *snap_dlg)
{
	snap_dlg->value = 4;
}

/* -------------------------------------------------------------------
 * COLOR
 */
void snap_dlg_color_pushed(GtkWidget *widget, SNAP_DLG *snap_dlg)
{
	snap_dlg->value = 8;
}



/* -------------------------------------------------------------------
 * OK
 */
void snap_dlg_ok_pushed(GtkWidget *widget, SNAP_DLG *snap_dlg)
{
	/* POINT check button [ 1 ]*/
	snap_mode_set(snap_dlg->point_check_button, snap_dlg, 1);

	/* LINE check button [ 2 ]*/
	snap_mode_set(snap_dlg->line_check_button, snap_dlg, 2);

	/* ARC check button [ 4 ]*/
	snap_mode_set(snap_dlg->arc_check_button, snap_dlg, 4);

	/* CIRCLE check button [ 8 ]*/
	snap_mode_set(snap_dlg->circle_check_button, snap_dlg, 8);

	/* DIMENSION check button [ 256 ]*/
	snap_mode_set(snap_dlg->dimension_check_button, snap_dlg, 256);

	/* POLYLINE check button [ 512 ]*/
	snap_mode_set(snap_dlg->polyline_check_button, snap_dlg, 512);

	/* BLOCK check button [ 1024 ]*/
//	snap_mode_set(snap_dlg->block_check_button, snap_dlg, 1024);

	/* ELLIPSE check button [ 2048 ]*/
	snap_mode_set(snap_dlg->ellipse_check_button, snap_dlg, 2048);


	/* START & END POINT check button [ 16 ]*/
	snap_mode_set(snap_dlg->start_end_check_button, snap_dlg, 16);

	/* HALF 4 POINT check button [ 32 ]*/
	snap_mode_set(snap_dlg->half_4_point_check_button, snap_dlg, 32);

	/* CENTER POINT check button [ 64 ]*/
	snap_mode_set(snap_dlg->center_check_button, snap_dlg, 64);

	/* ANY POINT check button [ 128 ]*/
	snap_mode_set(snap_dlg->any_check_button, snap_dlg, 128);

	snap_dlg->value = 1;
}





/* -------------------------------------------------------------------
 * キーが押されたイベント
 * key_press_event
 */
static gint snap_dlg_key_press_event(GtkWidget *widget, GdkEventKey *event, SNAP_DLG *snap_dlg)
{
//	g_print("sagcad.c : snap_dlg_key_press_event  state:%d  keyval:0x%x  length:%d  string:%s\n", 
//			event->state, event->keyval, event->length, event->string);
	if (event->keyval == 0xff0d || event->keyval == 0xff8d) {		/* Enter */
		snap_dlg_ok_pushed(widget, snap_dlg);
		gtk_main_quit();
	}
	return FALSE; 
}





/* -------------------------------------------------------------------
 * スナップ設定
 * 
 */
gint SnapDialog(SNAP_DLG *snap_dlg)
{
//	GtkWidget *dialog;
		GtkWidget *main_vbox;
			GtkWidget *hbox;
				GtkWidget *base_vbox;
//					GtkWidget *point_check_button;
//					GtkWidget *line_check_button;
//					GtkWidget *arc_check_button;
//					GtkWidget *circle_check_button;
				GtkWidget *etc_vbox;
//					GtkWidget *start_end_check_button;
//					GtkWidget *half_4_point_check_button;
//					GtkWidget *center_check_button;
//					GtkWidget *any_check_button;
				GtkWidget *option_vbox;
//					GtkWidget *polyline_check_button;
//					GtkWidget *dimension_check_button;
//					GtkWidget *block_check_button;
//					GtkWidget *ellipse_check_button;
			GtkWidget *separator;
			GtkWidget *action_hbox;
				GtkWidget *chain_buttun;
				GtkWidget *chain2_buttun;
				GtkWidget *color_buttun;
				GtkWidget *cancel_buttun;
				GtkWidget *ok_buttun;


	/* ダイアログ(snap_dlg->dialog)生成 */
	snap_dlg->dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_position(GTK_WINDOW(snap_dlg->dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(snap_dlg->dialog), _("Snap Setting") );
	g_signal_connect( G_OBJECT(snap_dlg->dialog), "key_press_event",
						G_CALLBACK(snap_dlg_key_press_event), snap_dlg);



		/* ダイアログの中にまず、パッキングボックス(main_vbox)を作成 */
		main_vbox = gtk_vbox_new(0, 5);
		gtk_container_add(GTK_CONTAINER(snap_dlg->dialog), main_vbox);
		gtk_container_set_border_width(GTK_CONTAINER(snap_dlg->dialog), 5);
		gtk_widget_show(main_vbox);

			/* -----------------------------------------------------
			 * パッキングボックス(main_vbox) に入れる
			 * パッキングボックス(hbox & action_hbox) を作成し
			 * 格納する
			 */
			/* パッキングボックス(hbox) */
			hbox = gtk_hbox_new(FALSE, 2);
			gtk_box_pack_start( (GtkBox *)GTK_BOX(main_vbox), 
								hbox, TRUE, TRUE, 0);
			gtk_widget_show(hbox);

				/* -----------------------------------------------------
				 * パッキングボックス(hbox) に入れる
				 * パッキングボックス(label_vbox & entry_vbox) を作成し
				 * 格納する
				 */
				/* パッキングボックス(base_vbox) */
				base_vbox = gtk_vbox_new(FALSE, 2);
				gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox), base_vbox, TRUE, TRUE, 0);
				gtk_widget_show(base_vbox);

					/* -----------------------------------------------------
					 * パッキングボックス(base_vbox) に入れる
					 * チェックボタン
					 * snap_dlg->point_check_button
					 * snap_dlg->line_check_button
					 * snap_dlg->arc_check_button
					 * snap_dlg->circle_check_button
					 * を作成し、格納する
					 */
					/* 点 */
					snap_dlg->point_check_button = gtk_check_button_new_with_label( _("Point") );
					gtk_widget_set_size_request(snap_dlg->point_check_button, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(base_vbox), snap_dlg->point_check_button, TRUE, TRUE, 0);
					gtk_widget_show(snap_dlg->point_check_button);
					/* 有効か無効の設定 */
					if ((snap_dlg->mask & 1) != 1) {
						gtk_widget_set_sensitive(snap_dlg->point_check_button, FALSE);
					}
					/* 初期設定 */
					else if ((snap_dlg->snap & 1) == 1) {
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(snap_dlg->point_check_button), TRUE);
					}


					/* 線 */
					snap_dlg->line_check_button = gtk_check_button_new_with_label( _("Line") );
					gtk_widget_set_size_request(snap_dlg->line_check_button, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(base_vbox), snap_dlg->line_check_button, TRUE, TRUE, 0);
					gtk_widget_show(snap_dlg->line_check_button);
					/* 有効か無効の設定 */
					if ((snap_dlg->mask & 2) != 2) {
						gtk_widget_set_sensitive(snap_dlg->line_check_button, FALSE);
					}
					/* 初期設定 */
					else if ((snap_dlg->snap & 2) == 2) {
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(snap_dlg->line_check_button), TRUE);
					}


					/* 円弧 */
					snap_dlg->arc_check_button = gtk_check_button_new_with_label( _("Arc") );
					gtk_widget_set_size_request(snap_dlg->arc_check_button, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(base_vbox), snap_dlg->arc_check_button, TRUE, TRUE, 0);
					gtk_widget_show(snap_dlg->arc_check_button);
					/* 有効か無効の設定 */
					if ((snap_dlg->mask & 4) != 4) {
						gtk_widget_set_sensitive(snap_dlg->arc_check_button, FALSE);
					}
					/* 初期設定 */
					else if ((snap_dlg->snap & 4) == 4) {
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(snap_dlg->arc_check_button), TRUE);
					}


					/* 円 */
					snap_dlg->circle_check_button = gtk_check_button_new_with_label( _("Circle") );
					gtk_widget_set_size_request(snap_dlg->circle_check_button, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(base_vbox), snap_dlg->circle_check_button, TRUE, TRUE, 0);
					gtk_widget_show(snap_dlg->circle_check_button);
					/* 有効か無効の設定 */
					if ((snap_dlg->mask & 8) != 8) {
						gtk_widget_set_sensitive(snap_dlg->circle_check_button, FALSE);
					}
					/* 初期設定 */
					else if ((snap_dlg->snap & 8) == 8) {
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(snap_dlg->circle_check_button), TRUE);
					}

/*
ウィジェットを無効（あるいは有効）にするには、
 gtk_widget_set_sensitive()関数を使って下さい。
この関数の最初のパラメータは、そのウィジェットへのポインタです。
二番目のパラメータは論理値で、TRUE ならそのウィジェットは有効になります。
*/




				/* パッキングボックス(etc_vbox) */
				etc_vbox = gtk_vbox_new(FALSE, 2);
				gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox), etc_vbox, TRUE, TRUE, 0);
				gtk_widget_show(etc_vbox);

					/* -----------------------------------------------------
					 * パッキングボックス(etc_vbox) に入れる
					 * チェックボタン
					 * snap_dlg->start_end_check_button
					 * snap_dlg->half_4_point_check_button
					 * snap_dlg->center_check_button
					 * snap_dlg->any_check_button
					 * を作成し、格納する
					 */
					/* 端点 */
					snap_dlg->start_end_check_button = gtk_check_button_new_with_label( _("End Point") );
					gtk_widget_set_size_request(snap_dlg->start_end_check_button, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(etc_vbox), snap_dlg->start_end_check_button, TRUE, TRUE, 0);
					gtk_widget_show(snap_dlg->start_end_check_button);
					/* 有効か無効の設定 */
					if ((snap_dlg->mask & 16) != 16) {
						gtk_widget_set_sensitive(snap_dlg->start_end_check_button, FALSE);
					}
					/* 初期設定 */
					else if ((snap_dlg->snap & 16) == 16) {
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(snap_dlg->start_end_check_button), TRUE);
					}


					/* 四半点 */
					snap_dlg->half_4_point_check_button = gtk_check_button_new_with_label( _("4 half points") );
					gtk_widget_set_size_request(snap_dlg->half_4_point_check_button, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(etc_vbox), snap_dlg->half_4_point_check_button, TRUE, TRUE, 0);
					gtk_widget_show(snap_dlg->half_4_point_check_button);
					/* 有効か無効の設定 */
					if ((snap_dlg->mask & 32) != 32) {
						gtk_widget_set_sensitive(snap_dlg->half_4_point_check_button, FALSE);
					}
					/* 初期設定 */
					else if ((snap_dlg->snap & 32) == 32) {
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(snap_dlg->half_4_point_check_button), TRUE);
					}


					/* 中心点 */
					snap_dlg->center_check_button = gtk_check_button_new_with_label( _("Central Point") );
					gtk_widget_set_size_request(snap_dlg->center_check_button, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(etc_vbox), snap_dlg->center_check_button, TRUE, TRUE, 0);
					gtk_widget_show(snap_dlg->center_check_button);
					/* 有効か無効の設定 */
					if ((snap_dlg->mask & 64) != 64) {
						gtk_widget_set_sensitive(snap_dlg->center_check_button, FALSE);
					}
					/* 初期設定 */
					else if ((snap_dlg->snap & 64) == 64) {
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(snap_dlg->center_check_button), TRUE);
					}


					/* 任意点 */
					snap_dlg->any_check_button = gtk_check_button_new_with_label( _("Optional Point") );
					gtk_widget_set_size_request(snap_dlg->any_check_button, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(etc_vbox), snap_dlg->any_check_button, TRUE, TRUE, 0);
					gtk_widget_show(snap_dlg->any_check_button);
					/* 有効か無効の設定 */
					if ((snap_dlg->mask & 128) != 128) {
						gtk_widget_set_sensitive(snap_dlg->any_check_button, FALSE);
					}
					/* 初期設定 */
					else if ((snap_dlg->snap & 128) == 128) {
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(snap_dlg->any_check_button), TRUE);
					}



				/* パッキングボックス(option_vbox) */
				option_vbox = gtk_vbox_new(FALSE, 2);
				gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox), option_vbox, TRUE, TRUE, 0);
				gtk_widget_show(option_vbox);

					/* -----------------------------------------------------
					 * パッキングボックス(option_vbox) に入れる
					 * チェックボタン
					 * snap_dlg->polyline_check_button
					 * snap_dlg->dimension_check_button
					 * snap_dlg->block_check_button
					 * snap_dlg->ellipse_check_button
					 * を作成し、格納する
					 */
					/* -----------------------------------------------
					 * 曲線
					 */
					snap_dlg->polyline_check_button = gtk_check_button_new_with_label( _("Curve") );
					gtk_widget_set_size_request(snap_dlg->polyline_check_button, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(option_vbox), snap_dlg->polyline_check_button, TRUE, TRUE, 0);
					gtk_widget_show(snap_dlg->polyline_check_button);
					/* 有効か無効の設定 */
					if ((snap_dlg->mask & 512) != 512) {
						gtk_widget_set_sensitive(snap_dlg->polyline_check_button, FALSE);
					}
					/* 初期設定 */
					else if ((snap_dlg->snap & 512) == 512) {
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(snap_dlg->polyline_check_button), TRUE);
					}


					/* -----------------------------------------------
					 * 寸法 
					 */
					snap_dlg->dimension_check_button = gtk_check_button_new_with_label( _("Dimension") );
					gtk_widget_set_size_request(snap_dlg->dimension_check_button, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(option_vbox), snap_dlg->dimension_check_button, TRUE, TRUE, 0);
					gtk_widget_show(snap_dlg->dimension_check_button);
					/* 有効か無効の設定 */
					if ((snap_dlg->mask & 256) != 256) {
						gtk_widget_set_sensitive(snap_dlg->dimension_check_button, FALSE);
					}
					/* 初期設定 */
					else if ((snap_dlg->snap & 256) == 256) {
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(snap_dlg->dimension_check_button), TRUE);
					}


					/* -----------------------------------------------
					 * ブロック 
					 */
					snap_dlg->block_check_button = gtk_check_button_new_with_label( _("Block") );
					gtk_widget_set_size_request(snap_dlg->block_check_button, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(option_vbox), snap_dlg->block_check_button, TRUE, TRUE, 0);
					gtk_widget_show(snap_dlg->block_check_button);
					/* 有効か無効の設定 */
					if ((snap_dlg->mask & 1024) != 1024) {
						gtk_widget_set_sensitive(snap_dlg->block_check_button, FALSE);
					}
					/* 初期設定 */
					else if ((snap_dlg->snap & 1024) == 1024) {
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(snap_dlg->block_check_button), TRUE);
					}


					/* -----------------------------------------------
					 * 楕円 
					 */
					snap_dlg->ellipse_check_button = gtk_check_button_new_with_label( _("Ellipse") );
					gtk_widget_set_size_request(snap_dlg->ellipse_check_button, 100, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(option_vbox), snap_dlg->ellipse_check_button, TRUE, TRUE, 0);
					gtk_widget_show(snap_dlg->ellipse_check_button);
					/* 有効か無効の設定 */
					if ((snap_dlg->mask & 2048) != 2048) {
						gtk_widget_set_sensitive(snap_dlg->ellipse_check_button, FALSE);
					}
					/* 初期設定 */
					else if ((snap_dlg->snap & 2048) == 2048) {
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(snap_dlg->ellipse_check_button), TRUE);
					}



			/* セパレーター(separator) */
			separator = gtk_hseparator_new();
			gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
			gtk_widget_show(separator);



			/* パッキングボックス(action_hbox) */
			action_hbox = gtk_hbox_new(FALSE, 2);
			gtk_box_pack_start( GTK_BOX(main_vbox), 
								action_hbox, TRUE, TRUE, 0);
			gtk_widget_show(action_hbox);

				/* -----------------------------------------------------
				 * パッキングボックス(action_hbox) に入れる
				 * ボタン(cancel_buttun & ok_buttun) を作成し
				 * 格納する
				 */
				if (snap_dlg->value == 16) {
					/* chain ボタンの生成 */
					chain_buttun = gtk_button_new_with_label("Chain");
//					gtk_widget_set_size_request(chain_buttun, 80, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), chain_buttun, TRUE, TRUE, 2);
					g_signal_connect(G_OBJECT(chain_buttun), "clicked", 
									   G_CALLBACK(snap_dlg_ok_pushed), snap_dlg);
					g_signal_connect(G_OBJECT(chain_buttun), "clicked", 
									   G_CALLBACK(snap_dlg_chain_pushed), snap_dlg);
					g_signal_connect(G_OBJECT(chain_buttun), "clicked", G_CALLBACK(gtk_main_quit), NULL);
					gtk_widget_show(chain_buttun);

					/* chain2 ボタンの生成 */
					chain2_buttun = gtk_button_new_with_label("Chain One Way");
//					gtk_widget_set_size_request(chain2_buttun, 80, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), chain2_buttun, TRUE, TRUE, 2);
					g_signal_connect(G_OBJECT(chain2_buttun), "clicked", 
									   G_CALLBACK(snap_dlg_ok_pushed), snap_dlg);
					g_signal_connect(G_OBJECT(chain2_buttun), "clicked", 
									   G_CALLBACK(snap_dlg_chain2_pushed), snap_dlg);
					g_signal_connect(G_OBJECT(chain2_buttun), "clicked", G_CALLBACK(gtk_main_quit), NULL);
					gtk_widget_show(chain2_buttun);

					/* color ボタンの生成 */
					color_buttun = gtk_button_new_with_label("Color");
//					gtk_widget_set_size_request(color_buttun, 80, 20);
					gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), color_buttun, TRUE, TRUE, 2);
					g_signal_connect(G_OBJECT(color_buttun), "clicked", 
									   G_CALLBACK(snap_dlg_ok_pushed), snap_dlg);
					g_signal_connect(G_OBJECT(color_buttun), "clicked", 
									   G_CALLBACK(snap_dlg_color_pushed), snap_dlg);
					g_signal_connect(G_OBJECT(color_buttun), "clicked", G_CALLBACK(gtk_main_quit), NULL);
					gtk_widget_show(color_buttun);
				}


				/* CANCELボタンの生成 */
				cancel_buttun = gtk_button_new_with_label("CANCEL");
//				gtk_widget_set_size_request(cancel_buttun, 80, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), cancel_buttun, TRUE, TRUE, 2);
				g_signal_connect( G_OBJECT(cancel_buttun), "clicked", G_CALLBACK(snap_dlg_cancel_pushed), snap_dlg);
				g_signal_connect( G_OBJECT(cancel_buttun), "clicked", G_CALLBACK(gtk_main_quit), NULL);
				gtk_widget_show(cancel_buttun);

				/* OKボタンの生成 */
				ok_buttun = gtk_button_new_with_label("OK");
//				gtk_widget_set_size_request(ok_buttun, 80, 20);
				gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), ok_buttun, TRUE, TRUE, 2);
				g_signal_connect(G_OBJECT(ok_buttun), "clicked", G_CALLBACK(snap_dlg_ok_pushed), snap_dlg);
				g_signal_connect(G_OBJECT(ok_buttun), "clicked", G_CALLBACK(gtk_main_quit), NULL);
			//	  GTK_WIDGET_SET_FLAGS(ok_buttun, GTK_CAN_DEFAULT);
			//	  gtk_widget_grab_default(ok_buttun);
				gtk_widget_show(ok_buttun);



	/* ダイアログを最前面に表示する */
	gtk_window_set_modal(GTK_WINDOW(snap_dlg->dialog), TRUE);
	/* メインウィンドウを操作できないように設定 */
	gtk_window_set_transient_for(GTK_WINDOW(snap_dlg->dialog), GTK_WINDOW(snap_dlg->parent));


	/* ダイアログを可視状態へ */
	gtk_widget_show(snap_dlg->dialog);
	/* メインイベントループ */
	gtk_main();
	gtk_widget_destroy(snap_dlg->dialog);
	return 0; 
}





/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : SnapDlg.c
 * ====================================================================
 */
