/* Public domain. */

#include "diuintbunch.h"
#include "list1.h"

static unsigned int list1_insertthere (register list1_ref t, register unsigned int j, register unsigned int k)
{
  register diuint_ref s = t->x.x.s ;
  register unsigned int i = diuintbunch_new(&t->x) ;
  if (!i--) return 0 ;
  s[i].right = k ;
  s[i].left = s[j].left ;
  s[j].left = i ;
  return i ;
}

unsigned int list1_push (list1_ref t, unsigned int k)
{
  return list1_insertthere(t, 0, k) ;
}

unsigned int list1_insert (list1_ref t, unsigned int k)
{
  register unsigned int j = 0 ;
  for (;;)
  {
    register unsigned int i = t->x.x.s[j].left ;
    if (!i || ((*t->cmp)(k, t->x.x.s[i].right) <= 0)) break ;
    j = i ;
  }
  return list1_insertthere(t, j, k) ;
}
