3.4 Enveloped Samples

# Enveloped Samples

Es ist auch möglich, die *Dauer* und *Amplitude* eines Sample mit einer 
ADSR-Hüllkurve zu verändern. Das funktioniert jedoch ein wenig anders 
als die ADSR-Hüllkurven bei den Synths. Mit Sample-Hüllkurven kannst Du
die Amplitude und die Dauer eines Samples nur verringern - niemals
vergrößern. Das Sample wird entweder stoppen, wenn seine normale 
Laufzeit vorbei ist, oder wenn die Hüllkurve das Sample begrenzt - je 
nachdem welche kürzer ist. Mit einem sehr langen `release` kannst Du
ein Sample also nicht über seine normale Laufzeit hinaus verlängern.

## Amen-Hüllkuven

Kommen wir zu unserem treuen Freund zurück, dem Amen-Break:

```
sample :loop_amen
```

Ohne Parameter hören wir das Sample in seiner gesamten Länge und mit 
voller Lautstärke. Mit dem `attack`-Parameter können wir das
Sample einblenden lassen:

```
sample :loop_amen, attack: 1
```

Wähle für eine kürzere Blende einen kürzeren Attack-Wert:

```
sample :loop_amen, attack: 0.3
```

## Auto-Sustain

Beim *Sustain*-Wert unterscheidet sich das Verhalten einer 
ADSR-Hüllkuve. Bei der Hüllkurve für Standard-Synths steht der Sustain 
normalerweise auf 0 - außer Du setzt den Wert ausdrücklich. Bei Samples 
wird der Sustain-Wert auf einen *automagical* Wert gesetzt - nämlich 
die Zeit, die es braucht, bis das gesamte Sample abgelaufen ist. Darum 
hören wir das Sample komplett, wenn wir keine Default-Werte übergeben. 
Wenn die Werte für Attack, Decay, Sustain und Release alle 0 wären, 
würden wir keinen Pieps hören. Deshalb berechnet Sonic Pi zunächst, 
wie lange das Sample von sich aus dauert, zieht etwaige Dauern für 
Attack, Decay und Release davon ab und setzt die restliche Zeit als 
Sustain-Wert. Wenn die Werte von Attack, Decay und Release 
zusammengenommen länger dauern als das gesamte Sample, wird der 
Sustain-Wert einfach auf 0 gesetzt.

## Ausblenden

Um das auszuprobieren, schauen wir uns den Amen-Break genauer an. Wir 
fragen Sonic Pi, wie lang das Sample ist:

```
print sample_duration :loop_amen
```

Es wird `1.753310657596372` ausgeben; das ist die Länge des Sample in 
Sekunden. Wir runden das einmal bequemerweise auf `1.75` ab. Wenn wir 
nun den Release-Wert auf `0.75` setzen, wird etwas erstaunliches 
passieren:

```
sample :loop_amen, release: 0.75
```

Die erste Sekunde des Sample wird mit voller Lautstärke gespielt, 
danach wird über eine Periode von 0.75 Sekunden ausgeblendet. Das ist 
der *Auto-Sustain* in Aktion. Standardmäßig berechnet Sonic Pi den
Release immer vom  Ende des Samples aus. Wenn unser Sample 10.75
Sekunden lang wäre, würden die ersten 10 Sekunden in voller Lautstärke
gespielt bevor dann eine Ausblende über 0.75 Sekunden erfolgt.

Zur Erinnerung: Standardmäßig blendet `release:` das Ende des Sample 
aus.

## Ein- und Ausblenden

Wir können `attack:` und `release:` zusammen mit Auto-Sustain nutzen, 
um über die Laufzeit des Sample ein- und auszublenden:

```
sample :loop_amen, attack: 0.75, release: 0.75
```

Da die Gesamtdauer des Sample 1.75s beträgt und unsere Attack- und 
Release-Phasen zusammen 1.5s ergeben, erhält der Sustain automatisch
den Wert 0.25s.

## Ausdrücklich angegebener Sustain

Wir können ohne weiteres das normales Synth-ADSR-Verhalten aktivieren, 
indem wir dem `sustain` den Wert 0 geben:

```
sample :loop_amen, sustain: 0, release: 0.75
```

Jetzt spielt unser Sample insgesamt nur 0.75 Sekunden. Mit dem 
Standardwert 0 für `attack:` und `decay:` springt das Sample direkt auf 
die volle Lautstärke, bleibt dort für 0s und fällt dann innerhalb der 
Release-Phase mit einer Dauer von 0.75s auf den Lautstärkenwert 0 ab.

## Perkussive Becken

Wir können dieses Verhalten gut dazu benutzen, um länger klingende 
Samples in kürzere, perkussivere Versionen zu verwandeln. Sieh Dir das 
Sample `:drum_cymbal_open` an:

```
sample :drum_cymbal_open
```

Man kann hören, wie das Becken eine Zeit lang ausklingt. Mit ein paar
kleinen Änderungen an der Hüllkurve klingt es perkussiver:

```
sample :drum_cymbal_open, attack: 0.01, sustain: 0, release: 0.1
```

Indem Du die Sustain-Dauer verlängerst, kannst Du es so klingen lassen, 
als ob das Becken erst angeschlagen und dann abgedämpft würde:

```
sample :drum_cymbal_open, attack: 0.01, sustain: 0.3, release: 0.1
```

Jetzt versuch einmal, Hüllkuven über Samples zu legen. Verändere auch 
die Samplerate; damit kannst Du sehr interessante Ergebnisse erzielen.
