/* ====================================================================
 * Copyright (c) 2008-2009  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#include "PreserveSwitchStatusTest.h"

// cppunit
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>

// sc
#include "subcommander/WcViewModel.h"
#include "subcommander/commands/StatusParam.h"
#include "sublib/TargetRepository.h"
#include "svn/WcStatus.h"
#include "svn/WcEntry.h"


class TestWcEntry : public svn::WcEntry
{
public:
  TestWcEntry()
  {
    _kind = svn::Node_Dir;
  }
};

class TestWcStatus : public svn::WcStatus
{
public:
  TestWcStatus( const sc::String& name, bool switched )
  {
    _name     = name;
    _switched = switched;
    _entry    = new TestWcEntry();
  }
};

void PreserveSwitchStatusTest::setUp()
{
  TargetRepository::setup();
  _viewModel = new WcViewModel( NULL, NULL );

  _paramParent = new StatusParam( sc::String("parent"),
    new svn::Revision(svn::Revision_Unspecified), true,true,false,true,false);

  // parent with switched child
  svn::WcStatuss& statusParent = _paramParent->getStatuss();
  statusParent.push_back( svn::WcStatusPtr(new TestWcStatus(sc::String("parent"), false)) );
  statusParent.push_back( svn::WcStatusPtr(new TestWcStatus(sc::String("parent/switched"), true)) );
  
  // status on switched child doesn't report folder as switched
  _paramSwitch = new StatusParam( sc::String("parent/switched"),
    new svn::Revision(svn::Revision_Unspecified), true,true,false,true,false);

  svn::WcStatuss& statusSwitch = _paramSwitch->getStatuss();
  statusSwitch.push_back( svn::WcStatusPtr(new TestWcStatus(sc::String("parent/switched"), false)) );
}

void PreserveSwitchStatusTest::tearDown()
{
  delete _paramSwitch;
  delete _paramParent;
  delete _viewModel;
  TargetRepository::teardown();
}

void PreserveSwitchStatusTest::addSwitchedFolder()
{
  _viewModel->statusResult( _paramParent, NULL );
  _viewModel->statusResult( _paramSwitch, NULL );
  
  svn::WcStatuss statuss;
  _viewModel->getStatus( sc::String("parent/switched"), statuss );
  
  CPPUNIT_ASSERT( statuss.size() == 1 );
  CPPUNIT_ASSERT( (*statuss.begin())->isSwitched() == true );
}
