/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _DIFFINFOMODEL_H
#define _DIFFINFOMODEL_H

// sc
#include "Conflict.h"
#include "DiffInfo.h"
class TextModel;

// boost
#include <boost/shared_ptr.hpp>

/**
 * Model class that holds the result information of a diff or merge.
 */
class DiffInfoModel
{
public:
  enum DiffModel
  {
    dmOriginal = 0,
    dmModified = 1,
    dmLatest   = 2,
    dmMerged   = 3,
    dmMax
  };

  virtual ~DiffInfoModel() {}

  virtual DiffInfos& getInfos() = 0;
  virtual TextModel* getModel( DiffModel dm ) = 0;

  virtual DiffInfo& getInfo( int numBlock ) = 0;
  virtual DiffInfo& getDiffInfo( int numDiff ) = 0;
  virtual const BlockInfo& getBlockInfo( int numBlock ) = 0;
  virtual const BlockInfo& getDiffBlockInfo( int numDiff ) = 0;

  virtual int getDiffCnt() = 0;
  virtual int getConflictCnt() = 0;
  virtual int getActiveDiff() = 0;

  // return the block number
  virtual int setActiveDiff( int num ) = 0;
  virtual int nextDiff() = 0;
  virtual int prevDiff() = 0;

  virtual bool hasNextDiff() = 0;
  virtual bool hasPrevDiff() = 0;
};

typedef boost::shared_ptr<DiffInfoModel>  DiffInfoModelPtr;

#endif // _DIFFINFOMODEL_H
