/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.nodes;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.piccolo2d.PNode;
import org.piccolo2d.util.PBounds;
import org.piccolo2d.util.PPaintContext;

public class PImage
extends PNode {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_IMAGE = "image";
    public static final int PROPERTY_CODE_IMAGE = 32768;
    private transient Image image;

    public PImage() {
    }

    public PImage(String fileName) {
        this(Toolkit.getDefaultToolkit().getImage(fileName));
    }

    public PImage(Image image) {
        this.setImage(image);
    }

    public PImage(URL url) {
        if (url != null) {
            this.setImage(Toolkit.getDefaultToolkit().getImage(url));
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(String fileName) {
        this.setImage(Toolkit.getDefaultToolkit().getImage(fileName));
    }

    public void setImage(Image newImage) {
        Image oldImage = this.image;
        this.image = newImage == null || newImage instanceof BufferedImage ? newImage : this.getLoadedImage(newImage);
        if (this.image != null) {
            this.setBounds(0.0, 0.0, this.getImage().getWidth(null), this.getImage().getHeight(null));
            this.invalidatePaint();
        }
        this.firePropertyChange(32768, PROPERTY_IMAGE, oldImage, this.image);
    }

    private Image getLoadedImage(Image newImage) {
        ImageIcon imageLoader = new ImageIcon(newImage);
        switch (imageLoader.getImageLoadStatus()) {
            case 1: 
            case 8: {
                return imageLoader.getImage();
            }
        }
        return null;
    }

    protected void paint(PPaintContext paintContext) {
        if (this.getImage() == null) {
            return;
        }
        double iw = this.image.getWidth(null);
        double ih = this.image.getHeight(null);
        PBounds b = this.getBoundsReference();
        Graphics2D g2 = paintContext.getGraphics();
        if (b.x != 0.0 || b.y != 0.0 || b.width != iw || b.height != ih) {
            g2.translate(b.x, b.y);
            g2.scale(b.width / iw, b.height / ih);
            g2.drawImage(this.image, 0, 0, null);
            g2.scale(iw / b.width, ih / b.height);
            g2.translate(-b.x, -b.y);
        } else {
            g2.drawImage(this.image, 0, 0, null);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        BufferedImage bufferedImage = PImage.toBufferedImage(this.image, false);
        if (bufferedImage != null) {
            ImageIO.write((RenderedImage)bufferedImage, "png", out);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.image = ImageIO.read(in);
    }

    public static BufferedImage toBufferedImage(Image image, boolean alwaysCreateCopy) {
        BufferedImage result;
        if (image == null) {
            return null;
        }
        if (!alwaysCreateCopy && image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        if (GraphicsEnvironment.isHeadless()) {
            result = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        } else {
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            result = graphicsConfiguration.createCompatibleImage(image.getWidth(null), image.getHeight(null));
        }
        Graphics2D g2 = result.createGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return result;
    }
}

