# axodraw2 package
# Matthew Bertucci 12/29/2021 for v2.1.1c

#include:color
#include:graphicx
#include:ifthen
#include:ifxetex
#include:keyval

#keyvals:\usepackage/axodraw2#c
v1compatible
canvasScaleIs1pt
canvasScaleIsObjectScale
canvasScaleIsUnitLength
PSTextScalesIndependently
PSTextScalesLikeGraphics
#endkeyvals

#ifOption:v1compatible
\B2Text
\B#S
\G2Text
\G#S
\C2Text
\C#S
#endif

\begin{axopicture}(x,y)#\pictureHighlight
\begin{axopicture}(x,y)(xoffset,yoffset)#\pictureHighlight
\end{axopicture}

\AxoGrid(x,y)(xsize,ysize)(xdivs,ydivs){color}{linewidth}

\Line(x1,y1)(x2,y2)
\Line[options%keyvals](x1,y1)(x2,y2)
\DoubleLine(x1,y1)(x2,y2){linesep}
\DoubleLine[options%keyvals](x1,y1)(x2,y2){linesep}
\DashLine(x1,y1)(x2,y2){dashsize}
\DashLine[options%keyvals](x1,y1)(x2,y2){dashsize}
\DashDoubleLine(x1,y1)(x2,y2){linesep}{dashsize}
\DashDoubleLine[options%keyvals](x1,y1)(x2,y2){linesep}{dashsize}

\Arc(x,y)(radius,start-angle,end-angle)
\Arc[options%keyvals](x,y)(radius,start-angle,end-angle)
\CArc(x,y)(radius,start-angle,end-angle)#*
\CArc[options%keyvals](x,y)(radius,start-angle,end-angle)#*
\DoubleArc(x,y)(radius,start-angle,end-angle){linesep}
\DoubleArc[options%keyvals](x,y)(radius,start-angle,end-angle){linesep}
\DoubleCArc(x,y)(radius,start-angle,end-angle){linesep}#*
\DoubleCArc[options%keyvals](x,y)(radius,start-angle,end-angle){linesep}#*
\DashArc(x,y)(radius,start-angle,end-angle){dashsize}
\DashArc[options%keyvals](x,y)(radius,start-angle,end-angle){dashsize}
\DashCArc(x,y)(radius,start-angle,end-angle){dashsize}#*
\DashCArc[options%keyvals](x,y)(radius,start-angle,end-angle){dashsize}#*
\DashDoubleArc(x,y)(radius,start-angle,end-angle){linesep}{dashsize}
\DashDoubleArc[options%keyvals](x,y)(radius,start-angle,end-angle){linesep}{dashsize}
\DashDoubleCArc(x,y)(radius,start-angle,end-angle){linesep}{dashsize}#*
\DashDoubleCArc[options%keyvals](x,y)(radius,start-angle,end-angle){linesep}{dashsize}#*

\Bezier(x1,y1)(x2,y2)(x3,y3)(x4,y4)
\Bezier[options%keyvals](x1,y1)(x2,y2)(x3,y3)(x4,y4)
\DoubleBezier(x1,y1)(x2,y2)(x3,y3)(x4,y4){linesep}
\DoubleBezier[options%keyvals](x1,y1)(x2,y2)(x3,y3)(x4,y4){linesep}
\DashBezier(x1,y1)(x2,y2)(x3,y3)(x4,y4){dashsize}
\DashBezier[options%keyvals](x1,y1)(x2,y2)(x3,y3)(x4,y4){dashsize}
\DashDoubleBezier(x1,y1)(x2,y2)(x3,y3)(x4,y4){linesep}{dashsize}
\DashDoubleBezier[options%keyvals](x1,y1)(x2,y2)(x3,y3)(x4,y4){linesep}{dashsize}

\Curve{%<(x1,y1)(x2,y2)...%>}
\DashCurve{%<(x1,y1)(x2,y2)...%>}{%<dashsize%>}

\Gluon(x1,y1)(x2,y2){amplitude}{number}
\Gluon[options%keyvals](x1,y1)(x2,y2){amplitude}{number}
\DoubleGluon(x1,y1)(x2,y2){amplitude}{number}{linesep}
\DoubleGluon[options%keyvals](x1,y1)(x2,y2){amplitude}{number}{linesep}
\DashGluon(x1,y1)(x2,y2){amplitude}{number}{dashsize}
\DashGluon[options%keyvals](x1,y1)(x2,y2){amplitude}{number}{dashsize}
\DashDoubleGluon(x1,y1)(x2,y2){amplitude}{number}{linesep}{dashsize}
\DashDoubleGluon[options%keyvals](x1,y1)(x2,y2){amplitude}{number}{linesep}{dashsize}

\GluonArc(x,y)(radius,start-angle,end-angle){amplitude}{number}
\GluonArc[options%keyvals](x,y)(radius,start-angle,end-angle){amplitude}{number}
\GlueArc(x,y)(radius,start-angle,end-angle){amplitude}{number}#*
\GlueArc[options%keyvals](x,y)(radius,start-angle,end-angle){amplitude}{number}#*
\GluonArcn(x,y)(radius,start-angle,end-angle){amplitude}{number}#*
\GluonArcn[options%keyvals](x,y)(radius,start-angle,end-angle){amplitude}{number}#*
\GlueArcn(x,y)(radius,start-angle,end-angle){amplitude}{number}#*
\GlueArcn[options%keyvals](x,y)(radius,start-angle,end-angle){amplitude}{number}#*
\DoubleGluonArc(x,y)(radius,start-angle,end-angle){amplitude}{number}{linesep}
\DoubleGluonArc[options%keyvals](x,y)(radius,start-angle,end-angle){amplitude}{number}{linesep}
\DoubleGlueArc(x,y)(radius,start-angle,end-angle){amplitude}{number}{linesep}#*
\DoubleGlueArc[options%keyvals](x,y)(radius,start-angle,end-angle){amplitude}{number}{linesep}#*
\DoubleGluonArcn(x,y)(radius,start-angle,end-angle){amplitude}{number}{linesep}#*
\DoubleGluonArcn[options%keyvals](x,y)(radius,start-angle,end-angle){amplitude}{number}{linesep}#*
\DoubleGlueArcn(x,y)(radius,start-angle,end-angle){amplitude}{number}{linesep}#*
\DoubleGlueArcn[options%keyvals](x,y)(radius,start-angle,end-angle){amplitude}{number}{linesep}#*
\DashGluonArc(x,y)(radius,start-angle,end-angle){amplitude}{number}{dashsize}
\DashGluonArc[options%keyvals](x,y)(radius,start-angle,end-angle){amplitude}{number}{dashsize}
\DashGlueArc(x,y)(radius,start-angle,end-angle){amplitude}{number}{dashsize}#*
\DashGlueArc[options%keyvals](x,y)(radius,start-angle,end-angle){amplitude}{number}{dashsize}#*
\DashGluonArcn(x,y)(radius,start-angle,end-angle){amplitude}{number}{dashsize}#*
\DashGluonArcn[options%keyvals](x,y)(radius,start-angle,end-angle){amplitude}{number}{dashsize}#*
\DashGlueArcn(x,y)(radius,start-angle,end-angle){amplitude}{number}{dashsize}#*
\DashGlueArcn[options%keyvals](x,y)(radius,start-angle,end-angle){amplitude}{number}{dashsize}#*
\DashDoubleGluonArc(x,y)(radius,start-angle,end-angle){amplitude}{number}{linesep}{dashsize}
\DashDoubleGluonArc[options%keyvals](x,y)(radius,start-angle,end-angle){amplitude}{number}{linesep}{dashsize}
\DashDoubleGlueArc(x,y)(radius,start-angle,end-angle){amplitude}{number}{linesep}{dashsize}#*
\DashDoubleGlueArc[options%keyvals](x,y)(radius,start-angle,end-angle){amplitude}{number}{linesep}{dashsize}#*
\DashDoubleGluonArcn(x,y)(radius,start-angle,end-angle){amplitude}{number}{linesep}{dashsize}#*
\DashDoubleGluonArcn[options%keyvals](x,y)(radius,start-angle,end-angle){amplitude}{number}{linesep}{dashsize}#*
\DashDoubleGlueArcn(x,y)(radius,start-angle,end-angle){amplitude}{number}{linesep}{dashsize}#*
\DashDoubleGlueArcn[options%keyvals](x,y)(radius,start-angle,end-angle){amplitude}{number}{linesep}{dashsize}#*

\GluonCirc(x,y)(radius,phase){amplitude}{number}
\GluonCirc[options%keyvals](x,y)(radius,phase){amplitude}{number}
\DoubleGluonCirc(x,y)(radius,phase){amplitude}{number}{linesep}
\DoubleGluonCirc[options%keyvals](x,y)(radius,phase){amplitude}{number}{linesep}
\DashGluonCirc(x,y)(radius,phase){amplitude}{number}{dashsize}
\DashGluonCirc[options%keyvals](x,y)(radius,phase){amplitude}{number}{dashsize}
\DashDoubleGluonCirc(x,y)(radius,phase){amplitude}{number}{linesep}{dashsize}
\DashDoubleGluonCirc[options%keyvals](x,y)(radius,phase){amplitude}{number}{linesep}{dashsize}

\Photon(x1,y1)(x2,y2){amplitude}{number}
\Photon[options%keyvals](x1,y1)(x2,y2){amplitude}{number}
\DoublePhoton(x1,y1)(x2,y2){amplitude}{number}{linesep}
\DoublePhoton[options%keyvals](x1,y1)(x2,y2){amplitude}{number}{linesep}
\DashPhoton(x1,y1)(x2,y2){amplitude}{number}{dashsize}
\DashPhoton[options%keyvals](x1,y1)(x2,y2){amplitude}{number}{dashsize}
\DashDoublePhoton(x1,y1)(x2,y2){amplitude}{number}{linesep}{dashsize}
\DashDoublePhoton[options%keyvals](x1,y1)(x2,y2){amplitude}{number}{linesep}{dashsize}

\PhotonArc(x,y)(radius,start-angle,end-angle){amplitude}{number}
\PhotonArc[options%keyvals](x,y)(radius,start-angle,end-angle){amplitude}{number}
\DoublePhotonArc(x,y)(radius,start-angle,end-angle){amplitude}{number}{linesep}
\DoublePhotonArc[options%keyvals](x,y)(radius,start-angle,end-angle){amplitude}{number}{linesep}
\DashPhotonArc(x,y)(radius,start-angle,end-angle){amplitude}{number}{dashsize}
\DashPhotonArc[options%keyvals](x,y)(radius,start-angle,end-angle){amplitude}{number}{dashsize}
\DashDoublePhotonArc(x,y)(radius,start-angle,end-angle){amplitude}{number}{linesep}{dashsize}
\DashDoublePhotonArc[options%keyvals](x,y)(radius,start-angle,end-angle){amplitude}{number}{linesep}{dashsize}

\ZigZag(x1,y1)(x2,y2){amplitude}{number}
\ZigZag[options%keyvals](x1,y1)(x2,y2){amplitude}{number}
\DoubleZigZag(x1,y1)(x2,y2){amplitude}{number}{linesep}
\DoubleZigZag[options%keyvals](x1,y1)(x2,y2){amplitude}{number}{linesep}
\DashZigZag(x1,y1)(x2,y2){amplitude}{number}{dashsize}
\DashZigZag[options%keyvals](x1,y1)(x2,y2){amplitude}{number}{dashsize}
\DashDoubleZigZag(x1,y1)(x2,y2){amplitude}{number}{linesep}{dashsize}
\DashDoubleZigZag[options%keyvals](x1,y1)(x2,y2){amplitude}{number}{linesep}{dashsize}

\ZigZagArc(x,y)(radius,start-angle,end-angle){amplitude}{number}
\ZigZagArc[options%keyvals](x,y)(radius,start-angle,end-angle){amplitude}{number}
\DoubleZigZagArc(x,y)(radius,start-angle,end-angle){amplitude}{number}{linesep}
\DoubleZigZagArc[options%keyvals](x,y)(radius,start-angle,end-angle){amplitude}{number}{linesep}
\DashZigZagArc(x,y)(radius,start-angle,end-angle){amplitude}{number}{dashsize}
\DashZigZagArc[options%keyvals](x,y)(radius,start-angle,end-angle){amplitude}{number}{dashsize}
\DashDoubleZigZagArc(x,y)(radius,start-angle,end-angle){amplitude}{number}{linesep}{dashsize}
\DashDoubleZigZagArc[options%keyvals](x,y)(radius,start-angle,end-angle){amplitude}{number}{linesep}{dashsize}

\Vertex(x,y){radius}
\FCirc(x,y){radius}#*
\ECirc(x,y){radius}
\BCirc(x,y){radius}
\GCirc(x,y){radius}{grayscale}
\CCirc(x,y){radius}{bound color}{fill color}

\Oval(x,y)(half-height,half-width)(angle)
\FOval(x,y)(half-height,half-width)(angle)
\GOval(x,y)(half-height,half-width)(angle){grayscale}
\COval(x,y)(half-height,half-width)(angle){bound color}{fill color}

\EBox(x1,y1)(x2,y2)
\FBox(x1,y1)(x2,y2)
\BBox(x1,y1)(x2,y2)
\GBox(x1,y1)(x2,y2){grayscale}
\CBox(x1,y1)(x2,y2){bound color}{fill color}

\EBoxc(x,y)(width,height)
\Boxc(x,y)(width,height)#*
\FBoxc(x,y)(width,height)
\BBoxc(x,y)(width,height)
\GBoxc(x,y)(width,height){grayscale}
\CBoxc(x,y)(width,height){bound color}{fill color}

\RotatedBox(x,y)(width,height){angle}{color}
\FilledRotatedBox(x,y)(width,height){angle}{color}

\ETri(x1,y1)(x2,y2)(x3,y3)
\FTri(x1,y1)(x2,y2)(x3,y3)
\BTri(x1,y1)(x2,y2)(x3,y3)
\GTri(x1,y1)(x2,y2)(x3,y3){grayscale}
\CTri(x1,y1)(x2,y2)(x3,y3){bound color}{fill color}

\Polygon{%<(x1,y1),(x2,y2),...%>}{%<color%>}
\FilledPolygon{%<(x1,y1),(x2,y2),...%>}{%<color%>}

\LinAxis(x1,y1)(x2,y2)(divs,subdivs,hashsize,offset,width)
\LogAxis(x1,y1)(x2,y2)(divs,hashsize,offset,width)

\Text(x,y){text}
\Text(x,y)[pos]{text}
\Text(x,y)(angle){text}
\Text(x,y)(angle)[pos]{text}

\rText(x,y){text}#*
\rText(x,y)[mode]{text}#*
\rText(x,y)[mode][rotation]{text}#*

\RText(x,y)(angle){text}#*
\RText(x,y)[pos](angle){text}#*

\SetPFont{postscript font%keyvals}{size}

#keyvals:\SetPFont#c
AvantGarde-Book
AvantGarde-BookOblique
AvantGarde-Demi
AvantGarde-DemiOblique
Bookman-Demi
Bookman-DemiItalic
Bookman-Light
Bookman-LightItalic
Courier
Courier-Bold
Courier-BoldOblique
Courier-Oblique
Helvetica
Helvetica-Bold
Helvetica-BoldOblique
Helvetica-Narrow
Helvetica-NarrowBold
Helvetica-NarrowBoldOblique
Helvetica-NarrowOblique
Helvetica-Oblique
NewCenturySchlbk-Bold
NewCenturySchlbk-BoldItalic
NewCenturySchlbk-Italic
NewCenturySchlbk-Roman
Palatino-Bold
Palatino-BoldItalic
Palatino-Italic
Palatino-Roman
Symbol
Times-Bold
Times-BoldItalic
Times-Italic
Times-Roman
ZapfChancery-MediumItalic
ZapfDingbats
#endkeyvals

\PText(x,y)(angle){text}
\PText(x,y)(angle)[pos]{text}
\BText(x,y){text}
\GText(x,y){grayscale}{text}
\CText(x,y){bound color}{fill color}{text}
\BTwoText(x,y){text1%text}{text2%text}
\GTwoText(x,y){grayscale}{text1%text}{text2%text}
\CTwoText(x,y){bound color}{fill color}{text1%text}{text2%text}

#keyvals:\Line,\DoubleLine,\DashLine,\DashDoubleLine,\Arc,\DoubleArc,\DashArc,\DashDoubleArc,\Bezier,\DoubleBezier,\DashBezier,\DashDoubleBezier,\Gluon,\DoubleGluon,\DashGluon,\DashDoubleGluon,\GluonArc,\DoubleGluonArc,\DashGluonArc,\DashDoubleGluonArc,\GluonCirc,\DoubleGluonCirc,\DashGluonCirc,\DashDoubleGluonCirc,\Photon,\DoublePhoton,\DashPhoton,\DashDoublePhoton,\PhotonArc,\DoublePhotonArc,\DashPhotonArc,\DashDoublePhotonArc,\ZigZag,\DoubleZigZag,\DashZigZag,\DashDoubleZigZag,\ZigZagArc,\DoubleZigZagArc,\DashZigZagArc,\DashDoubleZigZagArc,\ArrowLine,\LongArrow,\ArrowDoubleLine,\ArrowDashLine,\ArrowDashDoubleLine,\LongArrowDashLine,\LongArrowArcn,\ArrowArcn,\LongArrowArc,\ArrowArc,\ArrowDashArcn,\ArrowDashArc,\LongArrowDashArc,\ArrowDoubleArc,\ArrowDashDoubleArc
color=#%color
colour=#%color
dsize=%<number%>
dashsize=%<number%>
sep=%<number%>
linesep=%<number%>
width=%<number%>
#endkeyvals

#keyvals:\Line,\DoubleLine,\Arc,\DoubleArc,\Bezier,\DoubleBezier,\Gluon,\DoubleGluon,\GluonArc,\DoubleGluonArc,\GluonCirc,\DoubleGluonCirc,\Photon,\DoublePhoton,\PhotonArc,\DoublePhotonArc,\ZigZag,\DoubleZigZag,\ZigZagArc,\DoubleZigZagArc,\ArrowLine,\LongArrow,\ArrowDoubleLine,\LongArrowArcn,\ArrowArcn,\LongArrowArc,\ArrowArc,\ArrowDoubleArc
dash#true,false
#endkeyvals

#keyvals:\Line,\DashLine,\Arc,\DashArc,\Bezier,\DashBezier,\Gluon,\DashGluon,\GluonArc,\DashGluonArc,\GluonCirc,\DashGluonCirc,\Photon,\DashPhoton,\PhotonArc,\DashPhotonArc,\ZigZag,\DashZigZag,\ZigZagArc,\DashZigZagArc,\ArrowLine,\LongArrow,\ArrowDashLine,\LongArrowDashLine,\LongArrowArc,\ArrowArc,\ArrowDashArc,\LongArrowDashArc
double#true,false
#endkeyvals

#keyvals:\Arc,\DoubleArc,\DashArc,\DashDoubleArc,\GluonArc,\DoubleGluonArc,\DashGluonArc,\DashDoubleGluonArc,\PhotonArc,\DoublePhotonArc,\DashPhotonArc,\DashDoublePhotonArc,\ZigZagArc,\DoubleZigZagArc,\DashZigZagArc,\DashDoubleZigZagArc,\LongArrowArc,\ArrowArc,\ArrowDashArc,\LongArrowDashArc,\ArrowDoubleArc,\ArrowDashDoubleArc
clock#true,false
clockwise#true,false
#endkeyvals

#keyvals:\Line,\DoubleLine,\DashLine,\DashDoubleLine,\Arc,\DoubleArc,\DashArc,\DashDoubleArc,\Bezier,\DoubleBezier,\DashBezier,\DashDoubleBezier
arrow#true,false
#endkeyvals

#keyvals:\Line,\DoubleLine,\DashLine,\DashDoubleLine,\Arc,\DoubleArc,\DashArc,\DashDoubleArc,\Bezier,\DoubleBezier,\DashBezier,\DashDoubleBezier,\ArrowLine,\LongArrow,\ArrowDoubleLine,\ArrowDashLine,\ArrowDashDoubleLine,\LongArrowDashLine,\LongArrowArc,\ArrowArc,\ArrowDashArc,\LongArrowDashArc,\ArrowDoubleArc,\ArrowDashDoubleArc
flip#true,false
arrowpos=%<number%>
arrowaspect=%<number%>
arrowlength=%<number%>
arrowheight=%<number%>
arrowinset=%<number%>
arrowscale=%<number%>
arrowstroke=%<number%>
arrowwidth=%<number%>
inset=%<number%>
#endkeyvals

\ArrowLine(x1,y1)(x2,y2)
\ArrowLine[options%keyvals](x1,y1)(x2,y2)
\LongArrow(x1,y1)(x2,y2)
\LongArrow[options%keyvals](x1,y1)(x2,y2)
\ArrowDoubleLine(x1,y1)(x2,y2){linesep}
\ArrowDoubleLine[options%keyvals](x1,y1)(x2,y2){linesep}
\DashArrowLine(x1,y1)(x2,y2){dashsize}#*
\DashArrowLine[options%keyvals](x1,y1)(x2,y2){dashsize}#*
\ArrowDashLine(x1,y1)(x2,y2){dashsize}
\ArrowDashLine[options%keyvals](x1,y1)(x2,y2){dashsize}
\DashArrowDoubleLine(x1,y1)(x2,y2){linesep}{dashsize}#*
\DashArrowDoubleLine[options%keyvals](x1,y1)(x2,y2){linesep}{dashsize}#*
\ArrowDashDoubleLine(x1,y1)(x2,y2){linesep}{dashsize}
\ArrowDashDoubleLine[options%keyvals](x1,y1)(x2,y2){linesep}{dashsize}
\DashLongArrowLine(x1,y1)(x2,y2){dashsize}#*
\DashLongArrowLine[options%keyvals](x1,y1)(x2,y2){dashsize}#*
\LongArrowDashLine(x1,y1)(x2,y2){dashsize}
\LongArrowDashLine[options%keyvals](x1,y1)(x2,y2){dashsize}
\LongArrowDash(x1,y1)(x2,y2){dashsize}#*
\LongArrowDash[options%keyvals](x1,y1)(x2,y2){dashsize}#*
\DashLongArrow(x1,y1)(x2,y2){dashsize}#*
\DashLongArrow[options%keyvals](x1,y1)(x2,y2){dashsize}#*
\LongArrowArcn(x,y)(radius,start-angle,end-angle)#*
\LongArrowArcn[options%keyvals](x,y)(radius,start-angle,end-angle)#*
\ArrowArcn(x,y)(radius,start-angle,end-angle)#*
\ArrowArcn[options%keyvals](x,y)(radius,start-angle,end-angle)#*
\LongArrowArc(x,y)(radius,start-angle,end-angle)
\LongArrowArc[options%keyvals](x,y)(radius,start-angle,end-angle)
\ArrowArc(x,y)(radius,start-angle,end-angle)
\ArrowArc[options%keyvals](x,y)(radius,start-angle,end-angle)
\ArrowCArc(x,y)(radius,start-angle,end-angle)#*
\ArrowCArc[options%keyvals](x,y)(radius,start-angle,end-angle)#*
\DashArrowArcn(x,y)(radius,start-angle,end-angle){dashsize}#*
\DashArrowArcn[options%keyvals](x,y)(radius,start-angle,end-angle){dashsize}#*
\ArrowDashArcn(x,y)(radius,start-angle,end-angle){dashsize}#*
\ArrowDashArcn[options%keyvals](x,y)(radius,start-angle,end-angle){dashsize}#*
\DashArrowArc(x,y)(radius,start-angle,end-angle){dashsize}#*
\DashArrowArc[options%keyvals](x,y)(radius,start-angle,end-angle){dashsize}#*
\DashArrowCArc(x,y)(radius,start-angle,end-angle){dashsize}#*
\DashArrowCArc[options%keyvals](x,y)(radius,start-angle,end-angle){dashsize}#*
\ArrowDashArc(x,y)(radius,start-angle,end-angle){dashsize}
\ArrowDashArc[options%keyvals](x,y)(radius,start-angle,end-angle){dashsize}
\ArrowDashCArc(x,y)(radius,start-angle,end-angle){dashsize}#*
\ArrowDashCArc[options%keyvals](x,y)(radius,start-angle,end-angle){dashsize}#*
\LongDashArrowArc(x,y)(radius,start-angle,end-angle){dashsize}#*
\LongDashArrowArc[options%keyvals](x,y)(radius,start-angle,end-angle){dashsize}#*
\LongDashArrowCArc(x,y)(radius,start-angle,end-angle){dashsize}#*
\LongDashArrowCArc[options%keyvals](x,y)(radius,start-angle,end-angle){dashsize}#*
\LongArrowDashArc(x,y)(radius,start-angle,end-angle){dashsize}
\LongArrowDashArc[options%keyvals](x,y)(radius,start-angle,end-angle){dashsize}
\LongArrowDashCArc(x,y)(radius,start-angle,end-angle){dashsize}#*
\LongArrowDashCArc[options%keyvals](x,y)(radius,start-angle,end-angle){dashsize}#*
\ArrowDoubleArc(x,y)(radius,start-angle,end-angle){linesep}
\ArrowDoubleArc[options%keyvals](x,y)(radius,start-angle,end-angle){linesep}
\ArrowDoubleCArc(x,y)(radius,start-angle,end-angle){linesep}#*
\ArrowDoubleCArc[options%keyvals](x,y)(radius,start-angle,end-angle){linesep}#*
\ArrowDashDoubleArc(x,y)(radius,start-angle,end-angle){linesep}{dashsize}
\ArrowDashDoubleArc[options%keyvals](x,y)(radius,start-angle,end-angle){linesep}{dashsize}
\ArrowDashDoubleCArc(x,y)(radius,start-angle,end-angle){linesep}{dashsize}#*
\ArrowDashDoubleCArc[options%keyvals](x,y)(radius,start-angle,end-angle){linesep}{dashsize}#*
\DashArrowDoubleArc(x,y)(radius,start-angle,end-angle){linesep}{dashsize}#*
\DashArrowDoubleArc[options%keyvals](x,y)(radius,start-angle,end-angle){linesep}{dashsize}#*
\DashArrowDoubleCArc(x,y)(radius,start-angle,end-angle){linesep}{dashsize}#*
\DashArrowDoubleCArc[options%keyvals](x,y)(radius,start-angle,end-angle){linesep}{dashsize}#*

\SetDashSize{number}
\SetLineSep{number}
\SetSep{number}#*
\SetWidth{number}
\SetArrowAspect{number}
\SetArrowInset{number}
\SetArrowPosition{number}
\SetArrowScale{number}
\DefaultArrowScale{number}#*
\SetArrowStroke{number}
\SetArrowSize{number}
\canvasScaleOnept
\canvasScaleObjectScale
\canvasScaleUnitLength
\SetScale{number}
\SetTextScale{number}
\SetCanvasScale{number}
\ifPSTextScalesLikeGraphics#*
\PSTextScalesLikeGraphicsfalse
\PSTextScalesLikeGraphicstrue
\SetOffset(x,y)
\SetScaledOffset(x,y)
\SetColor{color}
\SetObjectScale{number}#*

GreenYellow#B
Yellow#B
Goldenrod#B
Dandelion#B
Apricot#B
Peach#B
Melon#B
YellowOrange#B
Orange#B
BurntOrange#B
Bittersweet#B
RedOrange#B
Mahogany#B
Maroon#B
BrickRed#B
Red#B
OrangeRed#B
RubineRed#B
WildStrawberry#B
Salmon#B
CarnationPink#B
Magenta#B
VioletRed#B
Rhodamine#B
Mulberry#B
RedViolet#B
Fuchsia#B
Lavender#B
Thistle#B
Orchid#B
DarkOrchid#B
Purple#B
Plum#B
Violet#B
RoyalPurple#B
BlueViolet#B
Periwinkle#B
CadetBlue#B
CornflowerBlue#B
MidnightBlue#B
NavyBlue#B
RoyalBlue#B
Blue#B
Cerulean#B
Cyan#B
ProcessBlue#B
SkyBlue#B
Turquoise#B
TealBlue#B
Aquamarine#B
BlueGreen#B
Emerald#B
JungleGreen#B
SeaGreen#B
Green#B
ForestGreen#B
PineGreen#B
LimeGreen#B
YellowGreen#B
SpringGreen#B
OliveGreen#B
RawSienna#B
Sepia#B
Brown#B
Tan#B
Gray#B
Black#B
White#B
LightYellow#B
LightRed#B
LightBlue#B
LightGray#B
VeryLightBlue#B

\textGreenYellow
\textYellow
\textGoldenrod
\textDandelion
\textApricot
\textPeach
\textMelon
\textYellowOrange
\textOrange
\textBurntOrange
\textBittersweet
\textRedOrange
\textMahogany
\textMaroon
\textBrickRed
\textRed
\textOrangeRed
\textRubineRed
\textWildStrawberry
\textSalmon
\textCarnationPink
\textMagenta
\textVioletRed
\textRhodamine
\textMulberry
\textRedViolet
\textFuchsia
\textLavender
\textThistle
\textOrchid
\textDarkOrchid
\textPurple
\textPlum
\textViolet
\textRoyalPurple
\textBlueViolet
\textPeriwinkle
\textCadetBlue
\textCornflowerBlue
\textMidnightBlue
\textNavyBlue
\textRoyalBlue
\textBlue
\textCerulean
\textCyan
\textProcessBlue
\textSkyBlue
\textTurquoise
\textTealBlue
\textAquamarine
\textBlueGreen
\textEmerald
\textJungleGreen
\textSeaGreen
\textGreen
\textForestGreen
\textPineGreen
\textLimeGreen
\textYellowGreen
\textSpringGreen
\textOliveGreen
\textRawSienna
\textSepia
\textBrown
\textTan
\textGray
\textBlack
\textWhite
\textLightYellow
\textLightRed
\textLightBlue
\textLightGray
\textVeryLightBlue

\GreenYellow{text}
\Yellow{text}
\Goldenrod{text}
\Dandelion{text}
\Apricot{text}
\Peach{text}
\Melon{text}
\YellowOrange{text}
\Orange{text}
\BurntOrange{text}
\Bittersweet{text}
\RedOrange{text}
\Mahogany{text}
\Maroon{text}
\BrickRed{text}
\Red{text}
\OrangeRed{text}
\RubineRed{text}
\WildStrawberry{text}
\Salmon{text}
\CarnationPink{text}
\Magenta{text}
\VioletRed{text}
\Rhodamine{text}
\Mulberry{text}
\RedViolet{text}
\Fuchsia{text}
\Lavender{text}
\Thistle{text}
\Orchid{text}
\DarkOrchid{text}
\Purple{text}
\Plum{text}
\Violet{text}
\RoyalPurple{text}
\BlueViolet{text}
\Periwinkle{text}
\CadetBlue{text}
\CornflowerBlue{text}
\MidnightBlue{text}
\NavyBlue{text}
\RoyalBlue{text}
\Blue{text}
\Cerulean{text}
\Cyan{text}
\ProcessBlue{text}
\SkyBlue{text}
\Turquoise{text}
\TealBlue{text}
\Aquamarine{text}
\BlueGreen{text}
\Emerald{text}
\JungleGreen{text}
\SeaGreen{text}
\Green{text}
\ForestGreen{text}
\PineGreen{text}
\LimeGreen{text}
\YellowGreen{text}
\SpringGreen{text}
\OliveGreen{text}
\RawSienna{text}
\Sepia{text}
\Brown{text}
\Tan{text}
\Gray{text}
\Black{text}
\White{text}
\LightYellow{text}
\LightRed{text}
\LightBlue{text}
\LightGray{text}
\VeryLightBlue{text}

\AXOputPDF{pdf code}#*
\AXOputPS{ps code}#*
\AXOspecial{ps code}#*
\AssignDecDiv{variable}{integer1}{integer2}#*
\AxoPut(x,y){text}#*
\IfColor{arg1}{arg2}#S
\begin{OLDpicture}#S
\end{OLDpicture}#S
\SetPoint{name}(x,y)#*
\SetTmpBoxTwo{contents1}{contents2}#*
\SetTmpBox{contents}#*
\UseCurrentPSFont#*
\axoarrowsize#*
\axocanvas#*
\axofontsize#*
\axohelp#*
\axominusone#*
\axoone#*
\axoparray(x,y){arg}#*
\axoscale#*
\axoscalePT#*
\axoscaleTT#*
\axotextscale#*
\axounitlength#*
\axowidth#*
\axoxo#*
\axoxoff#*
\axoyo#*
\axoyoff#*
\axozero#*
\contentspdf#*
\contentspdfNoOffset#*
\defWithOption{csname}{args}{definition}#*
\defineaxofont{user-visible font name}{LaTeX font name}#*
\eind#S
\getaxohelp{csname}{spec}#*
\getoneline{csname}{input stream num}#*
\newcolor{color%specialDef}{CMYK}#*s#%color
\pfontC#S
\pfontN#S
\putLen(x,y){text}#*
\tmpfh#S
\useX{point name}#*
\useY{point name}#*
\ifAXONotImplemented#*
\AXONotImplementedtrue#*
\AXONotImplementedfalse#*
\tmpX#S
\tmpY#S
\bpinsp#*
\ptinsp#*
