/*   Theorur - A GUI for Ogg/Theora streaming
 *   Copyright (C) 2006-2009 Rafael Diniz <rafael@riseup.net>
 *
 *   This file is part of Theorur.
 *
 *   Theorur is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   Theorur is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Theorur.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <libintl.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <dirent.h>
#include <signal.h>

#ifndef __GLOBAL_H__
#include "global.h"
#endif

#ifndef __CONSTANTS_H__
#include "constants.h"
#endif

#ifndef __GTK_H__
#include <gtk/gtk.h>
#endif

#ifndef __CONFIG_FILES_H__
#include "config_files.h"
#endif

#ifndef __INTERFACE_H__
#include "interface.h"
#endif

#ifdef FUNNY
#define FUN 1
#else 
#define FUN 0
#endif

/* callback that start streaming */
void theorur_start( GtkWidget *widget, gpointer data) {
  char foo, theorur_output[512];

  /* if the first caracter of shared area is 1, means that the streaming is running and we cannot start another streaming instance */
  sscanf((char *) shared_area, "%c", &foo);
  if (foo == '1')
    return;


  /* call the function that load the values from widgets and save to the theorur config file */
  theorur_config_store(1, NULL);
  /* call the function that translate the theorur config file to the theora command */
  theorur2theoracmd_cfg();

  if ((pid = fork()) == -1) {
    printf("Fork error! God save the queen!\n");
    gtk_main_quit();
  }
  
  if (!pid) {
    /* streaming started */
    sprintf ((char *) shared_area, "11");
    system(theorur_cmd);
    /* if the system() returns, this means that the streaming stopped */
    sprintf ((char *) shared_area, "01");
    _exit(-1);
  }

  strcpy(theorur_output, gettext("-->    Command     <--\n"));
  strcat(theorur_output, theorur_cmd);
  strcat(theorur_output, gettext("\n--> Streaming command output <--\n") );

  gtk_text_buffer_set_text (buffer, theorur_output , strlen(theorur_output));
  
  /* print the streaming command output for the first time */
  usleep(200000);
  text_box_loop (1); 
}

/* callback that stop darkice */
void theorur_stop( GtkWidget *widget, gpointer data ){
  char out[32];

  reconnect_flag = 0;

  system("killall ffmpeg2theora &> /dev/null");
  system("killall oggfwd &> /dev/null");
  system("killall dvgrab &> /dev/null");

  /* now the SIGKILL stuff */
  system("killall -9 ffmpeg2theora &> /dev/null");
  system("killall -9 oggfwd &> /dev/null");
  system("killall -9 dvgrab &> /dev/null");


  strcpy(out, gettext("Streaming off") );

  gtk_text_buffer_set_text (buffer, out, strlen(out));

}

void theorur_put_in_box ( GtkWidget *widget, gpointer data ) {
  FILE *f_theorur_cfg;
  char *theorur_path;
  char foo[256] = {0};
  char server[256] = {0};
  char port[128] = {0};
  char mountpoint[128] = {0};
  char pass[128] = {0};
  char localdump_enc[256] = {0};
  char localdump_raw[256] = {0};
  char streamname[128] = {0};
  char description[256] = {0};
  char url[256] = {0};
  char genre[128] = {0};
  char aquality[128] = {0};
  char vquality[128] = {0};
  char input[128] = {0};
  char achannel[128] = {0};
  char asamplerate[128] = {0};
  char vfps[128] = {0};
  char vsize[128] = {0};
  char v4ldevice[128] = {0};
  char adevice[128] = {0};
  char public[128] = {0};
  char adddate;
  char reconnect;
  DIR *directory;

  theorur_path = (char *) gtk_file_selection_get_filename (GTK_FILE_SELECTION (file_open));
  
  if ( (directory = opendir(theorur_path))) {
    printf("Error: %s is a directory\n", theorur_path);
    closedir (directory);
    return;
  }

  if (!(f_theorur_cfg = fopen(theorur_path, "r"))) {
    printf("Error: Cannot open %s\n", theorur_path);
    return;
  }
  
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, server);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, port);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, mountpoint);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, pass);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, localdump_enc);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, localdump_raw);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, streamname);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, description);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, url);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, genre);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, aquality);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, vquality);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, input);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, achannel);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, asamplerate);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, vfps);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, vsize);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, v4ldevice);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, adevice);
  fscanf(f_theorur_cfg, "%[^=]=%[^\n]\n", foo, public);
  fscanf(f_theorur_cfg, "%[^=]=%c\n", foo, &adddate);
  fscanf(f_theorur_cfg, "%[^=]=%c\n", foo, &reconnect);


  gtk_entry_set_text ( (GtkEntry *) entry_server, server);
  gtk_entry_set_text ( (GtkEntry *) entry_port, port);
  gtk_entry_set_text ( (GtkEntry *) entry_mountpoint, mountpoint);
  gtk_entry_set_text ( (GtkEntry *) entry_pass, pass);
  gtk_entry_set_text ( (GtkEntry *) entry_localdump_enc, localdump_enc);
  gtk_entry_set_text ( (GtkEntry *) entry_localdump_raw, localdump_raw);
  gtk_entry_set_text ( (GtkEntry *) entry_streamname, streamname);
  gtk_entry_set_text ( (GtkEntry *) entry_description, description);
  gtk_entry_set_text ( (GtkEntry *) entry_url, url);
  gtk_entry_set_text ( (GtkEntry *) entry_genre, genre);
  gtk_entry_set_text ( GTK_ENTRY(GTK_COMBO(combo_input)->entry), input);
  gtk_entry_set_text ( GTK_ENTRY(GTK_COMBO(combo_achannel)->entry), achannel);
  gtk_entry_set_text ( GTK_ENTRY(GTK_COMBO(combo_asamplerate)->entry), asamplerate);
  gtk_entry_set_text ( GTK_ENTRY(GTK_COMBO(combo_vfps)->entry), vfps);
  gtk_entry_set_text ( GTK_ENTRY(GTK_COMBO(combo_vsize)->entry), vsize);
  gtk_entry_set_text ( GTK_ENTRY(GTK_COMBO(combo_v4ldevice)->entry), v4ldevice);
  gtk_entry_set_text ( GTK_ENTRY(GTK_COMBO(combo_adevice)->entry), adevice);
  gtk_entry_set_text ( GTK_ENTRY(GTK_COMBO(combo_public)->entry), public);
  gtk_entry_set_text ( GTK_ENTRY(GTK_COMBO(combo_aquality)->entry), aquality);
  gtk_entry_set_text ( GTK_ENTRY(GTK_COMBO(combo_vquality)->entry), vquality);

  if (adddate == '1')
    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON (checkbutton_adddate), TRUE);
  else
    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON (checkbutton_adddate), FALSE);

  if (reconnect == '1')
    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON (checkbutton_reconnect), TRUE);
  else
    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON (checkbutton_reconnect), FALSE);
  


  fclose(f_theorur_cfg);

  gtk_widget_hide(file_open);
  
}

void theorur_write_config ( GtkWidget *widget, gpointer data ) {
  char *theorur_path;

  theorur_path = (char *) gtk_file_selection_get_filename (GTK_FILE_SELECTION (file_save));
  if (theorur_config_store (0, theorur_path))
    gtk_widget_hide(file_save);
  
}


void theorur_about ( GtkWidget *widget, gpointer data ) {
  gtk_widget_show (dialog_about);
}

void theorur_localdump_enc (GtkWidget *widget, gpointer data){
  gtk_entry_set_text ( (GtkEntry *) entry_localdump_enc, (char *) gtk_file_selection_get_filename (GTK_FILE_SELECTION (file_localdump_enc)) );
  gtk_widget_hide (file_localdump_enc);
}

void theorur_localdump_raw (GtkWidget *widget, gpointer data){
  gtk_entry_set_text ( (GtkEntry *) entry_localdump_raw, (char *) gtk_file_selection_get_filename (GTK_FILE_SELECTION (file_localdump_raw)) );
  gtk_widget_hide (file_localdump_raw);
}

void clean_text_view_memory(){
  GtkTextIter start_iter, end_iter;

  gtk_text_buffer_get_bounds (buffer, &start_iter, &end_iter);
  gtk_text_iter_forward_lines (&start_iter, 5);
  gtk_text_iter_backward_lines (&end_iter, 5);
  gtk_text_buffer_delete(buffer, &start_iter, &end_iter);

}


gboolean status_loop (gboolean foo) {
  char status[3];
  static int alarm_id = 0;
  

  /** This checks if the status of the transmission if ON or OFF, using the shared area **/
  sscanf((char *) shared_area, "%s", status);

  /* if the update label flag is on */
  if (status[1] == '1') {
    /** streaming stopped **/
    if (status [0] == '0') {
      gtk_label_set_text(GTK_LABEL (label_status), gettext("Streaming Status: Stopped")); 
      text_box_loop(1);
      if (alarm_id)
	g_source_remove(alarm_id);

      strncpy((char *) shared_area+1, "0", 1);  

      if (reconnect_flag)
	theorur_start(NULL, NULL);
    }
    /** streaming started **/
    else {
      gtk_label_set_text(GTK_LABEL (label_status), gettext("Streaming Status: Started")); 
      text_box_loop(0);
      alarm_id = g_timeout_add (4000, (GSourceFunc) text_box_loop, 0);

      strncpy((char *) shared_area+1, "0", 1);  
    }


  }

  /* I need nothing from child, just do this to prevent <defunct> processes */
  waitpid(pid, NULL, WNOHANG);

  return TRUE;
}

#define BUFFER_SIZE 16384

gboolean text_box_loop (int option) {
  char theorur_output[BUFFER_SIZE];
  char status[3];
  int i;
  static int bytes_written = 0;

  sscanf((char *) shared_area, "%s", status);
  
  if (status[0] == '1' || option == 1) {
    
    while ( (i = read (theorur_output_fd, theorur_output, BUFFER_SIZE - 1))  && i > 0 ) {
      theorur_output[i] = 0;
      gtk_text_buffer_insert_at_cursor (buffer, theorur_output, strlen(theorur_output));
      bytes_written = bytes_written + i;

      /* 32 * BUFFER_SIZE =  */
      if (bytes_written > 524288){
	clean_text_view_memory();
	bytes_written = 0;
      }
    }
  }
  return TRUE; 
} 

/* callback que chama a funcao de saida do programa, eh issu mermo, mata tudo mermaum!! */
gboolean delete_event(GtkWidget *widget, GdkEvent  *event, gpointer data) {

  system("killall ffmpeg2theora &> /dev/null");
  system("killall oggfwd &> /dev/null");
  system("killall dvgrab &> /dev/null");

  system("killall -9 ffmpeg2theora &> /dev/null");
  system("killall -9 oggfwd &> /dev/null");
  system("killall -9 dvgrab &> /dev/null");
  gtk_main_quit ();
  return FALSE;
}

/* callback that exit without killing streaming process */
gboolean delete_event_nd (GtkWidget *widget, GdkEvent  *event, gpointer data) {
  char foo;

  sscanf((char *) shared_area, "%c", &foo);
  if (foo == '1')
    kill(pid,SIGTERM);

  gtk_main_quit ();
  return FALSE;
}

gboolean main_quit (GtkWidget *widget, GdkEvent  *event, gpointer data) {
  char status = '0';

  sscanf ((char *) shared_area, "%c", &status);

  /* if darkice is running, ask for killing it */
  if (status == '1') {
    gtk_widget_show (button_yes_theorurkill);
    gtk_widget_show (button_no_theorurkill);
    gtk_widget_show (label_theorurkill);
    gtk_widget_show (dialog_theorurkill);
  }
  else
    delete_event_nd(NULL, NULL, NULL);
  
  return FALSE;
      
}


/* function that is called when darkice is not found */
void theorurcmds_not_found() {
  char bar[192];

  /* sets up the darkice not found dialog */
  if (!FUN)
    sprintf(bar, gettext("Theorur needed commands not found!\nDownload them."));
  else
    sprintf(bar, gettext("Don't you know you should have the fucking dvgrab, ffmpeg2theora and oggfwd to run this shit!!\nGet them\n"));
  
  dialog_theorurdep = gtk_dialog_new ();
  label_theorurdep = gtk_label_new ( bar );
  button_theorurdep = gtk_button_new_with_label ( gettext("Close"));
  gtk_window_set_title(GTK_WINDOW (dialog_theorurdep), gettext("Error"));
  gtk_widget_set_size_request (GTK_WIDGET (dialog_theorurdep), 350, 200); 
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_theorurdep)->action_area), button_theorurdep, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_theorurdep)->vbox), label_theorurdep, TRUE, TRUE, 0);
  
  g_signal_connect (G_OBJECT (dialog_theorurdep), "delete_event",G_CALLBACK (delete_event), NULL);
  g_signal_connect (G_OBJECT (button_theorurdep), "clicked",G_CALLBACK (delete_event), NULL);
  
  gtk_widget_show (button_theorurdep);
  gtk_widget_show (label_theorurdep);
  gtk_widget_show (dialog_theorurdep);

  gtk_main ();

}

void theorur_detail (GtkWidget *widget, gpointer data) {
  if (show_detail) {
    show_detail = 0;
    gtk_button_set_label (GTK_BUTTON(button_detail), gettext("Show Details"));
    gtk_widget_hide (scroll_text);
    gtk_widget_hide (text);
    gtk_window_resize (GTK_WINDOW(window), SIZE_X, SIZE_Y);
  }
  else{
    show_detail = 1;
    gtk_button_set_label (GTK_BUTTON(button_detail), gettext("Hide Details"));
    gtk_widget_show (text);
    gtk_widget_show (scroll_text);
    gtk_window_resize (GTK_WINDOW(window), SIZE_X, SIZE_Y+110);
  }
}
