RabbitMQ `3.11.10` is a maintenance release in the `3.11.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.11.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.11.0)
if upgrading from a version prior to 3.11.0.

This release requires Erlang 25.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.11.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Erlang 25 as our new baseline means much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation available to all RabbitMQ 3.11 users.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.11.x/release-notes).

### Core Server

#### Bug Fixes

 * Tag changes could result in a loop of internal events in certain plugins.

   GitHub issue: [#7280](https://github.com/rabbitmq/rabbitmq-server/pull/7280)

#### Enhancements

 * Key classic mirrored queue (a deprecated feature) settings now can be overridden with
   operator policies.

   Contributed by @SimonUnge (AWS).

   GitHub issue: [#7323](https://github.com/rabbitmq/rabbitmq-server/issues/7323)


### Management Plugin

#### Bug Fixes

 * Individual virtual host page failed to render.

   GitHub issue: [#7301](https://github.com/rabbitmq/rabbitmq-server/issues/7301)

 * Individual exchange page failed to render.

   GitHub issue: [#7369](https://github.com/rabbitmq/rabbitmq-server/issues/7369)


### AMQP 1.0 Plugin

#### Enhancements

 * The plugin now supports authentication with JWT tokens (the OAuth 2 authentication backend).

   GitHub issues: [#6931](https://github.com/rabbitmq/rabbitmq-server/pull/6931), [#6909](https://github.com/rabbitmq/rabbitmq-server/issues/6909)


## OAuth 2 Plugin

### Bug Fixes

 * The `auth_oauth2.preferred_username_claims` key in `rabbitmq.conf` now accepts a list of values.

   GitHub issue: [#7458](https://github.com/rabbitmq/rabbitmq-server/pull/7458)


## Dependency Upgrades

 * `ra` was upgraded [from `2.4.6` to `2.4.9`](https://github.com/rabbitmq/ra/releases)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.11.10.tar.xz`
instead of the source tarball produced by GitHub.
